# A review of recent advances in tribology

Yonggang MENG1 , $\mathbf { J u n X U } ^ { 1 , * }$ , Zhongmin $\mathbf { J } \mathbf { I } \mathbf { N } ^ { 2 , 3 }$ , Braham PRAKASH1 , Yuanzhong HU1

1 State Key Laboratory of Tribology, Tsinghua University, Beijing 100084, China   
2 School of Mechanical Engineering, Southwest Jiaotong University, Chengdu 610031, China 3 Schoolof Mechanical Engineering, University of Leeds, Leeds LS2 9JT, UK   
Received: 25 December 2019 /Accepted: 05 February 2020   
$©$ The author(s) 2020.

Abstract: The reach of tribology has expanded in diverse fields and tribology related research activities have seen immense growth during the last decade. This review takes stock of the recent advances in research pertaining to different aspects of tribology within the last 2 to 3 years. Different aspects of tribology that have been reviewed including lubrication, wear and surface engineering, biotribology, high temperature tribology, and computational tribology. This review attempts to highlight recent research and also presents future outlook pertaining to these aspects. It may however be noted that there are limitations of this review. One of the most important of these is that tribology being a highly multidisciplinary field, the research results are widely spread across various disciplines and there can be omissions because of this. Secondly, the topics dealt with in the field of tribology include only some of the salient topics (such as lubrication, wear, surface engineering, biotribology, high temperature tribology, and computational tribology) but there are many more aspects of tribology that have not been covered in this review. Despite these limitations it is hoped that such a review will bring the most recent salient research in focus and will be beneficial for the growing community of tribology researchers.

Keywords: tribology; biotribology; lubrication; superlubricity; friction; wear, surface engineering

# 1 Introduction

In recent years, research activities in the field of tribology have grown rapidly in terms of both scope and depth. As a result, publications on experimental and theoretical research work have increased enormously in a variety of academic journals, covering phyisics, chemistry, surface science, nanotechnology, materials science and engineering, biomedical engineering, as well as mechanical and manufacturing engineering. To provide a survey on the advances in tribology research, this review paper highlights the development in lubrication, wear, surface engineering, biotribolgy, high temperature tribology, and computational tribology, based on the journal papers published in the period of 2018−2019. For the intersectional publications, the authors discussed them in either one or two categories with compromise. Due to space limitation, it has not been possible to cover all the publications in this review and undoubtedly there have been some omissions. Despite best attempts, this review paper is extraordinarily long and each of its sections has focused on a particular topic. The readers may therefore read the parts they are most interested in as it may be hard to read the entire review from the beginning to the end.

# 2 Lubrication

# 2.1 Introduction of lubrication

Lubrication has been developed greatly in the period of 2018−2019, including superlubricity, lubrication theory, new liquid lubricants and additives, new solid coatings, and measuring techniques. These developments show that tribology research is moving to new and emerging field, e.g., superlubricity, bio-lubrication, and molecular lubrication. Green lubrication, low viscosity lubricants, and lubricants for harsh environment (high temperature, ultra-low temperature, vacuum, and high pressure, etc.) have received much attentions during the past few decades. The following is a review of major developments in the field of lubrication.

# 2.2 Superlubricity

Superlubricity is the fastest developing field in tribology in recent years. It will be an important milestone in technology development. It not only reduces the friction coefficient by several orders of magnitude, but also reduces the wear and the friction induced noise greatly. Therefore, more and more tribologists are engaged in on superlubricity. Great progress has been made both in solid and in liquid superlubricity.

# 2.2.1 Solid superlubricity

# 2.2.1.1 Superlubricity of diamond-like carbon (DLC) film

DLC, one of the most exceptional solid lubricants [1, 2], is still attracting intensive research attention in the tribology community. Major achievements in the superlubricity of DLC film have been on two aspects, namely DLC-based emerging lubricants and DLC-related lubricity mechanisms.

Owing to the researchers’ concerted efforts, several new kinds of DLC-based lubricants have emerged over the year. As a common concern, all these studies shed light on the bonding states and arrangement of $\mathsf { s p } ^ { 2 } / \mathsf { s p } ^ { 3 } .$ -phases. For instance, as shown in Fig. 1,

Argibay et al. [3] found that a self-lubricating DLC nanocomposite film was in situ tribochemically formed from the ambient hydrocarbons of alcohols and alkanes on the nanocrystalline Pt−Au alloy surface. These films were extremely wear-resistant and underwent no obvious material removal even after 100,000 sliding cycles at a contact pressure of 1.1 GPa. Similarly, Wang et al. [4] developed a multi-phase carbonaceous coating containing amorphous, fullerene-like, and nano-crystalline carbons using magnetron sputtering method, which exhibited an ultralow friction coefficient of 0.05 and a low wear rate of about $1 0 ^ { - 8 } \mathrm { m m } ^ { 3 } { \cdot } \mathrm { N } ^ { - 1 } { \cdot } \mathrm { m } ^ { - 1 }$ Another research group synthesized graphite-like carbon (GLC) and fullerene-like carbon (FLC) films by different heating and cooling processes after plasma enhanced chemical vapor deposition (PECVD) [5]. Both of them were capable of bearing quite high normal loads and lowering the friction to a superlubricity state at higher contact pressure. Besides pure FLC, Wang et al. [6] designed a fluorine-containing FLC (F–FLC) film, for which the bonding structure could be tailored from fullerene-like to amorphous. Another interesting lubrication system is the combination of nanostructured DLC with ionic liquid (IL) toward low friction and anti-wear interfacial behaviors for special applications [7, 8].

With the strides in characterization techniques and simulation methods, researchers are now able to explore the lubricity mechanisms of DLC in a more elaborate way, especially the possibility to probe the sliding interface and tribo-induced products at atomic scale or even in real-time observations. All these works highlighted the critical role of tribo-induced structural changes and the in situ formed tribolayers in establishing a low-friction lubricity state. Chen et al.

![](images/2255e59586790a780078a157140dcd856fc8fa242c5348e86e330e50d002cb79.jpg)  
Fig. 1 (a) Wear-resistant $\mathrm { P t } { - } \mathbf { A } \mathbf { u }$ alloy surface lubricated from ambient trace hydrocarbons in dry $\Nu _ { 2 }$ , (b) the in situ tribochemically formed self-lubricating DLC/Pt−Au nanocomposite film. Reproduced with permission from Ref. [3]. $©$ Elsevier, 2018.

[9] proposed the combination of focused ion beam (FIB) slicing method with scanning transmission electron microscopy (STEM) and electron energy-loss spectroscopy (EELS) to detect the carbonaceous sliding interface. Their results demonstrated that this stateof-the-art technique could provide ultra-high imaging resolution and confirmed the dominating influence of tribo-induced interfacial nanostructures in governing the superlubricity for hydrogen-rich DLC films in dry sliding contact, as shown in Fig. 2.

Among the influencing factors, normal load (contact pressure), sliding velocity, temperature, and the surrounding atmosphere are playing pivotal roles in affecting the tribological performance [10]. Evidence has been collected to confirm that $\mathsf { s p } ^ { 2 }$ -rich (FLC and GLC) [5, 11] or hydrogenated DLC [12] could withstand very high contact pressure (up to $1 . 2 4 \mathrm { G P a } )$ by reconstructing the interfacial $\mathsf { s p } ^ { 2 }$ -layered structures into graphene or the formation of graphitic shells or by the stress-triggered local transformation. Liu et al. [13] investigated the velocity dependence of superlubricity stability in a wide range of $3 – 7 0 \ c m { \cdot } s ^ { - 1 }$ and found that the failure of superlubricity at high sliding velocity was due to the absence of tribolayer on contact surface rather than the flashing heat effect or the destruction of hydrogen passivation. Experimental and theoretical calculation results verified the decisive roles of fluorine and silicon in stabilizing the bonding network of the bulk film and the as-formed tribolayer by forming F–C and Si–C bonds [14, 15]. For adhesive tribocouple of DLC against alumina, a volcano-type temperature dependence (300−1,000 K) of friction was clarified from the viewpoint of tribochemical reactions [16]. The increase of friction in the range of $6 0 0 { - } 8 0 0 \mathrm { ~ K ~ }$ was attributed to the formation of ${ \mathrm { C } } { \mathrm { - } } { \mathrm { O } }$ and $\mathrm { C } { \mathrm { - } } \mathrm { A l }$ bonds along the sliding interface, and the subsequent decrease at $8 0 0 { - } 1 , 0 0 0 \ \mathrm { K }$ originated from the graphitization of DLC. As regards the ambient gaseous effects, a new set of data broadened low friction application of DLC to the carbon dioxide atmosphere through forming lactone-terminated surfaces [17]. Furthermore, Shi et al. [18] conducted comprehensive DFT calculations and demonstrated the effects of terminal states on friction behaviors of DLC in various gaseous environments. Meanwhile, they brought forward another possible strategy for hydrogenated DLC to realize superlow friction by electron lubrication. Another striking phenomenon encountered in amorphous carbon nitride film is the self-healing of lubricity state by mechanically induced material inflation [19], in which the ${ \mathrm { C - N } }$ bond breaking assisted the release of cross-linkages between ${ \mathsf { s p } } ^ { 2 }$ -sites and $\Nu _ { 2 }$ desorption from the film surface. For in situ analysis of the lubricity mechanisms, Nevshupa et al. [20] improved the mechanically stimulated gas emission (MSGE) method with much higher accuracy to detect the emitted gas species from the hydrogenated DLC and confirmed that the major emitted gases were composed of C1−C3 alkanes, of which the tribo-emission rate increased with the hydrogen and methyl terminal group concentrations. To monitor the tribo-reactions in real time, a MEMS holder developed by Sato et al. [21] enabled in situ observation of the rolling and slipping events of DLC wear nanoparticles during lateral sliding. The DLC surface underwent permanent deformation at the nanoscale when subjected to forces as small as tens of nano-Newtons. Recently, Kuwahara et al. [22] using sliding experiments of ta-C/ta-C tribopairs showed that superlubricity with negligible wear can be achieved by lubrication with unsaturated fatty acids or glycerol. Zhang et al. [23] using high-intensity pulsed ion beam irradiated WC–Ni surface against graphite under water lubrication also got significant friction reduction.

![](images/0e87ff1cd535b56be922fdc7d33f11d651cc4de91925a306f09c5c57bef07b15.jpg)  
Fig. 2 (a) BF-STEM image showing a tribolayer with thickness of ${ \sim } 2 0 ~ \mathrm { n m }$ in situ grown on the ball surface for self-mated a-C:H:Si $( 9 . 3 \ \mathrm { a t \% } $ Si) films after superlubricity test in dry $\mathrm { N } _ { 2 } ,$ and $( \mathsf { b } \mathrm { - } \mathsf { d } )$ its nanostructure revealed by BF-, HAADF-, false-colored BF-STEM and IFFT (or FFT) images. Reproduced with permission from Ref. [9]. $©$ Springer Nature, 2017.

# 2.2.1.2 Superlubricity of two-dimensional (2D) materials

Due to their weak interlayer interaction, graphite, graphene, carbon nanotubes, and other 2D materials have been reported to offer potential opportunities to achieve superlubricity [24−29]. Up to now, superlubricity has been achieved in various material systems at different length scales, revealing a series of new physical mechanisms. Following is a brief introduction of the recent advances in this complex area.

It has been theoretically proposed that heterostructures composed of 2D layers with lattice mismatch and intrinsic incommensurate interfacial geometry provide a perfect model system to achieve robust superlubricity [30, 31]. Although theoretically sound, it has been challenging to verify this mechanism experimentally, due to the fact that it is difficult to perform sliding friction tests between 2D layers. Recently, a thermally assisted mechanical exfoliation and transfer (TAMET) method has been proposed to achieve superlubricity between 2D heterostructures with friction coefficient down to the $1 0 ^ { - 4 }$ level [32], where various 2D flake-wrapped AFM tips were fabricated to directly measure the interlayer friction between 2D flakes in single-crystalline contact, as shown in Fig. 3. Also the interlayer coupling between twisted $\mathrm { M o S } _ { 2 }$ layers has been detected by using the low-frequency Raman spectroscopy, which is a reflection of interlayer shear mode and force constants [33]. Researchers have also made arduous attempts, such as AFM-based nanomanipulation experiments of gold nanoparticles sliding on HOPG [34], and the superlubricity sliding of monolayer tungsten disulfide $( \mathsf { W } S _ { 2 } )$ on epitaxial graphene grown on silicon carbon [35].

Besides the superlubricity mechanism due to incommensurate interfacial geometry within the atomically small contacts, some theoretical studies have been performed to understand new mechanisms of superlubricity. Sadeghi [36] found that superlubricity could be controlled by the multiatomic nature of nanocontacts. In this context, an increase in the layer size or the interlayer couplings could enhance the multiatomic nature and result in the reduction of friction. On the other hand, superlubricity can be achieved by pressure-induced friction collapse based on the firstprinciples calculations. Sun et al. [37] demonstrated that abnormal load dependence of atomic-scale friction in a graphene/graphene system, where the sliding friction initially increased and then decreased with increasing normal load until collapsed to a frictionless regime at a critical point. This is attributed to the transition of the sliding potential energy surface from corrugated, to substantially flattened, and eventually to counter-corrugated states.

![](images/0bb72a0954ce1d71dc84fab6e4b291e20d95fc621effd979147fcdab75fac24c.jpg)  
Fig. 3 (a) Friction between graphite flake-wrapped tip and h-BN substrate. The inset was the schematic view of the experimental tip and the substrate, (b) HRTEM images of the $\mathbf { M o S } _ { 2 }$ flake wrapped-tip. Reproduced with permission from Ref. [32]. $©$ American Chemical Society, 2018.

Besides the experimental demonstration of nanoscale structural superlubricity [25], observation of frictionless sliding in microscale and macroscale contacts has also been reported, such as self-retraction behavior in graphite mesas and intershell sliding in multiwalled carbon nanotubes [38, 39]. Recently, microscale superlubricity has been obtained at heterogeneous interface between multilayer graphene and hexagonal boron nitride in Luo’s [40] group by using a graphenecoated microsphere (GMS) probe, as shown in Fig. 4(a). This ultralow friction was attributed to the sustainable overall incommensurability due to the multi-asperity contact covered with randomly oriented graphene nanograins. Microscale superlubricity of heterojunctions between graphite and mica [41], graphite and hexagonal boron nitride [42] was also obtained based on the self-retraction behavior of graphite mesas.

Macroscopic superlubricity has been observed between diamond-like carbon films and nanoscrolls formed from graphene flakes and nanodiamond particles [43]. The same group recently demonstrated that ultra-low friction also occurs between onion-like carbon structures (OLCs) and the hydrogenated diamond-like carbon (H-DLC) surface, as shown in Fig. 5 [44]. Nanodiamonds would form OLCs catalyzed by molybdenum atoms from molybdenum disulfide. In another study, OLC films were prepared by constant current high-frequency dual-pulsed enhanced chemical vapor deposition technique, where super-low friction and wear rate were achieved due to an effect of “molecular bearing” in the friction process [45].

![](images/5d9e7c11a9fa28d962a6a6a45ee37fa651d97f2cf2b480a91e1c6582251a0e79.jpg)  
Fig. 4 (a) Friction between graphene-coated microsphere tip and h-BN substrate. The inset was the schematic view of the microsphere and substrate. Reproduced with permission from Ref. [40]. $©$ Springer Nature, 2017. (b) Schematic diagram of the experimental set-up to measure the friction in graphite/h-BN junctions, and (c) fabrication process of the graphite/h-BN heterostructure. Reproduced with permission from Ref. [42]. $©$ Springer Nature, 2018.

![](images/6e37ff956206203f7488121ee7e0d462a7284e086e1e24e71a7d5e1d37c1be60.jpg)  
Fig. 5 Macroscale superlubricity achieved by onion-like carbon formation. (a) Coefficient of friction during sliding of $\mathrm { M o S } _ { 2 }$ combined with nanodiamonds against DLC surface reaches ultralow friction values $( \sim 0 . 0 0 5 )$ , (b) observed superlubricity is attributed to the formation of onion-like carbon films, as observed in TEM images. Reproduced with permission from Ref. [44]. $©$ Springer Nature, 2018.

The microscale superlubricity of graphite can be achieved with a friction coefficient of 0.0003 by the formation of multiple transferred graphene nanoflakes through tribointeractions [46], and the superlubricity of graphite sliding against graphene nanoflake can also be achieved under ultrahigh contact pressure of up to $2 . 5 2 \mathrm { G P a }$ [47].

In 2019, there are some new works on superlubricity of 2D materials with their thickness down to few atomic layers, which show intrinsic advantages, such as atomically smooth, chemically inert, and weak interlayer van der Waals interaction, including theoretical models and experimental explorations [48, 49]. Li et al. [50] showed that the critical adhesion forces between BN and graphite, and ${ \bf M o S } _ { 2 }$ and graphite were respectively 0.953 and 1.028 times than that between graphite and graphite, which were consistent with the prediction based on Lifshitz theory. Liu et al. [51] reviewed the research and application of 2D materials in recent years.

to acid-alcohol system [66, 67], alcohol system [68], bioliquids [69], oil-based system [70], and surfactants [71]. The progress in 2018 is as follows:

# 2.2.2.1 Superlubricity of acid basic solution and ionic liquids

Ge et al. [72] made use of boric acid-polyethylene glycol aqueous solution (BA-PEG) to achieve stable superlubricity state at macro scale between $\mathrm { S i } _ { 3 } \mathrm { N } _ { 4 } / \mathrm { S i O } _ { 2 }$ surfaces. Compared with other weak acids or moderately strong acids, including acetic acid, tartaric acid, citric acid, and lactic acid, they found that boric acid was easy to achieve superlubricity state and its solution was neutral, as shown in Fig. 6. Their analysis and tests indicated that the friction reaction between lubricant molecules and solid surfaces occurred during the friction process with boric acid-polyethylene glycol aqueous solution. As shown in reaction formulas (1)−(3), hydrogen ions are produced and consumed continuously. The lubricant has the characteristics of superlubricity similar to that of phosphoric acid solution [73], and the solution is neutral as a whole.

$$
\mathrm { S i } _ { 3 } \mathrm { N } _ { 4 } + \mathrm { H } _ { 2 } \mathrm { O }  \mathrm { S i O } _ { 2 } + \mathrm { N H } _ { 3 }
$$

# 2.2.2 Liquid superlubricity

Liquid superlubricity has been proposed for more than 20 years [52−55]. Its mechanism can be summarized as hydration effect [56], chemical reaction layer [57], hydrodynamic effect [58, 59], double electric layer interaction which will be more important in superlubricity [60, 61], and the combination of multiple effects [62]. Superlubricity lubricants have been developed from pure water [63], brine [64], acids [65]

$$
\mathrm { H } _ { 3 } \mathrm { B O } _ { 3 } + \mathrm { P E G }  \mathrm { H } ^ { + } \mathrm { X } ^ { - } + \mathrm { H } _ { 2 } \mathrm { O }
$$

$$
\mathrm { H } ^ { + } X ^ { - } + \mathrm { N H } _ { 3 }  \mathrm { N H } _ { 4 } ^ { + } X ^ { - }
$$

Li et al. also used 1-ethyl-3-methylimidazoletrifluoromethane sulfonate ([EMIM] TFS) solution to achieve stable superlubricity at macro scale as shown in Fig. 7 [74]. The friction coefficient can be down to about 0.003 and the superlubricity state can be stabilized for at least $^ { 1 \mathrm { h } }$ .

![](images/ef5d30913c1ac35870bd05e0e1b7f170447e9318dbb357027e58e6951ccc4b07.jpg)  
Fig. 6 Friction coefficient of the solution of different acids with PEG. Reproduced with permission from Ref. [72]. $©$ American Chemical Soeity, 2018.

![](images/b755c4efc8b08df46a461b63a36f36c86af7965efde05de3afce1f12a57bb070.jpg)  
Fig. 7 (a) Molecular formulas of several ionic liquids and (b) corresponding friction coefficients with the ionic liquid content of $40 \mathrm { w t \% }$ , (c) XPS Spectra (N1s and S2p) of worn zone on silicon nitride ball lubricated by [EMIM]TFS aqueous solution, and (d) superlubricity model. Reproduced with permission from Ref. [74]. $©$ American Chemical Soeity, 2018.

The XPS results of [EMIM]TFS solution on the surface of silicon nitride ball after test show that there is cation ([EMIM]+) adsorption on the worn surface. The anion TFS– and wear surface formed a chemical reaction film which was identified as sulfide and produced during the friction process. The chemical reaction film and adsorption film on the worn surface provided low shear stresses and reduced friction. Based on the above analysis, a superlubricity model for the formation of adsorption film by friction induced chemical reaction is proposed by Ge et al. [72]. Recently, Xiao et al. [75] achieved water-based superlubricity with the lubrication of ${ \mathrm { H } } _ { 3 } { \mathrm { P O } } _ { 4 }$ solution in vacuum (highest vacuum degree $< 1 0 ^ { - 4 }$ torr) for the first time by performing a pre-running process in air before running in vacuum. This will create further research interest pertaining to the phosphate superlubricity.

# 2.2.2.2 Superlubricity in thin film lubrication region

Thin film lubrication was proposed by Luo’s group 20 years ago in which the main lubricating effect is from the ordered molecules, and so the shear stress should be higher than that of the fluid molecules [76, 77]. Therefore, finding ways to realize superlubricity in thin film lubrication become a great challenge for tribologists. Luo’s group successfully reduced the friction coefficient and achieved the superlubricity state under thin film lubrication conditions in 2018 [78].

In their work, the steel surfaces of the friction pair was lubricated with PEG aqueous solution in the running-in process, then changed to polarity lubricant (PAG) and non-polar lubricant (PAO), respectively. It is found that a very low friction coefficient (about 0.005) can be obtained directly, as shown in Figs. 8(a) and 8(b). Through the analysis of the worn surface, it is found that there is a layer of friction induced chemical reaction film on the steel surface after PEG running-in treatment, and the reaction film still exists after PAG (or PAO) lubrication test. The superlubricity is attributed to the interaction of chemical reaction layer, adsorption layer, and fluid layer. In addition, they also realized macroscopic superlubricity state between steel/steel surfaces by using 1,3-diketone (EPBD-02/01) with a friction coefficient of 0.006, as shown in Fig. 8(c) [79].

# 2.2.2.3 Superlubricity of hydration layer

For the first time, Han et al. achieved macroscopically superlubricity with hydrated alkali metal ions [80]. At first, the solution of phosphoric acid with $\mathrm { p H } 1 . 5$ was used for a $3 0 0 \mathrm { { s } }$ running-in process, and then the residual phosphate solution was washed out by DI water and $5 0 \mathrm { m M } \mathrm { K C l }$ solution was used as lubricant. Under $3 ~ \mathrm { N }$ load, an ultra-low friction coefficient of 0.005 was realized as shown in Fig. 9(a). The XPS analysis revealed that a soft silica layer of about $6 \mathrm { n m }$ is formed on the worn surface. As shown in Fig. 9(b), the contents of silicon dioxide in the surface layer of silicon nitride balls after the superlubricity test and that after running-in by phosphoric acid, KCl solution, KOH solution, HF acid, and the surface of the original silicon nitride ball were $5 5 . 1 \%$ , $4 6 . 0 \%$ , $2 1 . 7 \% ,$ , $5 . 9 \%$ , $2 . 1 \% ,$ and $1 0 . 1 \%$ , respectively. The content of silica is higher after running-in by the acid, which indicates that the silica layer should be formed in the acid running-in process.

![](images/4b0acb3d43a05592e0c98aaf9c7ef66707c30f37aa411a357d55edcfbde4aae2.jpg)  
Fig. 8 Friction coefficient of steel surface before and after PEG running-in treatment: (a) PAG, (b) PAO, and (c) 1,3-diketone. (a) and (b) Reproduced with permission from Ref. [78]. $©$ The author(s), 2018. (c) Reproduced with permission from Ref. [79]. $©$ Elsevier, 2018.

Finally, the realization of macroscale superlubricity of hydrated alkali metal ions depends on three aspects. One is that the acid running-in reduces the contact pressure and the surface roughness of the contact area, which is ready for the hydration effect; another is that the reaction of acid and silicon nitride to form a soft silica layer which is easy to be deformed and ensures the negative charge on the solid surface; and the third is that hydration repulsion can be carried by hydrated ions under limited conditions.

# 2.3 Lubrication and lubricant additives

# 2.3.1 Molecular lubrication

# 2.3.1.1 Ionic liquid lubrication

Ionic liquids (ILs) have excellent stability and can produce low friction. Different ILs have different molecular structures and different lubricating properties. Due to its high thermal stability and promising tribological properties, the application of ILs as boundary lubricants is becoming more and more interesting. Dašić et al. [81] have studied the influence of limiting factors on the lubrication and flow characteristics of ionic liquid by molecular dynamics simulation. It is found that in the dynamic state, the interaction between the IL molecules and the solid wall is the main driving force to control the molecular behavior of ionic liquids in the gap. The transition from a dense liquid to an ordered and possibly solidified ionic liquid is also observed under variable normal loading and shear. More and more work shows that water affects the structure and properties of ionic liquids near solid surfaces. Zhang et al. [82] studied how water affects the three-dimensional structure of the ionic liquid [BMIM] [Tf2N] near the surface of mica with two different charge densities. They found that water can not only change the ion layer near the mica surface, but also change their lateral orientation order and the aggregation of the cationic hydrophobic tail. Freita et al. [83] investigated properties of the bulk phase of the surfactant-like amphiphilic ionic liquid [C10C1Pyrr] [NTf2] and of that in the confined space as well as that on the mica interface by using molecular dynamics. The bicontinuous structure in the bulk phase and the ordered monolayer and bilayer structures spontaneously formed in the confined space are well explained.

![](images/06ea18c3de54d9a7d24ee6472aaa8aa3f02855dee50e193628414466f4c4ef3d.jpg)  
Fig. 9 (a) The stable superlubricity state with a friction coefficient of 0.005 was achieved by using KCl solution between the silicon nitride ball and the sapphire surface, (b) comparison of $\mathrm { S i } 2 \mathsf { p }$ peak of XPS on silicon nitride surface after running-in by different solutions. Reproduced with permission from Ref. [80]. $©$ American Chemical Soeity, 2018.

Khatri et al. [84] found that with the increase of alkyl chains of the fatty acid ionic liquids, the wear resistance and friction reduction properties of the liquids were improved. The results of Shi et al. [85] show that only the ionic liquid C6MIMBF4 with the long alkyl chain can obtain stable ionic liquids-based magnetic nanofluids which can be used as lubricant. An et al. [86] found that the ionic liquid, glycol ether mixtures, at titanium interfaces had a negative friction load dependence, i.e., the friction force decreased with the increase of normal load. Han et al. [87] discussed the activated slip and flow of ionic liquid lubricating molecules.

Zheng et al. [88] using acid-based ionic liquids as additives in glycerol solution improved the anticorrosion and lubrication ability of glycerol solution. Li et al. [89] has studied the synergistic effect of several proton ILs and an organic friction modifier (OFM) to achieve lower friction. Gong et al. [90] and Lhermerout et al. [91] discussed the new progress in ionic liquids. Jiang et al. [92] reported environmentally friendly ILs ([Ch][AA] ILs) derived from amino acids (AAs) and choline (Ch) synthesized by using biomaterials through a simple, green route. Their results indicated that these ILs exhibit good frictionreducing and anti-wear properties as lubricants for steel/steel contact, which is related to the formation of a physically adsorbed film on the metal surface during friction. Amann et al. [93] also reported the use of ILs as anti-wear additives. Li et al. [94] synthesized several ILs in situ with monovalent metal salts and ethylene glycol (EG) by tribochemical reactions and realized macroscale superlubricity for all ILs at silicon nitride $( \mathrm { S i } _ { 3 } \mathrm { N } _ { 4 } )$ interfaces. The combination of composite tribochemical layer (comprised of phosphates, fluorides, silica $\left( \mathrm { S i O } _ { 2 } \right)$ , and ammonia-containing compounds), hydration layer, and fluid film contributed to the superlubricity and wear protection, as shown in Fig. 10. González et al. [95] also reported the tribological performance of the IL trifluoromethylsulfonyl amide as neat lubricant and as an additive in polar oil.

# 2.3.1.2 Water-based lubrication

There is very rapid development of water-based lubrication in the field of superlubricity. Since it has been reviewed in the previous part, it will not be repeated here. Pure water as a lubricant has been studied by more and more researchers.

The tribological properties of NaCl aqueous solution on Au (111) surface have been investigated by Pashazanusi et al. [96] using AFM. It is found that when a positive potential is applied to the Au surface, a finite height and ordered ice-like water structure is formed at the interface, and a hydrogen bond is formed between the AFM tip and the film, which makes the friction coefficient very large. When negative potential is applied to the surface of $\mathsf { A u } ,$ the structure of ice-like water is destroyed, and water acts as lubricant at the interface. The friction force is low or even lower than the open circuit potential. Wu et al. [97] have investigated the influence of the bionic nonsmooth surface on glass fiber-epoxy resin composite under natural seawater lubrication. Their results show that the lubrication performance of dimpled sample is much better than that of the smooth sample under all rotational speeds and the friction reduction is approximately $4 3 . 2 9 \%$ of smooth surface.

![](images/13d19d015035ce733deafc2b425634350b8662117a8adec73f10c1f7eb00afe8.jpg)  
Fig. 10 Proposed superlubricity and antiwear model. Reproduced with permission from Ref. [94]. $©$ American Chemical Soeity, 2019.

Li et al. [98] studied the friction between graphene layers when hydrated layer was formed. By adding amphoteric ion solution, a sub-nano-hydrated layer was formed between graphene and amphoteric ions, and a very low friction coefficient of 0.001 was achieved. Li et al. [99] also studied the nanoscale self-assembled fluorinated surfactant micelle array by AFM. It was found that the micelle array would be crushed to form monolayer adsorption molecules under certain pressure, and the friction coefficient was different between the two cases.

Arif et al. [100] has investigated the effect of water intercalation on the friction behavior between graphene layers and graphene oxide (GO) layers by FFM. They found that when the interlayer adsorbed water molecules change from “ice water” into “liquid water” structure, the friction decreases. Weber et al. [101] investigated the friction properties and mechanism of ice at a temperature of $- 1 0 0 ^ { \circ } \mathrm { C }$ . The results showed that the friction coefficient at the low temperature $\left( - 1 0 0 ^ { \circ } \mathrm { C } \right)$ was very high, however the friction coefficient decreased sharply with the increase of temperature. The high mobility of mobile ice molecules and weak hydrogen bonds of molecules on the solid surface leads to easier shear, which leads to the low friction coefficient.

# 2.3.1.3 Oil-based lubrication

Oil-based lubrication occupies the main position in the field of lubrication. Low viscosity effective lubrication is the development trend. Guo et al. [102] investigated the lubrication property of oil in the cylinder liner-piston ring (CLPR) and their work indicated that the micro-concave is more favorable for improving the wear performances at the high load. The results of Zhao et al. [103] showed that the viscosity and low-temperature fluidity of the base liquid can be significantly improved by adding polymethacrylates under the condition of boundary lubrication, polymethacrylate modified lubricant exhibits better antifriction performance in a wide range of temperature and load.

The simulation works of Wang et al. [104] showed that the antiwear agent molecules with super-antiwear properties should have a structure which can be adsorbed on the metal surface stably and preferably through chemisorption. At the same time, some groups in its structure can form intermolecular hydrogen bonds, which can enhance the intermolecular force. Shi et al. [105] studied the tribological properties of polycarboxylic acid containing benzene ring plane molecules. It is found that the surface with higher friction coefficient has larger total surface energy.

In the research area of lubrication mechanism, Liang et al. [106] used relative optic interference intensities (ROII) [100] technique to measure the film thickness and study the behavior of thin film lubrication (TFL) formed by spontaneous recombination of oil at high speed. The results showed that in the oil starvation condition, lubricant molecules rearrange to form an ordered layer and a thicker critical film. Wang et al. [107] by using the relative light intensity method [76], obtained the thickness maps of the grease-lubricated films from the interferometer images captured by the two microscopes. Their test results revealed that the grease thickener’s formulation had remarkable effects on film formation and the perturbation of film thickness.

The TFL molecular model proposed in 1996 had not been validated experimentally so far. However, there has been a major breakthrough in 2019 [108, 109]. Gao et al. [108] developed a method based on surfaceenhanced Raman spectroscopy which can show both the packing and orientation of liquid molecules in the TFL regime as shown in Fig. 11. Their results indicate that the orientation of liquid molecules in central region of the gap is guided by the shear direction [109] and that of polar molecules near the solid surface $( \operatorname { A g } )$ is guided by solid material [108]. The TFL model with a nanosandwich structure consisting of an adsorbed layer, an ordered-molecule layer, and a fluid layer has been verified.

![](images/c327bf8a07ba4be7cf4ea618dc4b49b9f0c84a84104b9777d0583fcb2d7dd71a.jpg)  
Fig. 11 Raman relative intensity graphs of 6CB on different substrates under shearing. The shear-flow speed is marked at the top of each pair. (a-1)−(a-3) performed on $\mathbf { A } \mathbf { g }$ nanorod film bases, (b-1)−(b-3) performed on K9 plano-convex lens, (c-1)−(c-3) performed on flat Ag film bases. Reproduced with permission from Ref. [108]. $©$ The author(s), 2019.

Krass et al. [110] observed that on the graphite surface, the confined molecules are parallel to the surface orientation of all liquids, resulting in a layer with the thickness equivalent to the diameter of the alkyl chain. The confined cetane molecules on the surface of mica are also parallel to the surface, while the molecules in the first layer of 1-hexadecene and PAO take a more upright direction. The results of Okubo et al. [111] showed that the amorphous carbon/fatty acid interface is a thick boundary film with high molecular density, which can support sliding surface to reduce friction. Zeng et al. [112] found that the ultra-low friction in castor oil lubrication can be attributed to its degradation and oxidation induced by friction, and the repulsive force between the OH– end and solid surface. Ta et al. [113] has studied the influence of molecular structure on lubrication of aqueous triblock copolymer lubricants between rutile surfaces using molecular dynamics simulation. The shear force has a slight effect on the orientation of the molecules. Ewen et al. [114] studied the nanoscale behavior of lubricant under shear using nonequilibrium molecular dynamics simulations (NEMD). The research progress of non-equilibrium molecular dynamics of lubricants and additives and the future prospects of NEMD in tribology are also discussed. Xu et al. [115] studied the cyclohexane film on the mica surface by using molecular dynamics, and found the repulsive force between the two solid surfaces starts at about seven lubricant layers $( n = 7 )$ , and the lubricant film undergoes a sudden liquid-to-solid phase change at $n < 6$ .

# 2.3.2 Lubricant additives

The formulation of commercial lubricants ranging from automotive engines to high-performance turbines is highly complex and includes not only base oils but also a variety of additives such as anti-wear agents, friction reducers, viscosity improvers, and so on. To enhance the durability and efficiency of lubricants as well as to meet sustainable development demands regarding fuel consumption and pollution reduction, development of efficient lubricant additives has attracted significant industrial and academic attention. So far, various types of nanomaterials or compounds have been investigated in order to utilize their potential as lubricant additives. They are classified as (a) inorganic materials; (b) organic compounds; and (c) inorganic-organic hybrid material in this review. Different additives have different characteristics and improve the tribological performance in different ways.

These are elaborated further in the following section.

# 2.3.2.1 Inorganic additive

The commonly used inorganic nanomaterials can be briefly summarized as two-dimensional materials and other dimensional materials. The two-dimensional materials mainly include graphene [116], boron nitride [117], ${ \bf M o S } _ { 2 }$ [118], and other 2D materials [119–121]. The other materials concentrate on metallic or nonmetallic nanoparticles [122, 123], metallic or nonmetallic oxides [124, 125], and inorganic nanocomposites [126]. Therefore, this section is divided into two parts, namely two-dimensional materials and other dimensional materials.

2D Materials, as a shining star in various fields, also possess excellent anti-friction properties because of the enhanced film formation [127, 128], the self-healing or mending effects [129], and the ball bearing effect [130]. The liquid lubrication with additives of graphene class materials attracted a lot of attention recently. For instance, a robust macroscale superlubricity state $\langle \mu = 0 . 0 0 3 7 \rangle$ , by taking advantage of the synergy effect of graphene oxide (GO) nanoflakes and ethanediol between the surfaces of $\mathrm { S i } _ { 3 } \mathrm { N } _ { 4 }$ and $\mathrm { S i O } _ { 2 }$ was reported [131]. Chemically-modified GO in hydrophobic ionic liquids [132], 4-n-pentyl- $\cdot 4 ^ { \prime }$ -cyanobiphyl liquid crystal (5CB) added with graphene [128], graphene sheets anchored with molybdenum disulfide $( \mathrm { M o } { \cal S } _ { 2 } )$ nanoflowers [133], ILs with graphene [134, 135], chemicallybonded phosphorus-graphene hybrid [136], alkyl phosphate modified graphene oxide [137], and polyhedral oligomeric silsesquioxane (POSS) grafted graphene oxide [138], were synthesized and used as liquid lubricants or additives. The research on transition metal disulfides (TMDs) liquid additives, especially ${ \bf M o S } _ { 2 } ,$ mainly focused on the preparation of functional ${ \bf M o S } _ { 2 }$ nanosheets [118, 139], ${ \bf M o S } _ { 2 }$ nanotubes [140, 141], hollow fullerene-like ${ \bf M o S } _ { 2 }$ [142], $\mathrm { F e } _ { 3 } \mathrm { O } _ { 4 } @ \mathrm { M o S } _ { 2 }$ core-shell nanocomposites [143], and $\mathrm { M o S } _ { 2 }$ /montmorillonite nanocomposites [144], etc. A new 2D-layered material, black phosphorus (BP), has been used as liquid lubricant additives recently [119]. Wang et al. [145] utilized black phosphorus (BP) as an excellent water-based lubricant additive and significantly reduced friction and achieved superlubricity $( \mu = 0 . 0 0 0 6 )$ in ball-on-plate tribometer. The conditions for achieving superlubricity are relaxed, including a wide range of additive concentrations, contact pressures, and sliding velocities. The extremely low shear resistance of the water layer retained by the ultrafine BP nanosheets modified by NaOH is responsible for an excellent tribology property, as shown in Fig. 12 [145]. Wu et al. [146] demonstrated that degradation of BP nanosheets favored the lubrication properties, as shown in Fig. 13. Specifically, the friction force could reduce by about $5 0 \%$ at the degraded area of the BP nanosheets due to the phosphorus oxides formed after degradation. Although to a lesser extent than graphene and ${ \bf M o S } _ { 2 } ,$ other 2D materials, such as boron nitride, h-BN [147, 148], $\mathrm { M g / A l }$ layered double hydroxides (LDHs) [149], $\mathrm { T i O } _ { 2 } / \mathrm { T i } _ { 3 } \mathrm { C } _ { 2 } \mathrm { T } _ { x }$ hybrid nanocomposites [150], have also been investigated as liquid lubricant additives.

![](images/efd959fcb27bfe74b14ed6df15319c0e9ac092c4ce8c7d06d39b87c3113db422.jpg)  
Fig. 12 Superlubricity in the aqueous solution with BP-OH nanosheets. Reproduced with permission from Ref. [145]. $©$ American Chemical Soeity, 2018.

Recently, more and more 2D materials have been studied as lubricant additives. Tang et al. [151] reported layered $\mathbf { M o O } _ { 3 }$ as a lubricant additive exhibits good anti-friction and anti-wear properties. It is also found that the smaller the size of $\mathbf { M o O } _ { 3 }$ layer, the better the friction-reducing effect. Liu et al. [152] fabricated the composite nanosheets of graphene and boron nitride using high-energy ball milling in ammonia gas and investigated its anti-wear properties as a lubricant additive in mineral base oil. Their experimental results showed that the stronger interaction between graphene and BN nanosheets exhibit better wear resistance and friction reduction properties. Ba et al. [153] reported that the layered double hydroxide/graphene nanosheets and layered double hydroxide/molybdenum disulfide were successfully prepared by electrostatic self-assembly. The composite nanoparticles have good dispersion stability in the base oil. At the same time, the nanocomposites significantly improve the lubricating properties of the base oil due to the synergistic lubrication between LDH and GO or ${ \bf M o S } _ { 2 }$ . Chen et al. [154] successfully prepared a synthetic oil-soluble ultra-thin ${ \bf M o S } _ { 2 }$ sheet as lubricant additive and investigated the wear behavior under about 1 GPa pressure. Because of the uniform dispersion of molybdenum disulfide, wear can be controlled as long as the actual pressure is less than the fracture strength of ${ \bf M o S } _ { 2 }$ .

There are a number of promising nanoparticles as lubricant additives for friction and wear reduction because they can intensely interact with substrates and exhibit potential to form protective tribofilms on the surfaces of rubbing materials [140, 155−158]. Borda et al. [159] investigated the influence of copper nanoparticle additives on the tribological performance of mineral and synthetic ester base oils using a tribometer with pin-on-disk and four-ball configuration. Their results indicated that the copper nanoparticles improved the tribological properties of mineral oil whereas it is disadvantageous for use in synthetic polar oil. Wang et al. [160] successfully prepared the novel carbon nanoparticles co-doped with sulfur and nitrogen from rice husk powder by hydrothermal reaction. As a lubricating additive for polyethylene glycol (PEG200) base oil, the friction film containing sulfide and metal oxide have excellent lubricating properties under different loads. Lu et al. [161] demonstrated that ${ \sf W S } _ { 2 }$ and $\mathrm { T i O } _ { 2 }$ composite nanoparticles have a great influence on the tribological properties of diisooctyl sebacate (DIOS). Composite nanoparticles significantly improve the wear resistance of DIOS. Compared with pure DIOS, the wear amount is reduced by about $8 1 \%$ . Kumara et al. [162] reported that adding $0 . 5 { - } 1 . 0 ~ \ \mathrm { w t \% }$ dodecanethiol-modified palladium nanoparticles to a lubricating oil leads to a significant reductions in friction and wear by up to $4 0 \%$ and $9 7 \%$ , respectively, and the formation of unexpected 10 times thicker $( 2 { - } 3 ~ \mu \mathrm { m } )$ tribofilm in boundary lubrication. Further investigation suggested that such an ultrathick tribofilm dominated by $\mathrm { P d } / \mathrm { S }$ compounds is responsible for the superior lubricating behavior, as shown in Fig. 14. Zhao et al. [163] prepared water-soluble Cu nanoparticles of size approximately $3 \mathrm { n m }$ at room temperature via in-situ surface modification. The tribological behavior of such Cu nanoparticles as an additive in distilled water can significantly improve the tribological properties of distilled water and the lowest friction coefficient of 0.06 was obtained via lubrication with a concentration of $0 . 6 ~ \mathrm { w t \% }$ of ${ \mathrm { c u } }$ nanoparticles in distilled water, which is a reduction of $8 0 . 6 \%$ compared with that obtained via lubrication with distilled water alone.

![](images/3df18704c62952ec5c62538be5ca12eebedb5aad83caedd0b8ec14aa02658018.jpg)  
Fig. 13 Degradation of BP nanosheets favored the lubrication properties. Reproduced with permission from Ref. [146]. $©$ American Chemical Soeity, 2018.

# 2.3.2.2 Organic additive

The most popular organic additives in recent years are ionic liquids and hydrogels. Ionic liquids are commonly used as industrial lubricants or lubricant additives [89, 164, 165]. While hydrogels have good biocompatibility and thus they are commonly used for bio-lubrication. Advances of researches on ionic liquid additives have been mentioned afore, and hence hydrogel and other organic additives will be addressed as below.

![](images/8e146cd58cd1446a92da41db3ec87794002f763898c001d17d7121c54b106924.jpg)  
Fig. 14 The image and composition of the ultrathick tribofilm. Reproduced with permission from Ref. [162]. $©$ American Chemical Society, 2018.

Hydrogels play an important role in reducing friction between soft biological contacting surfaces. The use of hydrogels as biolubricant additives has recently been investigated extensively in biomaterial science research due to their nontoxicity and excellent anti-friction performance. Xu et al. [166] reported that the thermally responsive microgel is used as lubricant additive for aqueous solutions. The microgel rolls and slides between the frictional interfaces, exhibiting the temperature-dependent friction-reducing and anti-wear properties. Torres et al. [167] synthesized starch-based emulsion microgel particles with different starch (15 and $2 0 \ \mathrm { w t \% }$ ) and oil contents $( 0 { - } 1 5 ~ \mathrm { w t \% } )$ and investigated their lubrication performance under physiological conditions using smooth hydrophobic polydimethylsiloxane ball-on-disc tribological tests. The combined results of experiment and theoretical calculations suggested that the mechanism behind the improved lubrication property was the release of the emulsion droplets triggered by the synergy of enzyme and shear, as shown in Fig. 15.

Other types of additives mainly include oil-miscible polymer compounds or materials, which are used extensively and perform well as viscosity index improvers and pour point depressants along with improvement of tribological properties [168–172]. Singh et al. [173] synthesized three copolymeric additives utilizing the C18 alkyl acrylate (C18Ac) and N,N-dimethylacrylamide (DMAA) monomers by varying the ratio between C18Ac:DMAA. All the synthesized polymers in polyol base oil revealed excellent performance in viscosity index improver, antiwear, antifriction, and anticorrosion. Xu et al. [174] demonstrated that molybdenum dialkyldithiocarbamate has excellent friction reduction properties in boundary lubrication, and the distribution of modified lubricating additives on the contact surface is closely related to tribological performance. Dubey et al. [175] reported that PTFE nanoparticles in suspension exhibit excellent extreme pressure properties through using polyisobutylene succinimide as a dispersant to improve the dispersion stability in oil.

![](images/bac0e09d0381cdaa9f47028cf35731ddae9c0cda37c6b88ebb80cdf76e6d4537.jpg)  
Fig. 15 The lubrication performance of emulsion microgel particles under physiological conditions. Reproduced with permission from Ref. [167]. $©$ American Chemical Society, 2018.

# 2.3.2.3 Inorganic-organic hybrid additive

When inorganic and organic materials are combined, the advantages of both, such as high pressure resistance of inorganic materials and good rheology property of organic additives, can be fully utilized [176–178]. Van Ravensteijn et al. [179] prepared the (hybrid) star polymers carrying a silicate-based core and used it as additive in a commercial base oil (Yubase 4). The experiment results showed the single additive achieving all three functions—friction reduction, wear protection, and viscosity improvement. The enhanced performance is most likely dominant by attractive forces between the silicate cores and the metallic surfaces and the branched architectures of polymer which prohibit ordering of the additives in thin films under high-load conditions. Bai et al. [180] successfully integrated ${ \bf M o S } _ { 2 }$ and polyamide as the solid lubricants materials by laser sintering. The friction coefficient and wear rate after the additive were used during the linear reciprocating motion are reduced by an order of magnitude.

Seymour et al.’s experiment results [181] indicated hairy NPs with sufficiently long alkyl pendant groups could form clear, homogeneous dispersions in poly(alphaolefin) (PAO) at low and high temperatures, exhibiting significant reductions in both the coefficient of friction (up to $3 8 \%$ ) and wear volume (up to $9 0 \%$ for iron flat) compared with neat PAO. They utilized the combination of poly(lauryl methacrylate) brushgrafted silica nanoparticles (hairy NPs or HNP) and phosphonium-phosphate IL as a friction-reducing additive in polyalphaolefin (PAO) oil and the results showed the improved lubricating performance, as shown in Fig. 16 [182].

# 2.4 Lubrication of surface coatings

Coating technology has very important role in tribology field. Only in 2018, the number of frictionrelated coating papers exceeded 5,000, among which more DLC-related coatings were investigated. Some of the coatings associated with superlubricity have been introduced in the superlubricity section and are not covered in detail again. Here, several new advances in tribological-related coating technology are briefly introduced, such as oxide coating [183–186], metal coating [187, 188], composite coating [183, 185, 189, 190], ceramic coating [191, 192], and so on.

![](images/09e188c79d3814c63f9c0c751e837c6a3f0585f097027e24edcd4a4069edd90e.jpg)  
Fig. 16 The hairy NPs combined with IL as a friction-reducing additive in PAO. Reproduced with permission from Ref. [182]. $©$ American Chemical Society, 2018.

Wang et al. [183, 189] designed and prepared carbon nanotubes reinforced $\mathrm { T i O } _ { 2 }$ coatings, and found that a small content of CNTs could enhance the tribological properties of plasma sprayed ceramic coating remarkably, indirectly by influencing microstructure of coating and directly by tribo-effects of CNTs during tribotest, including structure strengthening, triboreorientation, tribo-protruding, tribo-film, and tribodefection as shown in Fig. 17.

Yang et al. [185] report a novel TiMoN/a-MoSx composite coatings with TiMoN solid solution grains embedded into ${ \bf M o S } _ { x }$ -based amorphous matrix synthesized through magnetron co-sputtering technology, and superhardness and excellent toughness can be achieved with an ultra-low wear rate of $2 { \times } 1 0 ^ { - 1 1 } \mathrm { m m } ^ { 3 } / ( \mathrm { N } { \cdot } \mathrm { m } )$ in air and a low friction coefficient of 0.1. Liu et al. [186] discussed as to how to remove the oxide film from the surface of pure iron on nanoscale and found that the mechanical strength of the outer layer is much higher than that of the inner layer which is quite close to that of the pure iron substrate.

Kiran et al. [187] investigated the sliding wear characteristics of as-deposited and heat-treated electroless Ni−P coatings against AISI E52100 steel ball. Zhou et al. [188] investigated the self-loosening of threaded fasteners subjected to dynamic shear load with three kinds of typical coatings, PTFE, ${ \bf M o S } _ { 2 } ,$ and TiN applied to bolts and nuts. Wang et al. [190] reported that the friction coefficient of carbon fiber-reinforced polyetheretherketone (CFRPEEK) is the lowest and fluctuates at approximately 0.11 and it has the lowest wear rate of $2 { \times } 1 0 ^ { - 5 } \ \mathrm { m m } ^ { 3 } / ( \mathrm { N } { \cdot } \mathrm { m } )$ among the experimental materials, including CFRPEEK, carbon fiberreinforced polyamide-imide, polytetrafluoroethylene, polyoxymethylene, polyetheretherketone (PEEK), acrylonitrile butadiene styrene resin, and glass fiberepoxy resin under seawater lubrication. Wang et al. [191] presented the aqueous lubrication of tribopairs formed by PEEK and PI material sliding against $\mathrm { S i } _ { 3 } \mathrm { N } _ { 4 }$ ceramic. Their experimental results indicated that water as a lubricant for the $\mathrm { P I } { - } \mathrm { S i } _ { 3 } \mathrm { N } _ { 4 }$ tribopairs effectively reduces both friction coefficients by $3 5 . 5 \%$ and wear rates by $3 2 \%$ which is due to dimples appearing on the PI tribopair surfaces under water which generated additional hydrodynamic lubrication and further improved the friction properties of surface. Datta et al. [192] have investigated mechanical, wear, corrosion, and biological properties of arc deposited titanium nitride coatings and showed that cathodic arc deposited TiN coatings can be achieved by minimizing/eliminating coating defects which accelerated the localized damage during articulation.

![](images/0baff9896320f4276c1ddf9adebc980245f21c26a068b740206cec61624b095d.jpg)  
Fig. 17 Schematic illustration to reveal the CNTs induced wear mechanism for plasma sprayed ceramic coating: (1) structure strengthening, (2) tribo-protruding of CNTs, (3) tribo-reorientation of CNTs, (4) tribo-film of CNTs, and (5) tribo-defection of CNTs. Reproduced with permission from Ref. [183]. $©$ Elsevier, 2018.

# 3 Wear and surface engineering

# 3.1 Introduction of wear and surface engineering

In this section, research progress in wear and surface engineering is highlighted. The survey is limited to the papers published in the journals of Friction, Journal of Friction and Wear, Journal of Tribology, Proc. IMech. Part J: Journal of Engineering Tribology, Tribology International, Tribology Letters, Tribology Transactions, and Wear in the period of 2018−2019. The research work on lubrious solid coatings is reviewed in the preceding section of 2.4 (Lubrication of surface coatings), while the coatings dedicated to biomedical engineering and high temperature applications are to be discussed in the sections of biotribology and high temperature tribology, respectively. Some theoretical work on wear mechanisms are discussed in this section as well as in the section of computational tribology.

# 3.2 Wear mechanisms, modeling, and monitoring

Wear of materials always accompanies friction and, often causes early failures of machines components. Wear modes are diverse, depending on mating materials, working load, relative motion mode and speed, temperature, lubrication conditions, and environment. Therefore, wear mechanisms change case by case, and predictive and quantitative modeling of wear process is extremely difficult, comparing with contact mechanical problems, hydrodynamic or elastohydrodynamic lubrication and kinetic friction modeling. On the other hand, on-line monitoring of wear processes is becoming increasingly important and popular in industry for the purpose of conditionbased equipment maintenance. Here research progress in wear behavior, mechanisms, modeling, and monitoring are briefly reviewed based on the publications in 2018 and 2019.

# 3.2.1 Wear behavior and mechanisms

A lot of research and development have been devoted to high wear resistant alloys. Yi et al. [193] reported that addition of a small amount of ${ \mathrm { c u } }$ and $\mathrm { N i }$ into $\scriptstyle { \mathrm { F e - B - C r - C } }$ based alloy can change the ratio of volume fraction of martensite to pearlite, $V _ { \mathrm { m } } / V _ { \mathrm { p } } ,$ and with the increase in $V _ { \mathrm { m } } / V _ { \mathrm { p } }$ the abrasion resistance of the alloy increases at the normal load of $7 ~ \mathrm { N }$ in pin-on-disk two-body abrasive wear test. At a higher load of $3 0 \mathrm { N } ,$ however, the wear resistance decreases. They also found that the wear mechanism is different at different load conditions. At the low load, micro-cutting is dominant, while wear shifts to a mixed mode of micro-cutting and micro-ploughing when the load is high. Huang et al. [194] added (Ti, Mo)C particles to NM500 low alloy wear resistant steel to improve its abrasion resistance. They used dry sand rubber wheel abrasion wear test to compare the three-body abrasive wear resistance between NM500 steel and (Ti, Mo)Creinforced steel under applied loads of 45 and $^ { 1 3 0 \mathrm { N } }$ . They reported that the wear resistance of the particlereinforced steel is 1.6 times that of NM500 at the heavy load of $^ { 1 3 0 \mathrm { N } }$ and 1.8 times at the light load of $4 5 \mathrm { N }$ . In Ref. [195], TiC particles were also added into $\mathrm { R } Z 5 \mathrm { M g }$ alloy to improve its mechanical strength and wear resistance. They used a self-propagating high temperature synthesis technique to make the composite and tested the reinforced $\mathrm { M g }$ alloy by using a pin-on-disk tribometer under dry abrasive wear conditions. The effects of applied load, sliding distance, and TiC particle concentration on friction coefficient and weight loss of the composite were reported.

On the other hand, abrasive wear is widely utilized in polishing of precisionparts. Nguyen et al. [196] investigated the wear mechanism of abrasive polishing and slurry jet impact of reaction bonded SiC which is to be used for the construction of space optical devices and telescopes. They found that diamond abrasives polish the surface with brittle fractures of SiC phase while the silicon phase is mainly plastically deformed and embedded onto surface of the fractured SiC. When softer abrasives are supplied by slurry jet on the surface, wear takes place at lower pressure through weakening the Si bond by erosion and wedging. They concluded that the reaction bonded SiC can be polished without any surface damage by using lowpressure alumina slurry jet. Lin et al. [197] performed experiments of chemical mechanical polishing of silicon wafer and proposed a theoretical model for predictions of average abrasive removal depths and surface morphology. By taking the effect of chemical reaction of slurry into account, the proposed model gives reasonable simulation results which are in accordance with experimental ones.

For rolling contact components such as rolling element bearings, gears, and wheels, fatigue wear is a common failure mode. In hybrid ball bearings, made of steel raceways and silicon nitride balls, the rolling contact fatigue of silicon ball as well as steel raceways is critical for the lifetime of bearings. Kanematsu published a review article [198] on the testing methods and crack propagation analysis of silicon nitride. The Refs. [199] and [200] investigated experimentally the rolling contact fatigue of railway wheels. In Ref. [199], two kinds of wheel materials, CL60 and AAR-D, were tested on a small-scale rolling-sliding wear apparatus against a simulative rail made of U75V steel. They measured traction coefficient and wear rate as well as recorded surface damages during testing. It is found that wear rate changes with the increase of slip ratio in different ways, linear increase (slip ratio $< 6 \%$ ), nonlinear increase $6 \% <$ slip ratio $< ~ 1 8 \%$ ), and undefined way (slip ratio $> 1 8 \%$ ) where the two wheel materials show totally different tendency. By linking the wear debris and surface damage analyses, revealed the wear mechanisms transition from oxidative wear to fatigue wear and then back to oxidative wear with the increase in slip ratio. Faccoli et al. [200] investigated the effect of desert sand on wear and rolling contact fatigue of the railway wheels made of ER8, CLASS C, SANFLOS\* S, and SANDLOS\* H, respectively. They used a two-disc testing machine with a sand feeder to measure the weight loss against rolling cycles. Their results showed that the sanding accelerated the wear by a factor from 1.4 for SANDLOS\* H discs to 2.2 for ER8 and CLASS C discs. They attributed the effect of sanding to the high plastic flow occurred underneath the contacting surface induced by the high local pressure due to the interposed sand particles between the two discs. FEA analysis was used to support their explanation. Spalling fatigue wear was also found in scrap shear blades made of NiCrVMo and CrB containing steels [201].

Fretting wear is another failure mode of materials, under which adhesion, oxidation, and fatigue of materials happen consequently or simultaneously. Dréano et al. [202] investigated the fretting wear of HS25 cobalt-based alloy at low-to-medium temperature conditions and established a tribo-oxidation abrasive wear model to predict the wear rate. The experiments were conducted on a cross-cylinder contact configuration with gross-slip. They found a high wear rate at the temperature condition due to lacking of formation of glaze layer during fretting, and the proposed model has a good correlation with the experimental observations. In Ref. [203], the fretting wear of Zircaloy-4 was studied. A unique test rig with four sets of prod-and-slider face-to-face contact was used for fretting tests, and the wear coefficients under different strokes were measured. Meanwhile, the surface topography of worn surface was characterized on a confocal laser microscope and a scanning electron microscope. Fractal analysis and FEM rough surface contact analysis were also performed to explain the experiment results. In Ref. [204], the fretting performance of $\mathrm { M g { - } } S \mathrm { n { - } } Y$ alloy was evaluated under fluids lubrication, and the fretting mechanism was explored in detail via analysis of wear track/debris using SEM and XPS depth profile. The results illustrated that the friction reduction was superior to wear resistance for lubricated Mg–Sn–Y/Steel contact under fretting conditions, mainly depending on the oil-film induced transformation of fretting running regime and transition of fretting wear (from adhesive/ oxidation wear and delamination under dry friction to abrasive wear and delamination under fluids lubrication). ZrN coating was applied to prevent fretting wear of a wheel/axle push fit joint in a rail vehicle [205]. Wear tests of a joint loaded with a vertical force were conducted on a fatigue testing machine permitting oscillatory tangential displacement, which is responsible for the development of fretting wear, and wear resistance of uncoated and coated shafts was compared. It was demonstrated that a significant mitigation of fretting wear could be achieved with the $\mathrm { Z r N }$ coatings. The evolution of mechanical properties and microstructures of tribologically transformed structure (TTS) layers during fretting process were investigated using nanoindentation and focused ion beam-scanning electron microscope (FIB-SEM). A modified wear model that accounts for friction-induced dynamic changes in mechanical properties was proposed [206]. In Ref. [207], an experimental study was described on the fretting wear and frictional mechanism of interface between spiral wound gasket (SWG) and flange. The results showed that the gasket winding structure affects the variation of the friction coefficient fluctuation. To investigate the wear mechanism at the contact interface of the blade shroud in steam turbines, two base alloy steels were tested under different conditions: surface treatment (with and without laser quenching), temperature, and normal load on a fretting test-rig. Comparison of volume losses at room and low temperature showed that at $1 5 0 ^ { \circ } \mathrm { C }$ the volume losses decreased dramatically [208].

Percussion wear, or impact wear in other words, occurs when a solid surface is impinged on repeatedly by other objects. If a large number of small particles impact on a surface continuously with high velocity, erosive wear appears. The Refs. [209] and [210] investigated impact wear and erosive wear respectively. In Ref. [209], a modified Archard adhesive wear equation was used to evaluate wear over impact, and an impact wear tester was used to validate the predictive model. While in Ref. [210], the effect of abrasive/material hardness ratio, $H _ { \mathrm { a } } / H _ { \mathrm { m } } ,$ on erosion wear was addressed. Solid particle erosion wear tests were performed with three types of abrasives and several different types of heat treatments and materials to obtain 11 different $H _ { \mathrm { a } } / H _ { \mathrm { m } }$ ratios. A moderate wear regime was observed when $H _ { \mathrm { a } } K _ { \mathrm { I C _ { \mathrm { - } } a b r a s i v e } } / H _ { \mathrm { m } }$ ratio (KIC_abrasive is the fracture toughness of the erodent material) is less than 2, while a moderate-severe transition regime was observed when the ratio is between 2 and 4. A $1 0 ~ { \mu \mathrm { m } }$ -thick ${ \mathrm { Z r C } }$ ceramic coating with grain size of $6 \ \mathrm { n m }$ was prepared on bare 316 stainless steel using double glow discharge sputter technique, and its cavitation erosion resistance was characterized by the combination of an ultrasonic vibration system with an electrochemical workstation [211]. The results showed that the volume loss of the ${ \mathrm { Z r C } }$ nanoceramic coating was only $4 6 \%$ of the 316 stainless steel after cavitation test, and erosion damage of the ${ \cal Z } \mathrm { r } { \cal C }$ nanoceramic coating was significantly decreased as compared to the uncoated 316 stainless steel. In Ref. [212], two standardised solid particle erosion test rigs, ASTM C704 and GOST 23.201, usable for refractories with different working principles, were compared. Comparison tests showed similar results at shallow impact angle for materials featuring a slight difference in wear resistance between phases, while for materials containing sufficiently harder phases, the GOST produced lower wear rates.

In aerospace and internal combustion engines, machine elements suffer from high temperatures, which affects wear behavior of materials remarkably. In Ref. [213], two types of finger seal used in aeroengine were tested at cold (283 K) and hot (433 K) states. Leakage and wear were measured under different pressure ratios and rotating speeds (up to $5 , 0 0 0 \mathrm { r p m } ,$ ). It is found that the finger seal with doublelaminate showed lower leakage at the cold state while the finger seal with triple-laminate performed better at the hot state. Wear of the finger seal at the hot state was more severe than that at the cold state. In Ref. [214], cast iron cylinder wear was experimentally investigated in a four-cylinder automotive internal combustion engine. Local wear of cylinder at the topdead-center (TDC) and bottom-dead-center (BDC) positions was compared under two test conditions, one was fueled with local gasoline and the other was fueled with ethanol. The test results showed that ethanol fuel resulted in the highest local wear at the BDC, which was caused by the three-body abrasion by carbon residuals and piston ring particles. Wang et al. [215] compared tribological behavior of $\mathrm { T i } _ { 2 } \mathrm { A l N }$ reinforced TiAl composite with TiAl alloy on a ballon-disk tester at temperatures ranging from room temperature to $8 0 0 ^ { \circ } \mathrm { C }$ . They found that $\mathrm { T i } _ { 2 } \mathrm { A l N }$ reinforced TiAl showed lower friction and higher wear resistance than TiAl alloy at the test temperatures, and wear mechanism transformed from abrasive wear to adhesive wear along with the increase in temperature for the tested materials.

In metalworking processes, wear of tools is an important issue. For example, in direct press hardening, metal sheet is formed at high temperature (typically $7 0 0 \mathrm { - } 7 5 0 ^ { \circ } \mathrm { C } )$ with dies and then directly quenched. During consecutive forming, material transfer and galling occur under high temperatures. Two sets of scratch tests were performed to study the galling behavior in sheet metal forming using force and acoustic emission sensors [216]. In the first test set, scratch tests were performed at a different depth of penetration to segregate the non-galling and galling conditions. In the second test set, scratch tests were performed at a different sliding distances to understand the influence of galling on the abrasive wear modes. Sahlot and Arora [217] developed a numerical model for prediction of tool wear during friction stir welding of $\mathrm { C u C r Z r }$ alloy. Tool wear and worn-out pin profile were calculated according to a modified Archard wear equation. The calculated worn-out pin profile was validated with experimental measurements. In Ref. [218], tool wear in ultrasonic machining process was studied with numerical simulation method. Additively manufactured (AM) tool steel samples prepared by using selective laser melting (SLM) were tested on pin-on-disc tester in contact with aluminum alloy pin at the similar temperature conditions as in hot forming of aluminum alloys. Profilometric investigations revealed that the wear tracks were wide and shallow, with the greatest width being detected at $4 5 0 ^ { \circ } \mathrm { C }$ and the deepest wear track at $4 0 0 ^ { \circ } \mathrm { C }$ Particularly at 450 and $5 0 0 ~ ^ { \circ } \mathrm { C } ,$ most of the wear debris released from the AM tool steel surface attached to the aluminum alloy pin and modified the tool steel-aluminum alloy contact. At $5 0 0 ^ { \circ } \mathrm { C } ,$ the wear debris formed a glaze layer on the aluminum alloy pin surface [219].

In the last part of this section, recent researches on wear of polymer materials will be briefly discussed. Polytetrafluorethylene (PTFE) is a kind of polymers with excellent lubricity. A drawback of PTFE is the low wear resistance. To overcome the problem, hard fillers such as glass fiber or metal oxides are often added into the PTFE matrix. Ye et al. published two papers [220, 221] on the wear of alumina reinforced PTFE. In Ref. [220], they measured topographical evolution of transfer film of PTFE on the counterface, and found a 10-times drop in wear rate of the counterface with the increased transfer film area fraction and sliding distance. A rule-of-mixture wear model was proposed to explain the observations. In Ref. [221], they studied the effects of surface topography on the formation of transfer film and wear. They found that preferential removal of the tallest peaks on the counterface helped stabilize the transfer films and dramatically reduced the transient wear volume of the polymer composite, and that intersecting valleys and smooth plateaus helped nucleate and stabilize transfer films. Qi et al. [222] also reported ring-on-disk experiment results of wear of PTFE reinforced with PEEK and alumina. Based on the observations of evolutions of wear rate, worn surface morphology, transfer film, and debris morphology, the authors identified three wear stages, initial wear stage, severe wear transition stage, and ultralow stable wear stage. Panda et al. [223] proposed an analytical model for prediction of mechanistic wear of polymer materials. The model is derived on the assumptions of abrasive wear and fatigue wear, and validation experiments with PEEK, PMMA, and PVC against 316L stainless steel were performed. A wear equation was proposed to predict the wear rate of elastomers, considering the dominant material properties as well as operating variables. The exponents and coefficient of the equation were obtained experimentally, which represent the significance of each parameter. A good correlation was observed between the calculated and measured wear rates [224].

# 3.2.2 Wear modeling

In recent years, with the progress in theoretical approaches, improved experimental techniques, and rapidly growing numerical capabilities, understanding of the fundamental processes of wear has been improving remarkably. In 2018, the International Workshop on Science of Wear was held at the State Key Laboratory of Tribology, Tsinghua University, Beijing, China. More than 50 scientists from 12 countries participated in the workshop, and 23 invited presentations were conducted. At the same time, a special issue on science of wear, including one review article, 7 research articles, and one short communication, selected from the workshop presentations, was published in the journal of Friction. The review article in Ref. [225] contained an extensive historical review of adhesive wear mechanisms uncovered by atomistic simulations, emphasizing the interplay between plasticity and adhesion in wear process and the important role of a characteristic length scale governing the adhesive wear. Popov and Pohrt [226] introduced a new formulation which avoids completely the concept of micro-contact or asperity in wear simulation, and demonstrated the application of the new approach by a series of numerical simulation of wear of rough, adhesive sliding surfaces based on the boundary element method. Their simulation results indicated a possible breakdown of Archard’s law of wear. In Ref. [227], friction and wear rate of a lubricated point contact during running-in process were carefully studied by using a stop-and-go experimental scheme, and the effects of boundary layer formation and surface smoothing on friction and wear were distinguished explicitly with comprehensive analytical equations. Wang et al. [228] used comparative molecular field analysis and comparative molecular similarity indices analysis methods to analyze the antiwear properties of a series of 57 esters, and they proposed a predictive 3D-quantitative structure tribo-ability relationship model, which considers much more governing parameters than previous models. Finite element simulation was used to predict the failure process of self-lubricating spherical plain bearings in the swinging wear condition based on the Archard adhesive wear equation [229]. Both the running-in and stable wear stages were investigated. The location of worn out point was found from the calculated distribution of contact pressure, and the increase of wear depth with swinging number up to 25,000 times was predicted, which was validated by experiment results. In Ref. [186], the chemical mechanical polishing (CMP) of pure iron surfaces was physically modeled with the atomic force microscope (AFM). The effect of oxide film on material removal with $\mathrm { H } _ { 2 } \mathrm { O } _ { 2 }$ -based acidic slurry was investigated. The authors concluded that chemical corrosion-enhanced mechanical wear may dominate the CMP process of iron substrate. The single asperity sliding friction and wear were studied by Yang and Shi by using molecular dynamics simulations [230]. They found that the coupling between wear and friction is much higher in the plastic wear regime than in the atomic wear regime.

Amonton’s first law holds, and no lubrication effect from wear debris is observed in the atomic wear regime. The special issue was closed by a short review of the work of Rabinowicz on adhesive wear [231]. In 1958, Rabinowicz published a short historic paper on his fundamental ideas on the looseness of wear particles and proposed the criterion of critical size of wear particles, which has impacted on the research of wear and materials science for the past 60 years.

Besides of the aforementioned special issue, there are some wear modeling work published in other journals. Arnaud and Fouvry [232] developed a finite element formulation to simulate fretting wear with a coupled Matlab-Python-Abaqus algorithm. By taking into account the effect of the trapped wear debris, the error of prediction of the maximum wear depth was reduced from $8 0 \%$ to less than $1 0 \%$ , comparing with experiments. They concluded that the third body effect is more geometrical than rheological. By using the principle of thermodynamics, Lijesh and Khonsari [233] proposed an adhesive wear model which relates degradation coefficient, load-dependent friction force, and contact temperature. The feature of the wear model is able to account of loading sequence, which is different from the constant load assumption adopted in Archard’s wear law. Zhang et al. [234] presented a stochastic model for prediction of the evolutions of wear profile and surface height probability density function (PDF) of initial line contacts during running-in under mixed lubrication condition. The wear depth on the contact region was estimated according to the modified Archard’s wear model using the asperity contact pressure. Sugimura’s wear model was modified and used to link the wear particle size distribution and the variation of surface height PDF during wear. A transient mixed lubrication-wear coupling model (MLW coupling model) is developed to investigate the mixed lubrication and wear performances of journal bearings [235]. Molecular dynamics simulation was used to study abrasive wear behavior via nanoscratching of a $\mathrm { C u } 6 4 . 5 \mathrm { Z r } 3 5 . 5$ metallic glass [236]. A new wear model for sub-rough surface contacts in the context of deformation and theories of adhesion was proposed [237]. The wear model is based on studies on causes of their formation due to phase and structural heterogeneity of the material. A discrete element method was designed to evaluate the relative wear on hoppers caused by friction during operation in an open-pit mine. The results of the model showed good agreement with measurements on real industrial hoppers [238]. An adhesive-fatigue dual mode wear model was proposed for fractal surfaces in cylinderplane contact pairs [239]. Adhesive and fatigue wear mechanisms were distinguished based on the critical diameter of the contact area between two asperities. The fractal function was employed to derive the formula for wear loss for the fractal surface asperities on the surfaces of cylinder-plane contact pairs. In Ref. [240], a physics-based fatigue wear model was proposed to predict the life of cumulative micropitting wear for lubricated conformal contacts on rough surfaces. An elastic-plastic coated rough surface contact model was presented in Ref. [241], which incorporates existing single coated asperity contact models in a GW-based statistical multi-coated-asperity surface model. Effects of the coating thickness and its material properties as well as the substrate surface roughness on the mode of the coated surface contact deformation and its contact behavior were investigated through a qualitative parametric analysis. An adaptive finite element model was developed to predict false brinelling in a cylindrical bearing, during the transportation of new trains and compared with experimental measurements [242]. In Ref. [243], a new wear prediction method of tooth surfaces of involute gears based on a real tooth surface model and a modified fractal method is developed.

# 3.2.3 Wear monitoring and debris analysis

Wear state of machine components in operation is detected and on-line monitored by using single or multiple techniques of vibration measurement, oil analysis, acoustic emission, image analysis, and proximity probes, etc. An on-line visual ferrograph (OLVF) method was used to monitor the wear of a small-scale four-cylinder diesel engine for $4 0 0 \ \mathrm { ~ h ~ }$ operation [244]. The images of wear debris in lubricant oil were continuously captured, and the image features were extracted after data correction, reconstruction, and de-noising. An improved grey relevance vector machine prediction model (GM-RVM) was established to analyze the image data. It is demonstrated that the OLVF method and the improved GM-RVM model are effective for on-line wear monitoring. Continuous on-line wear particle monitoring was also applied to detection of gear pitting failure together with vibration monitoring [245, 246]. It was shown that the concentration of metallic particles in oil correlate well with the severity of macropitting. To reduce the influence of noise in real-time wear particle detection, a fuzzy morphology component analysis method was developed to de-noise the wear debris signals [247]. In Ref. [248], acoustic emission (AE) signals were used for condition monitoring of mechanical seals. A comprehensive model of AE energy discharge under different lubrication regimes was developed, and the RMS of AE signals was correlated with sliding speed. Surface failure of mechanical seals was detected from the detected deviation from the predicted trends. In Ref. [249], a deterministic AE RMS model under sliding friction was proposed, referring to the Fan statistic model. The proposed model was applied to non-Gaussian and Bi-Gaussian surfaces, and found that surface topography has strong influence on the AE RMS values. Vibration signals correlate with the surface damages of wheel/rail contacts [250]. When surface cracks appear on the surface of wheel rollers, the characteristic frequency of wheel roller is about $1 , 8 3 0 \mathrm { H z } ,$ while the characteristic frequencies are about 800 and $7 3 \ \mathrm { H z }$ for peeling and spalling damages on wheel roller. This indicates that wheel/roller damages can be detected by analysis of vibration signals. In some conditions, wear depth can be measured in-situ directly by using a proximity displacement probe. This method was used in the experiment of fretting wear [251]. The measurement results showed a high wear rate in the running-in stage followed by a mild steady state wear rate. Optical and laser scanning confocal microscopy and image processing tools were employed to provide quantification of surface roughness, wear severity, and wear depth on gear teeth during a lubricated endurance test, which allow a non-contact imaging-based measurements in two- and three-dimensions and without gearbox disassembly and tooth removal. Detailed qualitative analysis on the progression of the two main wear mechanisms (abrasive wear and fatigue pitting) was provided, alongside an evaluation of the diagnostic capabilities offered by the proposed methodology [252].

The size and shape information of wear debris can be used in diagnosis of wear. Kumar and Ghosh [253] found that the Weibull probability distribution function has more potential to fit the wear particle size distribution accurately than the Rayleigh model in case of heavy earth moving machines. According to the features of wear particle shape, wear particles can be classified. A genetic programming method was used to do the wear particle classification [254], which shows a high classification accuracy and robustness. Nonferrous metal particles can not be detected with conventional ferrograph technique. A microfluidic chip was designed and fabricated to detect nonferrous metal particles in oil with electromagnetic field [255]. Copper particles (size: $2 0 \ \mu \mathrm { m } ,$ ) were successfully detected at $2 \ \mathrm { M H z }$ excitation frequency, and the imaginary part of impedance changes without adding any device, which provides with a prominent guideline for detection of nonferrous particles of size less than $1 0 0 \mu \mathrm { m }$ . A convolutional neural network (CNN) model called FECNN is proposed to identify wear particles in complex ferrography images [256]. In Ref. [257], morphological features of wear debris from bearings, including quantity, colour, size, and shape, were extracted from videos of moving particles carried in lubrication oil. Moving particles were detected and tracked based on the Gaussian background mixture model and the blob detection algorithm, and the target particles were separated from the image background by background subtraction. The developed techniques for online particle feature extraction were applied to a rolling element bearing test rig. Analysis of oil contaminants was performed in Ref. [258] by applying a fuzzy inference system (FIS) and neural networks. The multilayer perception network was found to be an effective tool. The concentrations of iron and soot particles in used oil were selected as being both illustrative and the most significant model variables.

# 3.3 Surface coatings and modifications

Surface coatings and modifications aim to enhance tribological performance and/or other physical and chemical properties of solid surfaces, and cover a wide range of materials from organic to inorganic, from hard to soft. In this section, research activities on hard coatings, polymeric coatings, and some surface modifications will be summarized, while carbon films including DLC, CNT, graphene/graphene oxide as well as other solid lubrication films such as ${ \bf M o S } _ { 2 }$ are reviewed in the section of lubrication.

# 3.3.1 Hard coatings

Nitride, oxide, carbide, and boride are representative hard coatings widely used in machine elements, metal working tools, and some biomedical parts. These coatings can be formed with chemical vapor deposition (CVD), physical vapor deposition (PVD), thermal spray, and other coating processes on various substrates of materials. Habibolahzadeh and Haftlang [259] found that cubic boron nitride (c-BN) phase could be formed besides of $\mathrm { F e } _ { 2 } \mathrm { B }$ and FeN in a duplex surface treatment of steel via pack boriding and plasma nitriding. The coating shows a pebblelike surface and a sawtooth interface with substrate. Compared with sole boriding treatment, the duplex treatment exhibits superior wear resistance. Von et al. [260] investigated the effect of crystal orientations of CVD Ti(C,N) coatings on the abrasive wear resistance, and found that the ${ < } 1 1 1 >$ oriented coating exhibited a $2 0 \%$ higher wear resistance and $3 5 \%$ better abrasion resistance compared to the reference coating, and they attributed the higher resistance to the higher hardness at the ${ \mathrm { - } } 1 1 1 { \mathrm { > } }$ orientation. In Ref. [261], the tribological behavior of atmospheric plasma spray (APS) $\mathrm { T i O } _ { 2 }$ coating under mixed and boundary lubrication condition in the presence of friction modifier MoDTC were experimentally investigated and compared with those of steel and steel APS coating. They found long crystalline ${ \bf M o S } _ { 2 }$ flakes could be formed and attached on the APS $\mathrm { T i O } _ { 2 }$ coating and resulted in substantial reduction in friction and wear compared to steel and steel APS surfaces. TiAlN, TiCN, and AlCrN coatings are deposited with PVD or CVD process and used widely as wear resistant coatings at high temperatures. The PVD AlCrN coated on stainless steel were tested in the wide ranges of sliding speeds and temperatures up to $8 0 0 ^ { \circ } \mathrm { C } ,$ rubbing against $\mathrm { S i } _ { 3 } \mathrm { N } _ { 4 } ,$ $\mathrm { A l } _ { 2 } \mathrm { O } _ { 3 } ,$ and $\mathrm { Z r O } _ { 2 }$ ceramic balls, and the wear mechanism of the coating was revealed [262]. The deposition of PVD AlTiN/CrN multilayer can also be combined with boriding treatment of steel. The hardness of the multilayer was about twice of the borided layer, which was also 2 times greater than the hardness of the quenched and tempered substrate AISI M2 steel, and the borided+multilayer exhibited the highest dry sliding wear resistance in all test conditions [263]. The CVD TiCN/alpha– ${ \bf \nabla } \cdot { \bf A l } _ { 2 } { \bf O } _ { 3 }$ coating was applied to cemented carbide cutting inserts, and the tool life was tested by longitudinal turning of three kinds of steels, 42CrMo4, Ck60, and $1 0 0 \mathrm { C r } 6$ . At the highest cutting speed of $2 5 0 \ \mathrm { m / m i n } ,$ the tool life was 3 and $2 6 \mathrm { { m i n } }$ for cutting of $4 2 \mathrm { C r M o 4 }$ and $1 0 0 { \mathrm { C r } } 6 ,$ respectively. At the lowest cutting speed of $1 5 0 \mathrm { m / m i n } ,$ the tool life was 46 and $9 4 \mathrm { m i n }$ for cutting of 42CrMo4 and Ck60, respectively [264]. The PVD TiAlN and $\mathrm { C V D \ T i C N / A l _ { 2 } O _ { 3 } / T i N }$ coated cemented carbide grades were also tested by cutting of AISI 4340, AISI 52100, and AISI D2 hardened steels. It is found that the turning time was longer than $3 0 \ \mathrm { m i n }$ for cutting of AISI 4340 steel with hardness of 55HRC when the PVD coated cemented carbide grade was used, while for cutting of AISI 52100 and D2 steels with the hardness of 50 and 45HRC respectively, the tool life was no longer than $1 5 \mathrm { { m i n } }$ . They also observed that the CVD coated cemented carbide grade had longer tool life than the PVD coated one [265]. The titanium nitrides (Ti–TiN– $( \mathrm { T i } , \mathrm { C r } , \mathrm { A l } , \mathrm { S i } ) \mathrm { N } ,$ and zirconium nitrides $( Z \mathrm { r } { - } Z \mathrm { r N } { - } ( \mathrm { N b } , Z \mathrm { r } , \mathrm { C r } , \mathrm { A l } ) \mathrm { N }$ and $\mathrm { Z r - Z r N - } ( \mathrm { Z r } , \mathrm { A l } , \mathrm { S i } ) \mathrm { N } )$ nanostructured multilayers were deposited on WC–Co tool steel, and their cutting properties were compared in turning AISI 321 steel [266]. Thermal spray technology has been widely used to fabricate wear resistance coatings on components. In order to improve the properties of coatings and accelerate the innovation of materials, Chen et al. [267–269] investigated the coating formation mechanism from a more microscopic perspective, including the particle in-flight status and droplet spreading process. Gu et al. [270] analyzed the coated and textured ring/liner conjunction based on a thermal mixed lubrication mode. High velocity oxygen-fuel (HVOF) and high velocity air-fuel (HVAF) spraying techniques were used to deposit FeVCrCbased coatings to increase wear resistance of metals, and these coatings exhibited very low sliding wear rates [271]. Atmospheric plasma spray was used to make chromium oxide coating on a low-carbon steel, and the effect of arc-current and spray distance on the mechanical properties of the coating was investigated [184]. The research results showed that both of arc current and spray distance had an appropriate value to obtain good density and fracture toughness of the coating. In Ref. [272], three kinds of coatings, chromium carbide $( \mathrm { C r C } )$ coating, Ni–P coating, and boronized nickel alloy were investigated at room temperature and $4 5 0 ^ { \circ } \mathrm { C }$ using a specialized tribometer. Among the tested samples, boronized nickel alloy surface outperformed the coatings with lower friction coefficient and lower wear rate, especially at elevated temperature.

# 3.3.2 Chemical and electrochemical coatings

Differing from vacuum depositions and thermal spray, chemical and electrochemical coatings are often formed on metals in liquid solutions. Electroplating and plasma electrolytic oxidation (PEO) are typical electrochemical coating methods. In Ref. [273], a Ni–B coating was deposited on AISI 1040 steel specimens using an electroless method, and its tribological behavior at elevated temperatures was investigated on a pin-on-disk testrig. The electroless Ni–B coating showed excellent wear resistance at $3 0 0 ^ { \circ } \mathrm { C } ,$ but became worse at 100 and $5 0 0 ^ { \circ } \mathrm { C }$ due to severe oxidation and softening of the deposits. In the range from room temperature to $5 0 0 ^ { \circ } C ,$ the wear mechanism changed from adhesion to a combination of adhesion and abrasion as the temperature raised from ambient condition to $1 0 0 ^ { \circ } \mathrm { C } ,$ following which the wear mechanism was predominantly abrasive. The formation of a tribochemical oxide film also affected the tribological behavior of the coating at high temperature. Ríos et al. [274] compared the wear resistance of PEO treated titanium alloy Ti6Al4V in alkaline solution with untreated one, and found the coating improved antiwear performance of the alloy. They also found the lubrication with the simulated body fluid (SBF) could extend the sliding distance from $1 5 \mathrm { ~ m ~ }$ under dry condition to $1 0 0 \mathrm { m }$ without a significant wear. The effect of PEO voltage and post heat treatment (HT) temperature on the crystallinity, nanohardness, and wear resistance of PEO layers on Ti6Al4 substrate was investigated [275]. It is found that the higher applied voltage and HT temperature resulted in higher wear resistance due to increases in crystalline rutile phase in the oxide layer, hardness, and elastic modulus in nanoindentation. To improve the durability and reliability of diesel engine pistons, a ceramic coating was deposited using a combination process of microarc oxidation and electrophoresis deposition on the skirt of a high-silicon aluminum alloy piston. The friction coefficient measured on a reciprocating dry sliding test reduced by $3 5 \%$ against a boron copper cast iron liner material, and wear loss decreased by $9 5 \%$ compared to the substrate aluminum alloy [276].

# 3.3.3 Polymeric coatings

Polymeric coatings are often used in mild operation conditions in industry. Recently, an aromatic thermosetting copolyester (ATSP) coating was tested for applications at high temperatures or under cryogenic conditions [277, 278]. Experiment results exhibited that the ATSP coating has excellent performance in friction and wear reduction compared to bare tool steel at wide temperature range from $- 1 6 0$ to $2 6 0 ^ { \circ } \mathrm { C }$ under pressures over $1 0 0 \ \mathrm { M P a }$ . The mechanism of the favorable tribology behavior roots in the polymer transfer film on the steel counterpart during dry friction. To find a better solid lubricant for deep drawing of automotive steel sheets, octyl-, dodecyl-, or octadecylphosphonic acid coatings on $\mathrm { T i O } _ { 2 }$ -coated galvanized steel substrates were investigated using linear friction testing (LFT). The test data showed that the coatings can reduce friction coefficient remarkably from 0.31 to less than 0.11 [279]. Water contact angle (WCA), XPS, and IR data indicated that most of the physisorbed phosphonates became chemisorbed with time in an ageing test, increasing hydrophobicity and tribological properties of the surfaces. To prevent threads from galling, an environmental friendly self-lubricating $\mathrm { A g }$ and Ag-polytetrafluoroethylene composite coatings using a non-cyanide electroplating process was developed [280]. Experiment results indicate that the non-cyanide Ag-polytetrafluoroethylene coating is a potentially viable replacement for the commercially available cyanide $\mathrm { A g }$ coating which is both hazardous to human health and its wastes are detrimental to the environment. However, potential risks of failure through poor lubrication during the make-up process exist and further improvement of the make-up process is needed. Barbakadze et al. [281] developed an inorganic-organic hybrid composites and antibiocorrosive coatings with low friction and high scratch resistance. The coatings are based on an epoxy modified with silicon-containing polyepoxies and bioactive coordination compounds. The hybrids are optically transparent, visually homogeneous, with smooth surfaces.

# 3.3.4 Other surface modification techniques

Besides coatings, a variety of surface modification techniques, including mechanical, chemical, thermal, electromagnetic, and optical processes, have been developed to enhance tribological and surface properties of mechanical components. Ultrasonic nanocrystal surface modification (UNSM) is one of mechanical strengthening processes, which attracts a lot of attention in industrial applications in recent years. It is considered that the UNSM treatment can generate large compressive residual stress, refine grain sizes in the subsurface, and increase surface hardness, resulting in a higher wear and micropitting resistance [282−285]. The technique has been applied to bearing raceway [282], ball screws made of SCM445H, NF42CD4, and SAE4150 [283], and even graphite used in cover glass moldings [284]. The UNSM treatment was also combined with surface texturing to improve the wear resistance of spherical plain bearings used in aircrafts [285]. It is reported that the wear resistance of spherical plain bearings was increased by more than $5 5 \%$ Slide diamond burnishing is a similar mechanical strengthening method which has been applied to valve stems [286]. Repeated hammering (HM) is a kind of severe plastic deformation (SPD) treatments to nanocrystallize metallic surfaces. In Ref. [287], the HM treatment was applied to AZ31 Mg alloy, followed by recovery treatment (HR). Experiment results showed that the SPD-HR sample had a superior nanocrystalline surface exhibiting the highest wear resistance. Friction process can also result in the formation of a modified surface layer. This method was applied to an elastomer reinforced by silica [288]. The existence of a modified surface layer after the pre-running was investigated by using a scanning electron microscope. The results showed that the existence of a modified surface layer depends on the competition between the formation rate of the layer and the wear rate.

Laser surface texturing (LST) was implemented with a laser micromachining system for replicating topographic features of a honing stone in a WC-base cemented carbide grade, commonly employed for making tools [289]. The laser-patterned cemented carbide tools could be used in honing process, as alternative to conventional honing stones. Laser treatment was also applied to 8260 grade rail steel with a high power diode laser [290]. While it was expected that an increase in surface hardness depending on increasing processing temperatures will result in reduction in wear rate and friction coefficient in laser treated samples. On the contrary an opposite situation in tribological behaviours was found. Laser shock peening (LSP) was used to treat Ti–6Al–4V alloy, and compared with untreated samples in impact wear experiments. Results showed that LSP has no significant effect on mechanical properties and wear resistance of Ti–6Al–4V alloys under the same test conditions [291]. In recent years, 3D printing was also used for texturing thermoplastic polyurethanes (TPU) samples [292]. Experiment results exhibited that the spherical-convex textures appeared to facilitate the removal of friction pair debris from the surfaces, reduced the adhesion between the friction pairs and strengthened the wedge effect and cavitation effects of the water flow. Compared to the non-texture samples, the $1 / 3$ spherical texture samples with an $S = 3 8 \%$ exhibited improved tribological properties, and the friction coefficient of these samples was decreased by $6 4 . 4 7 \%$ .

Chemical etching was applied to Al–Si alloy cylinder liner to improve its wear resistance [293]. Experiment results showed that $5 \%$ NaOH solution was an effective chemical agent to etch the surface of Al–Si alloy samples. The 2 min etched Al–Si alloy samples exhibited low friction coefficient and small weight loss. In contrast, overetching led to even more seriously worn out surface as observed in the samples etched for more than 3 min. Chemical etching was also used to change the hydrophobicity of brass and aluminum surfaces [294, 295]. By two-step (with a mixture of hydrochloric and nitric acids, followed by treatment with lauric acid) and one-step (treatment with lauric acid) chemical etching, the surface was roughened, and a high water static contact angle $( > 1 7 3 ^ { \circ } )$ and a low sliding angles $( < 4 ^ { \circ } )$ were achieved. Further, the coatings exhibited self-cleaning and anti-fogging properties. In Ref. [296], a facile surface treatment method was proposed to improve the abrasion resistance of photosensitive film for screen printing. The wear resistance of photosensitive films treated with $1 5 \mathrm { { w t \% } }$ of 3-aminopropyltriethoxysilane (KH550) was increased by $3 4 \%$ compared with that of pure film. Moreover, surface treatment with KH550 led to a decrease in surface roughness of photosensitive films and an increase in their hydrophobicity.

Strong magnetic field may cause changes in microstructures and mechanical properties of materials to some extent. A pulse-magnetic field was applied on AISI 1045 steel samples, and effect of the magnetic treatment on friction and wear was investigated [297]. Dislocation densities of AISI 1045 steel were found to increase by $1 6 . 5 \%$ after magnetic treatment. The treated steel performed better under polyalphaolefin (PAO) base oil lubrication with each of five additives, especially when oleic acid was $0 . 2 \%$ and $1 . 5 \%$ (by mass), and the wear scar width and friction coefficient of treated samples were $4 6 . 9 \%$ and $1 6 . 4 \%$ lower than those of the untreated samples, respectively. Two types of commercial WC–Ni samples were irradiated with the high-intensity pulsed ion beam (HIPIB), and compared their tribological properties sliding against graphite under water lubrication.

Aramesh et al. [298] proposed an innovative tool treatment for improving tool wear and reducing chipping during machining of the super alloy of Inconel 718. The treatment involves less than two seconds of machining on an aluminum-silicon (Al–Si) workpiece, resulting in a thin transfer layer of Al–Si on the tool surface, prior to the actual machining of Inconel. During the subsequent machining of the Inconel bar, the Al–Si layer was melted due to the high temperatures of Inconel machining. The molten material channeled itself through the microcracks on the tool surface and seized their propagation. The sliding of the tool on the low friction Al–Si layer resulted in much lower forces, less sticking, seizure and built-up edge formation and, thereby, in less tool wear and chipping. Several beneficial lubricious and thermal barrier tribo-films were also formed on the tool face, which further protected the tool from chipping and severe tool wear. The preconditioning of the tool itself through this process resulted in tool performance improvement by lowering the tool wear at the running-in stage. To improve the machinability of Inconel 718, a cryogenic minimum quantity lubrication technique was proposed and compared with dry, wet, minimum quantity lubrication, and cryogenic cooling conditions. It is found that minimum quantity lubrication and cryogenic conditions exhibited superior performance in cutting force and tool wear than wet and dry conditions [299]. High-speed cutting of Inconel 718 under eco-friendly machining methods of cryogenic carbon dioxide $\left( \mathrm { C O } _ { 2 } \right)$ and dry cutting conditions was also studied with PVD tungsten carbide coated ball nose milling inserts [300]. It was reported that cryogenic $\mathrm { C O } _ { 2 }$ showed significant improvement towards increasing the tool life to a maximum of $7 0 . 8 \%$ relative to dry cutting.

# 4 Biotribology—Joint, dental, and skin

# 4.1 Introduction of biotribology

Biotribology deals with the application of tribology principles to biological situations [301]. It is one of the most widely and extensively researched areas in tribology.

The search was conducted to cover the period from 2018/01 to 2019/09. Three steps were taken to conduct the search. The first step was general search from different databases available in engineering and medicine/biology to identify the best sources, the main research fields, and the corresponding areas in biotribology. These included the main databases in English such as Web of Science, PubMed, ScienceDirect, SpringerLink, Engineering Village, Google as well as a number of databases available in Chinese (Baidu Scholar, CNKI, and WANGFANG DATA). The second step was further search from other sources, including books, special issues in relevant journals, and conferences, etc. Highly cited papers and hot papers were identified. A number of research areas and corresponding keywords were also produced from the first two steps. The third step was specific, focused search with the keywords identified and the corresponding records were analyzed and summarized. Major focuses, important findings, and future research developments were discussed. The three steps were repeated iteratively to finalize the search. Figure 18 shows the overall search methodology.

# 4.2 Main findings

The Web of Science was found to be the largest database with a comprehensive coverage of engineering and related fields in biotribology. A number of useful search functions were also available, including search for records by using field tags, set combinations or a combination of both. PubMed mainly focused on medical and biological fields. It was interesting to note that a search using engineering terms in PubMed produced the relevant medical and biological applications.

![](images/f4a75b78d3d1bcd542bd4af707a693bcfda7bba62c57b119f2cc99ff886360a0.jpg)  
Fig. 18 Overall search strategy.

A number of main research areas in biotribology were identified, and grouped into 4 areas as shown in Table 1, with the major considerations within each area listed. Highly cited papers in each area were also identified, using a methodology defined by the Essential Science Indicators (Web of Science). The highly cited paper was determined as having received enough citations to place it in the top $1 \%$ of the academic field based on a highly cited threshold for the field and publication year.

Table 1 Summary of major topics in biotribology research, including joint, skin, oral, and other systems.   

<html><body><table><tr><td>Classification type</td><td>Major investigations</td></tr><tr><td>Joint tribology</td><td>Natural synovial joints,articular cartilage, synovial fluid,mucin,and artificial replacement, etc.</td></tr><tr><td>Skin tribology</td><td>Skin friction behavior,moisturiser and cosmetics,skin pathology, textile material, prosthesis,and tactile perception, etc.</td></tr><tr><td>Oral tribology</td><td>Natra tat,storatiysaiaiag ant teth</td></tr><tr><td>Tribology of other biological system</td><td>Tribology of other human bodies,medical trevicegyanimaltribology， and plant</td></tr></table></body></html>

A total of 59 review papers were identified in different areas, as shown in Fig. 19. It was clear that the major focuses were on the areas of joint tribology and oral tribology. The other three areas were skin tribology, animal tribology, and biolubricants and biomaterials.

A number of special issues were also identified from one journal in tribology as shown in Table 2.

Furthermore, the major topics from one of the major conferences in biotribology (The $4 ^ { \mathrm { t h } }$ International Conference on BioTribology, September 2018, Montreal, Canada) were also analyzed. Similar focuses were also identified from both keynote presentations and sessions.

It is clear from the above discussion that the main areas in biotribology were conveniently grouped into four areas. Within each area, the main keywords were identified, as illustrated in Table 3, with detailed search by combining the application areas (medial/biological) with the tribology applications with appropriate Boolean operations.

![](images/44f196eb169dd3ace4817d61a9fb556e377f9f1b7fbbb89a51746a7e21a091f1.jpg)  
Fig. 19 Number of review papers in different areas.

Table 2 Special issues published in Tribology International.   

<html><body><table><tr><td>Journal</td><td>Special issues</td><td>Focus</td></tr><tr><td rowspan="5">Tribology International</td><td>Investigating the tribological and biological performance of covalently grafted chitosan coatings on Co-Cr-Mo alloy [302]</td><td>Joint</td></tr><tr><td>Influence of preload control on friction force measurement of fabric samples [303]</td><td>Touch, textile</td></tr><tr><td>Frition foreala in ior surgery [304]</td><td>Laparoscopic operation</td></tr><tr><td>Influence of surface profile of Co-28Cr-6Mo alloy on wear behaviour of ultra-high mole-</td><td>Joint</td></tr><tr><td>cular weight polyethylene used in artificial joint [305]</td><td></td></tr></table></body></html>

Table 3 Keywords and combinations used for the search from   

<html><body><table><tr><td colspan="3">Webof Science. Keywords</td></tr><tr><td colspan="3">Area</td></tr><tr><td rowspan="2"></td><td colspan="2">Object of study Searched areas</td></tr><tr><td> Articular cartilage</td><td>Leutriationorfrietionor</td></tr><tr><td rowspan="4">Joint</td><td>Synovial fluid ormucin</td><td>Lubriction or frction or</td></tr><tr><td>Joint and (implant or</td><td>Tribology or friction or wear</td></tr><tr><td>prosthesis) Finger</td><td>or lubrication</td></tr><tr><td>Tactile perception Textile or fabric</td><td>Skin and (tribologyor friction or wear)</td></tr><tr><td rowspan="6">Oral</td><td>Cosmetic Prosthesis or implant</td><td></td></tr><tr><td>Enamel</td><td></td></tr><tr><td>Orthodontic</td><td></td></tr><tr><td>Dental and implant</td><td></td></tr><tr><td>Saliva</td><td>Lubricaton orfritio or</td></tr><tr><td>Tongue</td><td>Lubriction or frction or</td></tr><tr><td></td><td> Oral perception</td><td>Friction or tribology</td></tr><tr><td></td><td>Medical implant</td><td>Tribologyorfriefio or wear</td></tr><tr><td rowspan="8">Others</td><td>Hair</td><td>Tribology or friction or wear</td></tr><tr><td>Eye or contact lens</td><td>Tribologyor friction or lubri-</td></tr><tr><td></td><td>cation</td></tr><tr><td>Tissue</td><td></td></tr><tr><td>Plasma protein Gastric mucus</td><td>Lubrication Lubrication</td></tr><tr><td>Gecko</td><td></td></tr><tr><td>Pangolin Fish</td><td></td></tr><tr><td>Shark Bird</td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td>Water strider</td><td>Friction or tribology</td></tr><tr><td>Ants</td><td>Earthworm</td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td>Beetle</td><td></td></tr><tr><td></td><td>Butterfly</td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td>Seashell</td><td></td></tr><tr><td>Snail</td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td>Vegetable oil</td><td> rctin or tiblgy r uhri-</td></tr></table></body></html>

A total of 701 records were found from Web of Science with the above keywords. Figure 20 shows the number of records in different areas.

Further analyses revealed that there were 45 records on the natural synovial joints, whilst a total of 245 were found on the artificial replacements. The numbers of records in oral and skin were 133 and 68, respectively. The remaining records were 210, focusing on other areas including biomaterials for general applications, ocular, plants, and animals etc. These were further analyzed and discussed in detail below.

# 4.3 Discussion

Overall, a large number of studies were found in the area of biotribology, covering extensively a wide range of topics. It is interesting to note a common thread was found among different areas, from investigating the underlying fundamental mechanisms of the natural organs and systems, and practical applications in interventions and treatments. Other interesting perspectives in relation to tribology such as perception, evolution, and biomimetics etc., as well as biological tissues with living cells were increasingly pursued.

# 4.3.1 Joint tribology

The largest percentage of the studies in biotribology was found to be in the area of joint tribology. Both natural systems and artificial joint replacements received significant attention.

![](images/70c2a3bb674f6ef4762a0af91120602f1bebefc31d86c640e9976615892d82e6.jpg)  
Fig. 20 Number of records in different areas searched from Web of Science.

The focus on the natural synovial joint was on the understanding of the underlying tribological mechanisms from friction, wear, and lubrication points of view [306]. Both normal and diseased tissues were generally considered, as well as the development of biomimetic cartilage replacements such as hydrogels [307−313] and synovial fluid substitutions such as synthetic biolubricants [314−316].

Biomaterials research for artificial joint replacements mainly focused on the improvement of the wear resistance currently used in clinical practice, such as metallic (cobalt chromium molybdenum alloys and titanium alloys), polymeric (ultra-high molecular weight polyethylene, UHMWPE) and ceramics, as well as novel biomimetic materials and combinations with potentials for longer lasting life of the implant. Silicon nitride bioceramics were investigated [317] as well as composite ceramics, to optimize both the hardness and the toughness, such as zirconia toughened alumina [318], carbonfiber reinforced silicone-carbide [319], and hexagonal boron nitride mixed with silicon nitride [320], etc. In addition to the improvement of highly crossed linked UHMWPE, potentially high performance polymers and composites were also investigated, such as ultra-low-wear polyethylene [321], polyetheretherketone (PEEK) [322] and hydrogels [323], porous polycarbonate-urethane and UHMWPE blends [324], polycarbonate urethanes [325], and polyvinyl alcohol and polyvinyl pyrrolidone blend hydrogels [326]. Other composites included hybrid polymer matrix composites reinforced with ceramics [327], Ti6Al4V cellular structures impregnated with PEEK [328]，and ceramic-metal composites [329]. New technologies such as 3D printing were also increasingly considered in joint tribology [324, 330].

Surface modifications/texturing and coatings were one of the common approaches for obtaining life-long orthopedic bearings for both soft [331] and hard bearing surfaces [305, 332−336]. Surface grafting was investigated for PEEK [337] and metal [338] bearing surfaces. Hard coatings included TiN [339], zirconium nitride multilayer coating [340], and tantalum carbide coating [341], etc., for the bearing surfaces in total hip joint replacements. Other coatings such as sol-gel coating [342], TiCuN solid solution coating [343], etc., were also investigated. Surface treatments included the use of emulsified diffusion of dicumyl peroxide to cross-linking UHWMEP [344] and boriding for Ti6Al4V alloy [345]. It is interesting to note that apart from improving wear resistance, the release from metallic ions, which is being increasingly recognized as a potential problem of metallic biomaterials, was also prevented from coatings [340]. Surface functionalization based on the hydration lubrication of articular cartilage was discussed for $\mathrm { S i O } _ { 2 }$ wafer and polystyrene microsphere [346].

A number of studies focused on the experimental wear evaluations of the bearing materials for artificial joints. Pre-clinical wear testing remained to be one of the most important considerations, with the major focuses on developing more realistic and more predictive experimental environments such as under adverse conditions. This was found to be particularly important for metal-on-metal hard contacts [347, 348]. The importance of adverse testing in the knee implant was addressed for various alignments and soft tissue conditions [349]. While the majority of wear studies were conducted experimentally, computational wear prediction for the hip was reviewed in Ref. [350]. The integration of biomechanics and biotribology became important and was addressed from both computational [351] and experimental [352, 353] approaches. Other interesting developments included the direct observation of the lubricant film at the articulating surfaces using optical methods [354]. Furthermore, development of integrated computational and experimental methods [355] was also found to be necessary in order to balance the cost and the efficiency. In some applications where early interventions to cartilage repair were sought, natural tissues also became part of the bearing surfaces that were required to be included in the experimental testing [356]. The potential relation between tribological inputs and acoustic emission was also reviewed as a potential diagnostic tool to understand the in-vivo performance of the joint [357].

In additional to the articulating surfaces, the fixation interface which has not received enough attention previously, was also extensively considered [358, 359] and also in conjunction with wear testing of the bearing surfaces [360]. Modular interfaces with fretting corrosion were increasingly studied at the hip [318, 361−363], the knee [364], and the spine [365, 366] and for new materials combinations of PEEK and XLPE [367]. The contact between implant and bone was also an important consideration [368]. Apart from tribological investigations, other aspects such as the improvement of bone regeneration and anti-bacterial activity also became increasingly focused [369].

Whilst the majority of studies in joint tribology focused on the hip and the knee, other joints such as the elbow [370] and the radial head [371], the patellofemoral [372], the meniscus [373], the shoulder [374], the finger [375], the temporomandibular joint [376], and the ankle [377] were also investigated. Furthermore, animal joints such as the canine hip implant were considered [378].

While the main focus of the present joint tribology was on the engineering aspects of biotribology, a number of clinical and biological studies were also found [379, 380]. Tribological effects at cellular levels [381, 382] and on regenerative ability [383] were also found to be increasingly examined.

# 4.3.2 Oral tribology

Two highly cited papers were identified in this area, focusing on the wear of animal teeth and dietary behaviours [384, 385]. The main considerations in oral tribology were the wear of artificial replacements as well as natural teeth. The underlying wear mechanisms of natural teeth, the lubrication mechanisms of saliva also received significant attention. The importance of the lubrication of soft oral tissues was also recognized [386]. Other interesting areas included perception of foods as well as archeological findings in relation to tribology.

Composite resins were widely used in dentistry to repair damaged teeth and to restore enamel defects. A number of biomaterials were considered, including ceramics based [387−392], metallic based such as Mg−Co nanocomposites [393], CoCrW–Cu alloys [394] and Ti−Cu alloys [395], and other materials based [328, 396−400]. Coatings and surface treatments were also widely used [401−404], similar to joint tribology. The effects of oral environments on the wear of dental materials were investigated such as PH [405] and bacteria [406], as well as materials aging [407, 408]. Other testing considerations included abrasive solutions [409], and contact configuration and lubricating conditions [410]. The importance of implant design and analysis was also recognized [411−413], as well as the fretting of dental implants [414].

The main focus on the wear of natural teeth was on the underlying wear mechanisms. A number of variables were considered, including contact load [415, 416], toothpastes [417], different specimens [418−420], and environments [421−424]. One of the interesting findings was that dental enamel was abraded by softer particles [422, 423]. In addition to wear studies, frictional coefficients during flossing of teeth were measured [425]. Animal models [426] and in vitro and in vivo clinical models were developed [415, 427]. The importance of saliva in oral tribology was also increasingly recognized, including changes in saliva due to age [428], dry mouth, and in vitro simulation system [429], effect of palm oil [430], and bio-lubricants[167].

$\bullet$ It is interesting to note a wide perspective in the area of oral tribology, from dietary, evolutionary, archeological, ecological, and paleontological points of view [384, 385, 431−436]. A close relationship between the rheology of the foods and the oral perception/flavour was demonstrated [425, 437−442]. Biomechanical environments and effects of friction were found to be important for various dental treatments, especially for orthodontic treatments [443]. Titanium nitride plating was developed to improve the corrosion resistance of orthodontic wires [444], while biomechanical variables and coatings were examined to control friction [445−449]. It is also interesting to note a number of similarities of the research between joint tribology and oral tribology. Similar technologies were used in both areas. The importance of corrosion was equally found for joint implants and dental implants [450−452]. Similar surface treatments and coatings were also applied [453−455]. Nevertheless, a number of limitations were identified in oral tribology, as compared with joint tribology. Simple experimental set-ups with simple configurations were often adopted to simulate chewing mechanics [387, 456], while more complex and sophisticated joint simulators were developed as discussed in joint tribology.

# 4.3.3 Skin tribology

One highly cited paper was found in this area, mainly focusing on skin electronics [457]. The majority of studies in skin tribology focused on friction and tactile perception of skins as well as practical applications. Finger perception and friction was one of the most examined areas in skin tribology. Development of tactile transducers also received significant attention.

The tribological mechanisms of skin were mainly studied from friction, contact mechanics, lubrication etc points of view [458]. Both human and animals skins [459] were adopted, including soft skins, hard scales [460, 461], and heads [462, 463]. Some of the friction studies adopted an artificially chosen hard counterface such as a metallic or glass subject, while in other studies fabrics were often used [464]. Most studies in skin tribology adopted experimental approaches, while only a few focused on theoretical investigations [465, 466]. The effects of the presence of different media on skin friction were examined [467−469], while lubrication was analyzed for water snails [470].

One of the major focuses in skin tribology was the relation between tribological properties and skin perception, tactile and haptics, particularly the finger [471, 472]. Both the skin and the perceived objects were involved in the contact and therefore were important considerations, including surface texture [473, 474], softness [475], and chemistry [476], etc. Perception was correlated with tribological properties such as friction, vibration, stickiness, contact mechanics [477], and different environments [478, 479], and different subjects including age, gender, etc [480, 481]. Various apparatus of friction measurements in conjunction with measuring brain responses and other physiological measurements were adopted [482−485]. In addition to the feel and identification of objects, other activities such as grasping and cutting processes with scissors were also investigated [486]. The relation between the morphology, biotribology, and sensory perception of a single human hair was discussed in Ref. [487].

$\bullet$ There were a number of applications in skin tribology, particularly in robotics [488], rehabilitation [489], and biomimics [490]. Other studies were devoted to friction reduction [491], medical applications such as suture [492], electronic skins, and artificial fingers [493, 494].

Tribology of skin was found to be quite complex, with multiple factors and at multiple scales, and a systematic and multi-disciplinary approach was required.

# 4.3.4 Tribology in other areas

A number of interesting areas in biotribology were also found in addition to the three main focuses discussed above. General biomaterials, especially metallic, also received significant attention. Ocular tribology, including the eye, contact lenses and lubricants, and the underlying lubrication mechanism, was also increasingly investigated. While most of studies in biotribology focused on macroscopic materials, an increasing number of investigations examined microscopically at cell levels. Tribological studies in animals also received significant attention, covering a number of animals such as geckos, birds, beetles, and earthworms, etc. Both the underlying mechanisms of the natural organs and the biomimetic applications were important. The focus on plant tribology was mainly from developing more environmental friendly lubricants.

$\bullet$ Biomaterials: A number of biomaterials were developed for general applications, including novel soft hydrogels [495]. Various coatings were examined to improve tribological properties [496, 497], while other considerations such as improving antimicrobial activity [498], bone in-growth [499] were also considered. Other soft coatings such as hydrogel coating for biomedical devices [500] and brushes [501] were also developed to reduce friction and improve lubrication. Ocular tribology mainly focused on the eye and contact lenses, from thermo-fluid dynamics [502] and lubrication points of view [503, 504].   
$\bullet$ The most focused topics in animals tribology were adhesion [505] and friction [506]. A number of

studies focused on gecko, in terms of developing a biomimetics approach to fabricate the surface features [507] and control the adhesion via direct laser lithography and understanding the underlying mechanisms of the natural system [508]. At the same time, a number of other animals were also considered, for example birds, abalones, insects, and beetles etc [509−513]. Attachment/detachment under water was studied [514].

Tribology in other systems: Whilst tribology is important in synovial joints, other parts in the musculoskeletal system may also experience relative motions, such as the tendon. Friction in tendon repair was shown equally important [515].

Tribology at cellular levels: The effect of friction on cell behaviors was investigated in a number of studies [516, 517]. The surface treatment of biomaterials was also found to be important for cell adhesion [518]. Furthermore, cell division and death was shown to be regulated mechanically [519].

The main focus in plants tribology is the development of environmentally friendly lubricants, including vegetable oils [520−522] and coconut oil [523]. Other interesting topics included the prey capture mechanism of certain plants [524].

Applications: A number of practical applications were found in biotribology, mainly from a biomimetics approach, such as development of robot locomotion [525], anti-adhesive surface for electrosurgical knifes [526], and adaptive frictionreduction and antifouling surfaces [527]. Effect of microtrichia on the interlocking mechanism was investigated in the Asian ladybeetle [528]. The importance of tribology principles were also found in food processing, such as cream cheese [529], cereal Kernels [530], and potato peels [499].

Although different organs were considered in four different areas in the present review, some generic observations and underlying mechanisms were observed. There were a number of similarities of the biomaterials required between the joint and the dental, as well as the issues such as tribo-corrosion to be addressed. For the soft tissues in the joint, the eye, etc., the lubricating mechanisms may be similar, such as the lubricin is soft tissues [531] and mucins [532]. Furthermore, the application of the engineering principles of tribology to medical and biological fields has been extended from simple combinations to more sophisticated fields such as perception and cellular levels.

There are a number of limitations of the present review. While the search was attempted to be comprehensive, some references may be omitted due to a wide range of potential topics in biotribology. Grouping of the research areas in biotribology was also subjective, particularly when a multiple of topics were covered in one reference. Discussion on the underlying tribological mechanisms was also limited due to the understanding of the subject. Furthermore, the major focus of the present review was on the engineering aspects of biotribology, medical and biological fields were less emphasized, and some of the clinical studies where tribology was closely related (available from PubMed) were not covered. Nevertheless, the present review may serve as a first source and a more thorough review may be required for a specific area.

# 5 High temperature tribology

# 5.1 Introduction of high temperature tribology

There are several applications such as automotive, aerospace, power generation, and metalworking processes in which the interaction of two (relatively moving) contacting solid surfaces occur at high temperatures because of the inherent prevalence of high temperatures. Further, the ever-increasing demand on compact, lightweight, and high performance machines have led to a drastic increase in the transmitted energy densities of mechanical systems. Operation of tribological interfaces of moving machine components in such systems therefore occur more and more under severe contact conditions including those involving high temperatures mainly due to frictional heating. The operation of mechanical systems at elevated temperature has serious consequences in terms of efficiency, performance, and reliability owing to the influence of temperature on friction and wear characteristics of contacting materials.

The term ‘high temperature tribology’ is ambiguous as there is no general limit as to what high-temperature actually means and it is highly system dependent. A temperature considered high for a polymeric material will not be high for a metallic material such as steel or a ceramic material. In tribology, a ‘high temperature’ can also be defined as the temperature when traditional lubricants such as oils and greases cannot be used (typically above $3 0 0 ^ { \circ } \mathrm { C } )$ as these rapidly decompose and lose their lubricating effectiveness. Aerospace, metalworking, and power generation are several technological applications in which tribological contacts operate at extremely high temperatures, sometimes higher than $9 0 0 ^ { \circ } \mathrm { C }$ .

Salient effects induced due to operation of tribological interfaces at elevated temperatures are the increased rate of tribochemical reactions (mainly oxidation) and degradation of mechanical properties of the materials. High temperature tribological phenomena are very complex as the surface and near surface characteristics of contacting materials undergo changes when exposed to high temperatures as illustrated in Fig. 21.

The needs, opportunities, and challenges in high temperature tribology research field have therefore considerably increased in recent years. A search of Scopus database for “high temperature” and tribology under the heading keywords has revealed that the number of articles (including reviews) in high temperature tribology area published during 2010−2019 have more than tripled compared to those published during 2000−2009. The key focus of research has been on characterisation and understanding of friction and wear mechanisms. A very significant part of research efforts has been devoted to controlling friction and wear at high temperatures.

High temperature tribological processes are not only complex but also very diverse. In view of this, the scope of this review is limited and only some salient research results published very recently in open literature have been briefly discussed below. Some of the aspects related to high temperature tribology have been covered earlier in Section 3. In order to avoid repetition, the discussion on these has not been included in this section in order to avoid repetition.

![](images/c0084d53d2060c1e3d5b161fd39500ad747967bb2c6aaa0438f9c5b2067c166b.jpg)  
Fig. 21 Schematic showing the complexity of a sliding contact at elevated temperature.

# 5.2 Friction and wear at high temperature

High temperature tribological studies pertaining to various tribological interfaces in several applications have been reported. However, most of studies pertaining to the effect of high operating temperature on friction and wear have been reported in the context of hot forming and press hardening (also known as hot stamping) areas. The main reasons for this is that the need to make use of lightweight materials in vehicles in order to reduce fuel consumption. The lightweight materials of interest include high/ultrahigh strength boron steel and aluminium alloys. These complex shaped structural and safety components of automobiles made of these materials are difficult to form through conventional forming at room temperatures and have to be formed at high temperatures. The interaction of the tool and work piece at high temperature gives rise to complex tribological phenomena. The understanding of friction and wear phenomena and their control at elevated temperatures is vital in optimisation of hot forming of lightweight material components for improved quality of produced, durability of expensive forming tools, and overall productivity. Some of the pertinent work published recently have been briefly summarised in this section.

In a review article, Li et al. [533] have highlighted the problem of friction in the context of stamping and in particular in hot forming of new lightweight materials. They have presented the state of the art concerning the mechanisms and factors influencing friction in stamping process. The authors emphasized on the need for further studies pertaining to the macro- and micro stamping friction and for establishing a dynamic multifactor coupling friction model for different stamping methods and materials. Muro et al. [534] have evaluated the friction and wear behaviours of different tool steels sliding against an uncoated $2 2 \mathrm { M n B } 5$ steel at elevated temperatures by using a high-temperature Optimol SRV reciprocating friction and wear tester at temperatures of 40 and $2 0 0 ^ { \circ } \mathrm { C }$ . The results have shown that frictional behavior of all the three tool steels is similar. Friction decreases when temperature is increased whereas wear increases in the case of the other two tool steels. The authors have concluded that the hardness of the tool steel cannot be the sole criterion in designing hot forming tool steels. Hernandez et al. [535] studied the effect of tool steel sliding against uncoated boron steel at elevated temperatures in open and closed sliding test configurations. At $4 0 0 ^ { \circ } C ,$ stable friction behaviour has been observed, mainly due to the formation of oxide layers in open as well as closed test configurations, as shown in Fig. 22. Higher amount of $\mathrm { F e } _ { 3 } \mathrm { O } _ { 4 }$ in the layers resulted in a lower friction coefficient for the closed tests compared to that in the open one.

In another study, Venema et al. [536] have studied the effect of temperature on friction and wear mechanisms during direct press hardening of Al–Si coated UHSS by observing the ongoing friction and wear phenomena on the sheet metal surface as well as the tool. The tests were performed at 8 different strip temperatures from 400 to $7 5 0 ^ { \circ } \mathrm { C }$ with a step increase of $5 0 ~ ^ { \circ } \mathrm { C }$ . At each specific temperature, 10 strips were drawn consecutively using the same set of tools and a new set of strips were used for each temperature. Their results revealed that friction is temperature dependent when sliding occurs between relatively clean tools and sheet, reaching a minimum at $6 0 0 ^ { \circ } \mathrm { C }$ and it has been relatively less sensitive to temperature when tribo-layers are built-up on the tool surface. The authors further reported that the wear mechanisms differ at low and high temperatures. At high temperatures, larger areas suffer abrasive wear damage and more severe ‘compaction of wear particles induced galling’ is seen.

Mozgovoy et al. [537] studied the effect of sliding speed, contact pressure, and temperature on the friction and wear response of tool steel sliding against uncoated and Al–Si coated boron steel using a specially designed simulative test. Higher loads led to lower and more stable friction coefficients independent of sliding speed and irrespective of uncoated/coated boron steel, as shown in Fig. 23.

Deng et al. [538] employed a specially designed tribological test for galling evaluation in press hardening conditions at elevated temperature and developed a numerical model of the test in order to understand galling behaviour in terms of the contact conditions at the tool-workpiece interface. The test temperature has been found to be an important factor in terms of the galling severity. At $7 5 0 ^ { \circ } \mathrm { C } ,$ severe galling has been observed whereas mild galling is seen at $6 0 0 ^ { \circ } \mathrm { C }$ .

In a fundamental study, Huttunen-Saarivirta et al. [539] have presented an insight into the tribological behaviour of H13 tool steel–6082 aluminium alloy by using a pin on disc test configuration in the context of extrusion process. The tribological tests were conducted at room temperature, 350, 400, 450, and $5 0 0 ^ { \circ } C ,$ respectively, and using different contact pressures (510 and $8 1 0 ~ \mathrm { \ M P a } _ { , }$ ). The results of this study have shown that the tribological behaviour is influenced both by the contact pressure as well as temperature. Galling occurs at higher contact pressure and the tool steel surface damage occurs due to abrasive wear.

![](images/0f8aad6ac727f900583231678a2655aca82df40fdd46935def612e8db3b2a3ff.jpg)  
Fig. 22 Coefficient of friction as a function of sliding distance at $4 0 0 ^ { \circ } \mathrm { C }$ for (a) the first stroke and (b) the tenth stroke. Reproduced with permission from Ref. [535]. $©$ Taylor & Francis, 2018.

![](images/6c627f1cafa85eeb3fc5a07a774d51ad8c363b4ec0921a2c9582b947449c9188.jpg)  
Fig. 23 Mean coefficient of friction as a function of normal load for (a) $0 . 0 1 ~ \mathrm { m / s }$ sliding velocity and (b) $0 . 1 ~ \mathrm { m / s }$ sliding velocity. Reproduced with permission from Ref. [537]. $©$ The American Society of Mechanical Engineering, 2018.

# 5.3 Control of friction and wear at high temperatures

As has been mentioned above, the conventional lubricating oils and greases are ineffective in controlling friction and wear above $3 0 0 ^ { \circ } \mathrm { C }$ as these rapidly decompose and lose their lubricating performance. The main approaches in controlling friction and wear at high temperatures involve use of speciality lubricants (mostly phase change materials), solid lubricant materials (also called self-lubricating materials), composites, and surface coatings or claddings.

The major research efforts in the high temperature tribology area are clearly directed towards the development of materials and surface modification technologies for controlling friction and wear. The surface modification technologies (or processes) include the well-known surface hardening (through both thermal and thermochemical processes), thermal spray processes, laser claddings, PVD, and CVD to name a few.

In general, it is important to control (or minimize) both friction and wear in most cases. However, the primary emphasis in some cases could be to reduce friction whereas it could be wear prevention or control in other cases. Highlights of some of the salient research work reported in open literature pertaining to these aspects are briefly discussed below.

# 5.3.1 High temperature speciality lubricants

The recent work in lubricants has mainly focused on glass and melt lubrication for high temperature application such as extrusion, hot rolling, and hot stamping processes.

Fan et al. [540] have designed low melting point glass lubricants of different compositions for hot extrusion of high purity titanium (TA2) at $8 0 0 ^ { \circ } \mathrm { C }$ . Thermal analyses revealed suitable softening points and viscosity of these designed glasses for use as lubricants for hot extrusion of TA2 at $8 0 0 ^ { \circ } \mathrm { C }$ . These glasses were applied as coatings on titanium by facile slurry method. Glass pads were also made by cold pressing a mixture of glass powder, sodium silicate binder, and water for industrial hot extrusion of TA2 tubes. Tribological studies conducted by using ball on disc tribometer at $8 0 0 ^ { \circ } \mathrm { C }$ showed that the glass coating is effective in reducing both friction and wear of TA2. The surface of the glass coating melts into a viscoelastic film that provides effective lubrication at elevated temperatures.

Cui et al. [541] have explored the possibility of using some inorganic compounds such as sodium phosphate, borate as well as layered talc powder and oil-in-water emulsion as a lubricant for hot metal forming process. Experimental studies regarding the performance of these lubricants were carried out by using high temperature pin on disc tests at $9 0 0 ^ { \circ } \mathrm { C }$ and hot rolling tests in which work-piece temperature is about $1 { , } 2 0 0 ^ { \circ } \mathrm { C }$ and work roll surface temperature may fluctuate between $5 0 – 8 0 0 ^ { \circ } \mathrm { C }$ . The authors have reported acceptable performance of sodium polyphosphate and borax with sodium polyphosphate showing slightly better performance. Tran et al. [542−545] also shows acceptable performance but only in hot rolling tests because of the short contact time. Alkaline borates as high temperature lubricants have also attracted attention in the context of hot rolling of steels. Tran et al. [542] investigated the high temperature lubricating effectiveness of sodium borate by using a pin (GCr15) on disc (mild steel) contact configuration and reported its excellent tribological performance in the temperature range $6 0 0 { - } 8 0 0 \ { \textdegree }$ (i.e., above the melting point of sodium borate). The authors highlighted the important role of physical chemistry of the borate melt for its tribological response. In another contribution, Tran et al. [543] have analyzed the tribochemistry of borate melt/oxidized steel. They found that the oxidation reaction of borate melt on oxidized steel is due to interface reaction of the oxide particles.

# 5.3.2 Solid lubricant or self-lubricating materials

Recently, two very comprehensive reviews on high temperature self-lubricating materials (solid lubricating materials) have been published, one by Torres et al. [546] and another by Zhu et al. [547].

Torres et al. [546] have critically reviewed and analyzed the current trends and design strategies pertaining to high temperature solid lubrication for various classes of self-lubricating materials. A significant increase in scientific work in this field since early 2,000s has taken place. Based on available literature, the effective lubrication ranges for some of the most relevant solid lubricants have been summarized, as shown in Fig. 24.

Zhu et al. [547] have presented an overview of the current research developments on high temperature solid lubricating materials that deals with various aspects high temperature solid lubricating materials such as design strategies, know how for construction, progress in this field, applications, and future trends.

![](images/d7b89f6c15422981e46c4907c1188340744c60371f5461e2d0160e8751de4a26.jpg)  
Fig. 24 Temperature ranges for effective lubrication for several solid lubricants. Reproduced with permission from Ref. [546]. $©$ Taylor & Francis, 2018.

Liu et al. [548] have studied the flow and friction behaviour of 6061 aluminium alloys in the context of forming a B-pillar by using hot stamping process. Besides measuring friction and analysing friction mechanisms, they conducted hot stamping studies on of B-pillar Al6061 (a structural component of a car) using different solution heat treatment as well as different lubricants such as hexagonal boron nitride (h-BN), graphite, and molybdenum disulphide (MoS2). The authors have shown that B-pillars without cracks could be produced by using lubricant. Further, the authors carried out FEM simulations and revealed that cracks were caused by high friction and non-uniform cooling between the side wall and rounded corners of the component.

A new high temperature self-lubricating material, $\mathrm { C o C r F e N i S } _ { 0 . 5 }$ high entropy alloy (HEA) has been developed by Zhang et al. [549]. In this work, the authors prepared the $\mathrm { C o C r F e N i S } _ { 0 . 5 }$ HEA by spark plasma sintering (SPS) by using a mixture of $\mathrm { C o } , \mathrm { C r } ,$ Fe, ${ \mathrm { N i } } ,$ and FeS powders. The authors further studied the microstructure, mechanical properties, and tribological performance from room temperature (RT) to $8 0 0 ^ { \circ } \mathrm { C }$ of the HEA material. The resulting ${ \mathrm { C o C r F e N i S } } _ { 0 . 5 }$ HEA material consists of a FCC high entropy solidsolution phase and a $\mathrm { C r } _ { x } S _ { y }$ phase. The average coefficients of friction decreased gradually from 0.41 (at RT) to about 0.35 at $8 0 0 ^ { \circ } \mathrm { C }$ . The authors have attributed the tribological properties of the $_ \mathrm { C o C r F e N i S _ { 0 . 5 } }$ HEA material from RT to $4 0 0 ^ { \circ } \mathrm { C }$ to the presence of $\mathrm { C r } _ { x } S _ { y }$ phase. At high temperatures, synergistic effect of the $\mathrm { C r } _ { x } S _ { y }$ phase and formation of different oxides on the sliding surfaces leads to the improved tribological properties of HEA. Erdoğan et al. [550] also prepared $\mathrm { C o C r F e N i T i _ { 0 . 5 } A l _ { \it x } h i g h }$ entropy alloys with varying Al content by induction melting and studied their dry sliding wear behaviour at various temperatures. The high entropy alloys containing high Al content exhibited superior wear resistance. The authors attributed the high wear resistance to the singlephase ordered BCC (Al–Ni Ti) structure formed at high temperatures.

In another study, Zhou et al. [551] developed M50 (Cr4Mo4V) steel based composites by incorporating $\mathrm { A g }$ and $\mathrm { { A g - T i C } }$ respectively through SPS process. M50 (Cr4Mo4V) steel is used in spindle bearings of aero-engines in view of its good dimensional stability, toughness, and rolling contact fatigue at high temperatures. The authors prepared $\mathrm { M } 5 0 { - } 5 ~ \mathrm { w t \% A g }$ and M50–5 wt%Ag–4 wt%TiC composites and studied their tribological performance in the temperature range of $1 5 0 – 6 0 0 ^ { \circ } C$ by using a ball on disc tribometer. A $\mathrm { S i } _ { 3 } \mathrm { N } _ { 4 }$ ball was used as the counterface material. The authors have shown that the friction and wear performance of $\mathrm { M 5 0 - 5 ~ w t ^ { \circ } / o A g - 4 ~ w t ^ { \circ } / o T i C }$ composite steel is significantly superior to those of $\mathrm { M } 5 0 { - } 5 \mathrm { w t \% A g }$ composites and M50 steel. Further, the tribological performance of M50–5 wt%Ag–4 wt%TiC steel composite has been found to be best at $4 5 0 ~ ^ { \circ } \mathrm { C }$ and it has been attributed to the formation of a lubricating film as well as a compacted layer. At $6 0 0 ^ { \circ } C ,$ the authors suggest that the formation of $\mathrm { A g _ { 2 } M o O _ { 4 } }$ layer results in friction reduction.

# 5.3.3 Surface modification technologies for controlling friction and wear

Several surface modification technologies as well as different compositions of surfaces for controlling both friction and wear have been reported. Some of the most recent contributions in this area are briefly discussed here.

# 5.3.3.1 Coatings for friction reduction

Han et al. [552] prepared graphite– $\mathbf { \partial } \mathbf { \cdot } \mathbf { M o S } _ { 2 }$ coatings with varying content of graphite (33 wt%, $2 5 \mathrm { w t \% }$ , $2 0 \mathrm { w t \% }$ , and 0) by air spraying methods and studied their tribological performance using a ball on disc test configuration at temperatures ranging from 25 to $5 0 0 ^ { \circ } \mathrm { C }$ under varying loads and sliding speeds. The Graphite– ${ \bf M o S } _ { 2 }$ coating containing $2 0 ~ \mathrm { w t \% }$ graphite resulted in best performance at $2 0 0 ^ { \circ } \mathrm { C }$ . The antiwear property of coating with $3 3 ~ \mathrm { w t \% }$ graphite is inferior at $2 0 0 ^ { \circ } \mathrm { C }$ and above $2 0 0 ^ { \circ } C ,$ the tribological performance of the coating containing $2 0 ~ \mathrm { w t \% }$ graphite also deteriorates. The authors have further reported a critical load (10 N) and rotational speed $( 1 , 2 5 0 \ \mathrm { r p m } )$ ) above which the coating with $2 0 \ \mathrm { w t \% }$ graphite is worn through and results in very high friction.

Serra et al. [553] co-deposited $\mathrm { T i N - } W S _ { x }$ thin films with varying ${ \sf W S } _ { 2 }$ content (4 and $1 9 \ \mathrm { a t \% }$ WS2) by reactive magnetron sputtering and studied their tribological behavior of at room temperature, 343, 423, and $5 7 3 \mathrm { ~ K ~ } ,$ respectively. The results showed superior tribological performance of $\mathrm { T i N \mathrm { - } } W S _ { x }$ thin films with varying ${ \sf W S } _ { x }$ content. Friction and wear showed that $\mathrm { T i N - } W S _ { x }$ performs better at room temperature than pure TiN.

Meng et al. [554] applied an industrial (Eubo dryfilm 111) ${ \bf M o S } _ { 2 }$ spray bonded $1 0 ~ \mu \mathrm { m }$ thick coating on $\mathbf { G } \mathbf { C } \mathbf { r } 1 5$ steel and studied its tribological performance in a ball on disc test using ${ \cal G } { \cal C } { \bf r } 1 5$ steel ball as the counterpart at temperature ranging from 150 to $5 0 0 ^ { \circ } \mathrm { C }$ at varying loads and speeds. They have reported decrease in friction and wear when the temperature is increased up to a critical temperature $( 3 5 0 ^ { \circ } \mathrm { C } )$ but observed an opposite trend above this temperature. The degradation in tribological performance above the critical temperature has been attributed to the oxidation of ${ \bf M o S } _ { 2 }$ coating.

Torres et al. [555] also developed Ni-based selflubricating laser claddings with the addition of $\mathrm { A g }$ and ${ \bf M o S } _ { 2 }$ on stainless steel substrates for controlling friction in high temperature applications such as hot metal forming. The special feature of this approach is the addition of $\mathrm { M o S } _ { 2 }$ to ensure a uniform silver distribution within the cladding by means of an encapsulation mechanism. The incorporation of sulphur-containing transition metal dichalcogenides (TMDs) such as ${ \bf M o S } _ { 2 }$ and ${ \sf W S } _ { 2 }$ to the self-lubricating coatings leads to the encapsulation of silver, prevents it from floating to the surface of the melt pool and ensures a uniform microstructure of the resulting laser claddings as can be seen from Fig. 25. These self-lubricating claddings with the addition of solid lubricants such as silver and transition metal dichalcogenides resulted in significantly lower friction compared to the unmodified reference alloy at room temperature, 400, and $6 0 0 ^ { \circ } C ,$ respectively, as can be seen from Fig. 26 [556]. This is attributed to the beneficial role of the chromium sulphides formed during the laser melting process. Continuing with these investigations further, Torres et al. [557] observed the formation of a protective tribolayer on the counter body after tests at high temperature against the selflubricating claddings. This correlates well with low counter body wear and decreased friction. Chemical characterization by means of EDX showed that the transferred patches are mainly composed of oxidized

![](images/8c4bf4928791a680a009721e5aa84f5e3e06b1ae59f2ff5ff858c174d9268668.jpg)  
Fig. 25 Illustration of an encapsulated silver inclusions in the as-deposited $5 \mathrm { A g } { - } 1 0 \ \mathrm { M o S } _ { 2 }$ as revealed by SEM and EDS mapping. Reproduced with permission from Ref. [555]. $©$ Elseiver, 2018.

![](images/c8fb53272a12a7d5d25997aa1082a64b0bf28a00c10e3b8da4bce9ddfbaf62c8.jpg)  
Fig. 26 Friction during reciprocating tests for the Ni-based claddings against AISI 52100 flat pins at (a) RT, (b) $4 0 0 ^ { \circ } \mathrm { C }$ , and (c) $6 0 0 ^ { \circ } \mathrm { C }$ Reproduced with permission from Ref. [556]. $©$ Elsevier, 2018.

Ni/Cr/S-based material from the self-lubricating claddings.

Dong et al. [558] developed a hybrid composite coating for hot forming dies by combining a lubricious composite surface coating with a nitro-carburised deep case via plasma nitrocarburising to maximise mechanical support and lubricity at high temperatures. The high temperature adhesion and hot forming performance of the coated dies were evaluated by using a high temperature tribometer and a deepdrawn top-hat apparatus respectively. The obtained results have shown that coated dies experienced negligible adhesion at elevated temperatures and a lubricant-free deep drawing could be done. Further, the authors have proposed a model comparing the frictional state of material surfaces based on the experimental results and analysis of stress states.

Du et al. [559] have developed a Ni–P composite coating with the incorporation of ${ \bf M o S } _ { 2 }$ and $\mathrm { C a F } _ { 2 }$ by electroless plating process and studied its tribological behavior from RT to about $5 7 0 ^ { \circ } \mathrm { C }$ . Both friction and wear decreased with an increase in temperature. The good tribological performance of the coating from 200 to $5 7 0 ~ ^ { \circ } \mathrm { C }$ has been due to the synergistic effects of the ${ \bf M o S } _ { 2 } ,$ oxides, phosphates, sulphates, and small amount of $\mathrm { C a F } _ { 2 }$ and $\mathrm { C a M o O _ { 4 } }$ formed on the worn surface at high temperatures.

Zeng et al. [560] prepared $\gamma { \mathrm { - F e } } _ { 2 } \mathrm { O } _ { 3 } @ { \mathrm { S i O } } _ { 2 }$ nanocomposite coatings on steel substrate through sol-gel method and investigated their tribological behaviour at temperatures of 400, 450, 500, 550, and $6 0 0 ^ { \circ } C ,$ respectively, by using a steel ball against coated disc test configuration in ambient air. The results have shown a strong influence of temperature on friction behavior. Friction decreases as the sliding progresses and the temperature is increased from 400 to $6 0 0 ^ { \circ } \mathrm { C }$ . The change in frictional behaviour with temperature has been attributed to the changes in physical and chemical properties of the nanocomposite coatings because of the tribochemical reaction and phase changes during sliding at high temperature.

Bondarev et al. [561] coated VCN–(Ag) on the surface of polished WC–Co and Ni alloy discs, and also on single crystal Si wafers by magnetron co-sputtering of V and C (graphite) and simultaneous sputtering of Ag. The deposition of coatings was done in different gaseous environments $\mathrm { N } _ { 2 }$ and $\begin{array} { r } { \mathbf { A r } \mathbf { + } \mathbf { N } _ { 2 } ^ { \prime } } \end{array}$ ) in order to obtain coatings of different compositions, with and without Ag. The thermal stability, temperatureactivated phase transformations, and friction behaviour of these nanocomposite VCN–Ag coatings were studied during dynamic temperature ramp tribological tests. The authors also carried out density functional theory (DFT) calculations and proposed a phenomenological temperature-dependent friction model. The addition of $\mathrm { A g }$ does not have any significant influence below $2 0 0 ^ { \circ } \mathrm { C }$ but decreased friction considerably in 250− $3 5 0 ^ { \circ } \mathrm { C }$ temperature range. In $3 5 0 { - } 4 5 0 ~ ^ { \circ } C$ temperature range, the friction of VCN coating decreased, whereas that of the ${ \tt V C N - A g }$ increased due to the formation of different types of oxides and their volume fraction. In the temperature range of $5 0 0 { - } 6 5 0 \ { ^ { \circ } C } ,$ the cofficients of friction of VCN and VCN–Ag coatings are similar but a significant decrease in friction of $\mathbf { A g } .$ -doped VCN coating at $7 0 0 ^ { \circ } \mathrm { C }$ has been observed due to the formation of $\mathrm { A g _ { 0 . 4 } V _ { 2 } O _ { 5 } }$ phase and tribo-activated melting.

# 5.3.3.2 Coatings for wear control

The research pertaining to the control of wear at high temperatures has attracted very significant growth recently. Some of the notable contributions include high entropy alloy (HEA), stellite-6, Tribaloy, $\mathrm { C r } _ { 3 } \mathrm { C } _ { 2 ^ { - } }$ NiC-WC and WC-Co, NiCoCrAlYTa, TiC reinforced Cu-Ni-Mn, TiC/Ti3AlC-Co, TiC-Co, $\mathrm { N i } 6 0 { + } \mathrm { h }$ -BN, CrAlSiN, TiAlN/nitride duplex treated and oxide coatings and hardfacings [562−581]. In view of recent developments and growing interest, some of the studies pertaining to HEA laser claddings and micro-arc oxidation (MAO) surface modification techniques for control of wear at high temperatures have been briefly discussed here.

1) HEA coatings: HEAs are a broad group of metallic multicomponent materials (typically 5 or more) in similar mass fractions and ideally composed of a single phase solid solution. The interest in the high temperature tribology research of these alloys is mainly in view of their high hardness, mechanical strength, stability at high temperatures, high strength-toweight ratios, and oxidation and corrosion resistance.

Some of the compositions of HEA having potential for high temperature tribological applications include Fe5Cr5SiTiCoNbMoW, CoCrBFeNiSi, FeCoNiCrCu, Al0.5FeCu0.7NiCoC, and AlCoCrFeNi [562−568]. Shu et al. [563, 564] have developed a wear resistant CoCrBFeNiSi HEA amorphous coating through coating laser cladding. The idea of this study is to combine the advantages of HEAs and amorphous alloys. Microstructural analysis of the coating revealed a layered structure of the coating in which the upper layer comprises of mainly an amorphous phase. The bottom layer has BCC $\mathrm { C o F e } _ { 1 5 . 7 }$ and FCC $\gamma ( \mathrm { F e } , \ \mathrm { N i } )$ major crystalline phases and $\mathrm { C o C _ { 8 } }$ carbide and ${ \mathrm { C o } } _ { 2 } { \mathrm { B } }$ boride as the minor crystalline phases. The wear tests conducted at $5 0 0 ^ { \circ } \mathrm { C }$ revealed mainly abrasive wear in the amorphous layer and adhesive wear in the crystalline layer with amorphous layer showing about $1 0 \%$ lower wear. Jin et al. [568] prepared laser-cladded FeNiCoAlCu high-entropy alloy coating and evaluated its wear performance at various temperatures up to $8 0 0 ^ { \circ } \mathrm { C }$ using a WC ball against coated disc test setup. The results have shown very high friction (0.8−0.9) at RT, 200, and $4 0 0 ^ { \circ } \mathrm { C }$ but significantly lower friction at 600 and $8 0 0 ^ { \circ } \mathrm { C }$ . The authors have also reported good wear performance of the alloy cladding at $8 0 0 ^ { \circ } \mathrm { C }$ and concluded that the wear of FeNiCoAlCu high-entropy alloy coating occurs mainly due to abrasive wear and oxidative wear mechanisms.

The high temperature tribological behaviour of HEAs is complex and the present understanding pertaining to their friction and wear behaviour so far is inadequate.

2) MAO surface treatment: Liu et al. [580] have evaluated the effect temperature on tribological behaviour of MAO treated 2219 aluminium alloy in laboratory and also in the field (deep well and ultradeep well drilling) where aluminium pipes are used because of its low density, light weight, and high specific strength. The MAO treatment produced a layer of $2 0 \mu \mathrm { m }$ thickness with micohardness of $3 5 3 \mathrm { H V } .$ This layer is mainly composed of ${ \bf { \Lambda } } { \bf { { d - A l } } } _ { 2 } { \bf { { O } } } _ { 3 }$ and the $\gamma \mathrm { A l } _ { 2 } \mathrm { O } _ { 3 }$ phases. Micro-hardness of the surface layer increases from 130 to $3 5 3 . 3 \ \mathrm { H V } .$ . The load bearing capacity of the MAO coating reduces when the temperature goes up. The MAO treated Al alloy shows a decrease in friction as well as wear at $1 6 0 ^ { \circ } \mathrm { C }$ compared to that at room temperature. The field test has also shown significantly lower wear for MAO treated drilling pipes.

Yi et al. [581] have carried out further studies on 2618 aluminium alloy (used for drilling rods in deep well and ultra-deep well drilling) surface treated with muti-arc oxidation (MAO) and also with combined ultrasonic cold forging technology (UCFT) and mutiarc oxidation (MAO) treatments. The compound layer thicknesses are $2 0 ~ \mu \mathrm { m }$ MAO layer and $2 0 0 ~ \mu \mathrm { m }$ of UCFT treated layer. The micro-hardness values of the sample increased of from 120 to $4 1 5 ~ \mathrm { H V }$ for MAO layer and from 120 to $1 8 5 ~ \mathrm { H V }$ for the UCFT layer. Wear rates of combined MAO and UCFT treated aluminium alloy decreased by $7 1 \%$ at $2 0 0 ^ { \circ } \mathrm { C }$ .

# 6 Computer simulations in tribology

# 6.1 Introduction of computer simulations in tribology

Computer simulation originates from numerical solutions of differential equations that describe physical processes in continuum mechanics, and it has grown into an effective approach in scientific and engineering investigations due to rapid development of computer technology. Recently, molecular dynamic simulations that analyze the response of a system consisting of atoms, and the first-principle computations that calculate atomic interactions via fundamental equations in quantum mechanics, have appeared as new tools of simulation. This section deals with recent progresses in computational tribology, which involve four subjects: fluid lubrication, contact mechanics, wear, and nanotribology, and the discussions include numerical technique, model developments, and applications. The studies reviewed in this section are mainly from a search of literatures in the period of 2017−2019, but for a complete presentation of research history, some earlier works are also mentioned.

# 6.2 Numerical simulation of fluid lubrication

Numerical simulation of hydrodynamic and elastohydrodynamic lubrication (EHL) has been a classical topic of tribology, yet there are some problems remain to be solved, but generally speaking, the studies in recent years are mostly application oriented.

# 6.2.1 Recent developments in numerical analysis of EHL

For more than 60 years, numerical analysis of EHL has been developed along the path to incorporate more and more influential factors, such as temperature rise, lubricant rheology, transient operational conditions, and other considerations. The trend remains unchanged till recent years, and there are some interesting developments to be noticed. Over last decades, the combined solution of the Reynolds equation and energy equation for revealing thermal effects has become a routine practice in numerical simulations of lubrication [582, 583]. To address non-Newtonian effects of lubricants, either the Eyring or the CarreauYasuda models have been employed [584–587] despite that there has been a debate over the effectiveness of currently used shear-thinning models. The interplay between body temperature and lubricant rheology has been found to affect film thickness and traction in a complicated way [584]. Transient EHL solutions reveal more details of time-dependent pressure and film thickness under varying speeds or loads [588−591], and contact stiffness and damping have been defined to characterize dynamic responses of lubricating films [592, 593]. Many researchers have tried to integrate multifactorial considerations into one sophisticated numerical model so that the effects resulting from several factors can be analyzed simultaneously [584−588]. While the multifactorial simulations are able to present more realistic results for engineering applications, computational cost rises quickly. On the other hand, fast evaluation of lubrication properties by easy-to-use fitting formulation or by well-trained neural network [583] deserves equal attentions. For example, to estimate rheological and thermal effects on central film thickness, $h _ { \mathrm { c } } ,$ a fitting formula was proposed by De la Guerra [584] as given in Eq. (4), in which a group of correction factors has been introduced to the Newtonian film thickness $h _ { \mathrm { N } }$ .

$$
h _ { \mathrm { c } } = h _ { \mathrm { N } } \cdot \varphi _ { \mathrm { N N } } \cdot \varphi _ { \mathrm { S R R } } \cdot \varphi _ { \mathrm { T } }
$$

where $\varphi _ { \mathrm { N N } }$ and $\varphi _ { \mathsf { S R R } }$ are the factors representing shearthinning effects, under pure rolling and rolling-sliding conditions, respectively, while $\varphi _ { \mathrm { { I } } }$ is a correction factor for thermal effect. The expressions for these correction factors have been provided by fitting numerical results.

# 6.2.2 Roughness effect and mixed lubrication

Roughness effect has been a long-lasting focus in simulations of lubrication, especially when asperity contact takes place in the regime of mixed lubrication. There are progresses in both stochastic and deterministic solutions of mixed lubrication. For example, plastic deformation at asperity contacts has been taken into account [594−596], the computational fluid dynamics (CFD) that directly solves the NavierStokes equation has been introduced in analysis of roughness effect [597], and new algorithms have been developed to improve computational efficiency [598, 599]. Robbe-Valloire [600] proposed a model for mixed lubrication between nominally flat rough surfaces, in which asperity contacts were classified into five different modes of deformation or lubrication, with contact forces in each mode evaluated via corresponding theories. Friction coefficient and the Stribeck curve predicted by this model agree well with experiments. More attentions in recent years have been paid to the effect of artificial surface microstructure called the texture, which could be beneficial to the load carryingcapability if properly designed [601], so efforts have been made to find optimum shape, size, and distribution of micro dimples [602], and a mixed structure combining the texture with wall-slip domain has been investigated, too, as will be discussed in next section.

# 6.2.3 Incorporation of surface interactions

A new research demand in simulations of lubrication arises to take account for the molecular interactions at surface or interface. As an example, the boundary slippage at solid wall that associates with both lubricant rheology and interfacial property has attracted a lot of attentions. Models such as the Navier slip length, the limiting shear stress, or a combination of both models have been implemented in numerical analysis to capture the wall slip effect [603, 604], and it is recognized that solid-liquid interactions play a significant role in slip behaviour [605]. Zhang et al. [606] recently has proposed a layered slip model for high speed EHL in point contacts, as shown in Fig. 27, assuming that slippage is localized in a thin lubricant layer close to the solid wall, which gives predictions consistent with experiments. The numerical studies on wall slip found potential applications that a proper arrangement of slipping domains or a combination of slipping patch and surface texture would bring about even better load carrying capacity for bearings [605, 607].

![](images/8e481f6c0c9d1cb293163a3a56638a0d6541816950531c34333d62a56035e609.jpg)  
Fig. 27 Layered slip model proposed by Zhang et al. Reproduced with permission from Ref. [606]. $©$ Elsevier, 2019.

Another layered model has been developed for assessing the effect of adsorption films on lubrication, and numerical results predict a film thickness– velocity $\left( h { - } v \right)$ dependence in a better agreement with that measured in thin film EHL [608]. In numerical solutions of thin film lubrication when film thickness decreases down to a few nanometers, surface forces due to the van de Waals interactions and electrostatic double layer have to be incorporated [589], and they are found to contribute significantly to the film formation that prevents surfaces from sticking at zero speed. In a recent attempt to model tribochemistry in mixed lubrication, Azam et al. [609] have presented a formula that balances the tribofilm growth described in the Arrhenius equation with film removal obeying an exponential law. Simulation results indicate that tribofilm grows in patchy, inhomogeneous manner within rubbing track, and the mean tribofilm thickness increases with sliding-rolling ratio.

# 6.2.4 Other developments and applications

To explore a new technique of lubrication by air-oil mixture, Guo et al. [610] have simulated film thickness and pressure distributions when a group of oil droplets goes through an EHL contact, and concluded that effective lubrication films can be formed by a proper control of oil droplet supply.

In parallel to the popular numerical solver based on finite difference discretization, many researchers rely on the finite element method (FEM) to solve the equations involved in lubrication and solid contact [590, 599, 611], and CFD-based commercial software has become a popular tool in analysis of $\mathrm { E H L } ,$ , which could provide critical information for across-film distributions of velocity, temperature, and viscosity [597, 612].

Application oriented simulations have been performed to predict lubrication behavior of mechanical parts, such as bearings [613, 614], gears [615], cam-roller [616], linear rolling guide [617], and other components, in which the effects of surface roughness, non-Newtonian lubricants, contact stiffness, and transient conditions have been discussed in detail.

# 6.2.5 Unsolved problems

Hydrodynamic pressure can be solved accurately by the Reynolds equation, but in deterministic analysis of mixed lubrication, the uncertainty in discretization of multiscale rough surfaces and the mesh dependence of solutions are open questions to be settled. The incorporations of interfacial interaction, multiphase flow, and tribochemistry into lubrication analysis are still at an early stage of development. In theory, it is possible to develop a comprehensive model that include all influential factors mentioned above, but the balance between computational accuracy and costs is always a difficult problem to deal with.

# 6.3 Simulations in contact mechanics

Since Hertz published his analytical solution for a simple contact problem between a perfect sphere and elastic half space, contact models have been extended to be applied in more practical conditions [618], and numerical analysis becomes necessary because of the difficulties to get analytical solutions. It has to be noticed that contact mechanics is a discipline covering various subjects, but the discussions in this section have been limited to the tribological contacts, or the contacts between surfaces in tribological processes.

# 6.3.1 Extension of contact model

The first attempt in extension of the Hertz contact theory was to consider the effect of adhesion, and models such as JKR (proposed by JOHNSON K L, KENDALL $\mathrm { K } ,$ and ROBERTS A D) [619] and DMT (proposed by DERJAGUIN, MULLER, and TOPOROV) [620] were developed. It was recognized later that the each of the models was in fact suitable for a certain type of material with high or low values of $\mu ,$ a criterion defined by Tabor, and for the common materials with medium values of $\mu ,$ the Maugis model, and doubleHertz model were proposed [621]. Recently, Zini et al. [622] has extended the double-Hertz model to the elliptical adhesive contact to account for more general contact geometries. Li and Popov [623] solved the adhesive contacts numerically via the boundary element method (BEM), and generalized the model to the gradient materials, predicting the normal force and contact radius during a pull-off process. In a more recent paper, Wu [624] presents a BEM analysis of adhesive contacts, in which surface interactions are described by the Lennard-Jones potential, and the results of pull-off force and load-approach curve are compared with those from JKR and other existing models.

The half space assumption in contact models has to be left in the cases when the dimensions of both the contacting bodies are finite since the calculation errors would become significant, especially in the vicinity of the edge. As an example of attempts to develop more accurate theory, a quarter-space model was proposed which converts the contact in quarter space into an equivalent problem in half space plus a group of constraint loads which remain to be determined [625]. Recently, Zhang et al. [626] have extended the quarter space model to the contact in finite-length space, and constructed the matrix equations for solving the unknown constraint loads. These models have been numerically implemented and applied for examining the effects of edge compliance [627, 628].

# 6.3.2 Progresses in numerical methods

Numerical solution of elastic contact is a mathematical problem of minimizing elastic strain energy under certain constraint conditions. The conjugate gradient method (CGM) has been widely accepted for the minimization, providing that the influence coefficient (IC) or the Green’s function, defined as the response of displacement to a point load, has been obtained in advance. To accelerate the calculation of deformation, fast Fourier transform (FFT) technique has been employed and efforts have been made to further improve its computational efficiency [629]. A numerical scheme known as the Sami-analytical method (SAM) has been developed in last decades, in which the ICs are derived analytically in frequency space and deformations are calculated by the FFT technique. Recent progresses along this approach include acquirement of expressions of the ICs for multilayer materials in contacts and extension of the SAM model to the analysis of thermoelastic contacts of inhomogeneous materials [630, 631]. The newly appeared FFT-based boundary value method [632] is similar to that of SAM, but a new way of computing the coefficients of the conjugate gradient solver has been presented, which reduces the number of FFTs at each step. Other numerical schemes for contact analysis have been developed in parallel with the SAM, including the multiscale theory proposed by Persson [633], the finite element or boundary element method [634], and the approaches based on MD simulations. A recent development of the Green’s function molecular dynamics (GFMD) deserves a brief discussion. It involves a calculation of the renormalized atomic interactions or force constants through the correlation matrix (or Green’s function) of atomic displacement in reciprocal space, and the force constants are thereby to be used in MD simulations [635].

# 6.3.3 Rough surface contact

The pioneering work by Greenwood and Williamson (GW) on a statistic model for elastic contacts between nominally-flat rough surfaces was published in 1966 [636]. The publication has inspired quite a number of studies on rough surface contact in the following years, including several modified versions to the GW model and numerical attempts to get deterministic solutions of contact between the rough surfaces with random height asperities. However, there is no direct verification so far for any of these models. At the time of $5 0 ^ { \mathrm { t h } }$ anniversary on the publication of the GW’s classical paper, Müser conducted a brute-force calculation based on GFMD for a contact where a rough surface with a well-defined topography has been pressed on a flat, elastic substrate. He issued a challenge to the contact mechanics community, by inviting scientists around the world to submit solutions to the same problem [637]. The problem definition was posted on a website while the computational results from the challenger were kept secret until all solutions were submitted. The solutions from a dozen research groups were received and summarized in a review paper by Müser and all contributors [638]. The comparison shows that 1) the solutions from the FFTbased boundary value method are the closest to the reference values from Müser’s brute-force calculations, 2) both GFMD and all-atom MD have predicted similar patterns of real contact, which agree well with that measured in experiment as illustrated in Fig. 28, and 3) the Persson’s model also gives predictions in good agreement with the reference when adhesion is not involved [639]. This event not only serves as a model test, but also an exhibition of numerical schemes in contact mechanics.

# 6.3.4 Applications

Applications of contact mechanics can be found in many areas of engineering. The theory of elastohydrodynamic lubrication, as mentioned previously, is established by incorporating contact model with solution of the Reynolds equation, and contact analysis plays a crucial role in predicting wear and contact fatigue, as will be discussed in Section 6.4. Wheel-rail contact is another widely concerned subject of contact mechanics, and various models and numerical approaches for both Hertz and non-Hertzian contacts have been proposed to predict damages in railway system [640, 641].

![](images/397a426f3e2417b67e963ae7dda325922f2205a254f3f3dc124de3505377adf8.jpg)  
Fig. 28 Comparison of contact patterns. The upper left panel shows the experimentally measured contact area, the center top panel shows a gap distribution obtained from GFMD, and upper right panel shows atoms in contact as obtained by all-atom MD. The lower row shows the superposition of GFMF with experiment (left) and with all-atom simulation (right). Reproduced with permission from Ref. [638]. $©$ Springer Science Business Media, LLC, 2017.

To take account of more complex material responses and incorporate thermal, electric or magnetic effects is an important target in applications of contact mechanics. For example, the temperature distributions due to frictional heating in thermoelastic contacts have been solved through semi-analytical approach, with consideration of material inhomogeneity [630, 631, 642]. The analysis of thermoelastic contact has been further extended to evaluate the contact performance for the magneto-electro-elastic materials (MEEMs) [643]. The complicity in material response and joint actions of multi-physical fields have been incorporated into one comprehensive contact model by Zhang et al. [644] that can be applied to the system involving multilayer, gradient, and inhomogeneous materials, and to the prediction of coupled effects from temperature, electric, and magnetic fields.

# 6.3.5 Unsolved problems

As more and more factors have been incorporated, the once efficient numerical approach, such as the SAM, would become less efficient, which is a dilemma that researchers have to face. Moreover, numerical schemes have been implemented in a diverse way, as can be seen in Section 6.3.3, even similar approaches have been called by different names, and an efficient and universal version of software for contact analysis may become a common expectation. In addition to the effects of adhesion and surface roughness, more attentions to the prediction of behavior in electric contacts would be anticipated in future.

# 6.4 Numerical simulations of wear

Since Archard’s milestone work on formulating a general law of wear [645], great efforts have been made to provide more accurate predictions. There are over one hundred modified versions to the Archard equation, but mostly empirical in nature [646]. In the following years, numerical approach has appeared as an efficient tool in simulation of wear. Recent progresses in this research subject, including the continuum-based approach and discrete element method, are summarized in this section.

# 6.4.1 Continuum approach

There are two strategies in numerical simulation of sliding wear. A popular way is to combine numerical contact solutions with the Archard equation. This approach, for example, has been widely applied to simulate sliding wear between rough surfaces in solid contact or mixed lubrication [647−650]. The computation is carried out in two steps, first to calculate the pressure at asperity contact, and then to evaluate wear loss at each contacting spot by locally applying Archard’s law. Since the geometry of worn surface has to be updated at every time step, the computational cost becomes quite expensive, and efforts have been made to speed up or simplify the computation [651]. The model has been further refined by assuming that wear takes place only at the asperities in plastic deformation [652, 653].

Similar approach has been applied for simulating other types of wear, such as fretting and erosion. For fretting wear, the FEM-based model has been employed to calculated deflection and stress distribution, and the material removal of the solids is estimated by the Archard-type equations, but unlike the sliding wear, the geometry of worn surface due to fretting are updated every $N \cdot$ -cycle to accelerate calculation [654]. To address the effects of accumulation and abrasion of wear debris, wear particles accumulated between rubbing solids have been modeled as a third body in the form of a thin-continuum layer [655].

Erosion is another category of wear that has attracted great attentions. The material loss caused by the impact of fluid-carried solid particles has been numerically investigated in a two-step approach. First, the fluid-particle flow is simulated by means of a multiphase model, in which the fluid flow is represented in Eulerian, cell-based framework, whilst the solid particle trajectory is described by Lagrangian equation of motion, and commercial software based on FEM or CFD is available and applied for solving these equations [656−659]. Afterwards, the wear volume is estimated by erosion models or empirical-based equations that express material removal of substrate as a function of velocity and angle of impacting particles [660, 661]. Efforts have been made to constitute more accurate model for the material loss due to erosion [662]. The impacting particles used to be assumed as rigid spheres, but the effects of particle shape and elasticity on erosion have been investigated by using deformable and irregular shape particles [663].

The second strategy deals with another tape of wear, in which material is removed particle-by-particle in a discrete way, and the simulations have to be carried out in a discrete approach to be discussed in Section 6.4.2.

# 6.4.2 Discrete method

The simulation of wear in a discrete way is associated with a prominent technique in computational material science, known as the discrete element method (DEM). It was originally aimed to simulate granular materials, but also found to be very useful for investigating the response of bulk materials. The idea is to convert the continuum material into a system consisting of discrete elements or particles, each of which represents a small volume of material and obeys the classical equation of motion so that the material response can be predicted by computing particle movements.

For discrete simulation of wear, however, there is a particular issue to be clarified first, i.e., how a wear particle is generated during contact and sliding, and when it detaches from substrate. In other words, it requires a material rupture criterion to model the formation and detachment of wear particles. Numerous criteria have been proposed, including the critical accumulated dissipated energy, critical accumulated plastic strain, critical accumulated damage, critical Von Misses stress, and their variants [664].

Many years ago, Rabinowicz [665] presented a criterion for the minimum size of the wear particle formed in adhesive wear due to the interplay of adhesion and plastic deformation. This mechanism of wear particle generation has been brought to a new attention recently [666], attributing to a series of MD simulations by Molinari et al. [225], which will be further discussed in Section 6.5.1. Popov and Pohrt [226] have recapitulated the Rabinowicz criterion and implemented a numerical approach based on this concept to simulate adhesive wear and evolution of surface topography. Figure 29 gives their simulation result for contact configuration and corresponding energy density from which the location and size of wear particle can be estimated.

The discrete method has been successfully applied to calculate material removals caused by adhesive wear [667], abrasive cutting [668], and erosion. In DEM simulations of erosion, for example, the substrate materials have been discretized into elements or particles, the impact-caused damage, and removal of the target material can be predicted numerically, through the mesh-dependent FEM [669], the mesh-free method of smooth particle hydrodynamics (SPH) [670, 671] or the finite volume particle method (FVPM) [663]. Figure 30 illustrates a typical discrete erosion model, in which a rigid particle collides with the target block that consists of uniformly distributed nodes each representing a volume of material.

![](images/ffe6742ed59ccf5b5fadf58ecca040af229473e9d599f9632f3ca28fd6a571a5.jpg)  
Fig. 29 (a) Contact configuration and (b) the corresponding energy density map for a given diameter $D$ . Reproduced with permission from Ref. [226]. $©$ The author(s), 2018.

# 6.4.3 Other developments and applications

Simulations of surface damages caused by contact fatigue are quite different from those of adhesive and abrasive wear. Numerous numerical schemes have been implemented for predicting fatigue wear, but a common strategy involves calculations of an equivalent stress that consists of normal/shear stress and strain, and a certain fatigue model, that relate the equivalent stress with the number of cycles to crack initiation and failure [672, 673]. In this approach, the mutual influences between fretting wear and fretting fatigue have been investigated [674].

The chemical-mechanical polishing (CMP), as one of key techniques in production of integrated circuit chips, has attracted great attentions, and numerical analysis becomes a popular way to predict material removal. The simulations have been carried out either by combining FEM calculation of contact stress with the Archard wear model [675], or in a discrete approach based on the SPH model [676], but the difficulty lies in incorporating the role of chemical reaction. In a recent development, the chemical effect has been taken into account by modeling formation and removal of tribofilm, which may provide a useful clue to the CMP simulations [677].

Numerical simulations have found broad applications in many areas of engineering for predicting wear of various components, including wheel-rail pairs [678], cutting tools [679], artificial joints [680], and bearings [681], etc.

# 6.4.4 Unsolved problems

Archard model and various modified versions, although developed on the basis of understanding atomic interactions, are unable to present exact solutions, and there is no fundamental theory for accurate prediction of wear. Numerical simulations provide an alternative approach, but the combination of contact analysis and Archard equation, applied to local contact spots, is still an approximate and unsatisfactory estimation. The new hope comes from the discrete approach, but there are many problems in DEM simulations which remain to be solved, for example, the choice of a right size of the discretized particle, the accurate description for the interactions between discrete elements, and the fundamental criterion for material failure that leads to the formation and detachment of wear particles [682]. Finally, there is a difficulty of high computational cost, and the fast estimation of wear based on machine learning framework may provide a possible solution [683].

![](images/f81ae0032638652054764c32023eb7f6aa359376aa33ef46db121eab2ffe9aca.jpg)  
Fig. 30 A schematic discrete erosion model. Reproduced with permission from Ref. [671]. $©$ World Scientific Publishing, 2018.

# 6.5 Computations in nanotribology

The rise of nanotribology has been accompanied by computer simulations since its earliest days. This section summarizes recent progresses in computational nanotribology including the MD simulation, the first principle computation, and multiscale analysis.

# 6.5.1 MD simulation

The idea to consider material response as a collective behavior of atoms is not new, but it is the rapid development of computers that makes MD simulation a popular tool in material science and tribology. In nanotribology, MD simulations have been applied to investigate atomic-scale friction, indentation, contact, wear, and lubricant design. For instance, MD simulations performed by He et al. [684] have provided valuable information for design and synthesis of high-performance friction modifiers. However, this section will mostly concentrate on the wear-related simulations while the descriptions for simulations of atomic scale friction and other atomic processes could be found in corresponding Section 6.2.

As discussed in Section 6.4, if wear is considered as a process in which material is removed particle-byparticle, the mechanism of particle formation and detachment becomes a great concern. To investigate this critical issue, Aghababaei et al. [685, 686] have carried out a series of quasi-MD simulations. They have revealed that the adhesive wear mechanism is controlled by a characteristic length scale, and proposed a model where bigger junctions produce wear debris by fracture while smaller ones smoothen out plastically (Fig. 31(a)). It is also found that the debris volume is proportional to the tangential work, i.e., the product of tangential force and sliding distance (Fig. 31(b)) [687].

![](images/35487f7b811359b9d529f3e01157d7c5052108f1af403df88a87d1822cd6abd3.jpg)  
Fig. 31 Summary of atomic simulation results with different asperity size, shape, material hardness, interfacial adhesion, applied load, sliding velocity, and boundary conditions. (a) Characteristic length for debris formation. Reproduced with permission from Ref. [685]. $©$ Springer Nature, 2016. (b) Relation between debris volume and tangential work. Reproduced with permission from Ref. [687]. $©$ Proceedings of the National Academy of Sciences of the United States of America, 2017. (c) A transition of wear condition. Reproduced with permission from Ref. [688]. $©$ American Institute of Physics, 2018. (d) A comparison to Archard’s law. Reproduced with permission from Ref. [687]. $©$ Proceedings of the National Academy of Sciences of the United States of America, 2017.

Their further simulations reveal that above certain normal load there will be a transition from mild to severe wear (Fig. 31(c)) [688], resulting in the breakdown of Archard’s law (Fig. 31(d)). In another molecular dynamics study, it is proposed that the debris generation could be considered as a chemical reaction, while its thermodynamic efficiency increases from $5 \%$ to $5 0 \%$ as the wear transits from mild to severe [230]. In addition to the studies of wear debris generation, MD simulations on nanoscale wear used to be carried out in a more straightforward way. For instance, the configuration of a particle or a tool-tip sliding over substrate has been adopted for simulating micro-cutting [689], mechanical polishing, and abrasive/adhesive wear of bulk materials [690, 691].

Another topic in simulations concerns atomic-scale wear of graphene and other 2D materials. The simulations of nanoscale wear of few-layer graphene have revealed the important role of adhesive interaction between the tip and graphene [692]. MD simulations of indentation on bare and graphene-covered Pt (111) surfaces show that covering surfaces with a graphene layer will mitigate the effect of roughness on contact properties [693]. Through simulations of the contact and scratch between a tip and substrate, Xu et al. [694] have proposed a strategy to suppress the nanoscale wear via coating graphene layers on both sides of sliding surfaces. The enhanced wear resistance is attributed to the reduction of local fluctuation of contact pressure and the weakening interactions across the interface (Fig. 32(a)). Despite the excellent mechanical properties of 2D materials discovered in microscale, they are vulnerable in macroscopic tribology test, and MD simulations have been carried out to understand the paradox. It is revealed that graphene is much easier to be damaged at the step edge, a kind of defects ubiquitous for 2D materials at the macroscale (Fig. 32(b)) [695], and the wear resistance at the step edge is found dependent on humidity, as the dangling bonds at the step edge could be passivated by water molecules (Fig. 32(c)) [696]. The grain boundaries (GBs) on graphene are also responsible for the deterioration of wear resistance, as Zhang et al. have proposed [697]. Their simulation results show that the impacts on the wear resistance associate with the GBs orientation and the strength of interactions between graphene and substrate (Fig. 32(d)).

![](images/f777510949dbb091faa53eb709eb3732f882b0422845d45e4f1f7b92e65dab86.jpg)  
Fig. 32 (a) Pressure distributions for a diamond tip with or without coated graphene layers in contact with substrate. Reproduced with permission from Ref. [694]. $©$ American Chemical Society, 2017. (b) Critical normal loads required to initiate graphene damage at the step edge or in the interior region. Reproduced with permission from Ref. [695]. $©$ American Chemical Society, 2017. (c) MD simulations of scratching a diamond tip with or without water coverage across the step edge of a graphene layer. Reproduced with permission from Ref. [696]. $©$ Elsevier, 2018. (d) Schematic representations for a carbon tip indenting upon the GB and scratching across the GB, and critical normal loads of failure for the graphene layer with armchair-oriented and zigzag-oriented GBs. Reproduced with permission from Ref. [697]. $©$ Elsevier, 2019.

In addition to the classical MD simulations, ab initio or first-principle molecular dynamics and reactive force field (ReaxFF) molecular dynamics [698], which enable to describe chemical reactions more precisely, have recently appeared as new members in the family of MD simulations. Using the ReaxFFMD simulations, for example, it is revealed that the formation and shear of interfacial bridge bonds lead to atom-by-atom removal of substrate materials, and the effect of tribochemical reactions caused by water molecules or OH groups has been investigated [699–701]. The water assisted wear of silicon-based materials has been investigated via first-principle MD simulations by Ootani et al. [702], showing that a small amount of water will promote the tribochemical wear while large amount of water will suppress the wear due to the formation of water film. A full ab initio MD simulation has been performed to study the mechanism of iron phosphide tribofilm formation under the conditions of sliding and compressing of interfaces [703].

# 6.5.2 First principle computations

An unsolved problem in MD simulations results from the difficulty in precise description of the interfacial interactions. As a solution to the difficulty, the first principle (ab initio) computations have appeared in nanotribology studies [704], which start directly from the fundamental laws of physics, without involving any empirical model or fitting parameter, so that atomic interactions at interfaces can be calculated accurately. Restuccia et al. [705] have released a high throughput first principles computational protocol to calculate two intrinsic tribological properties, i.e., the adhesion energy and shear strength of solid interface, which are crucial for understanding the origin of adhesion and static friction. Besides, the potential energy surface (PES) or landscape, associating with the energy barrier in sliding friction, is also a major concern in the first principle study with a special interest in the correlation between the PES and electronic structure. For example, in a first principle study on various types of van der Waals hetero-structure, the PES corrugation is found to be determined by the sliding induced interfacial charge density fluctuation (Figs. 33(a) and 33(b)) [29]. Gao et al. [706] have studied the frictional behaviors of Ir and Au tips sliding on graphene/Ni substrate, revealing that the strong electron orbital hybridizations between the tip and the substrate will lead to abnormal frictional properties, including a negative friction coefficient (Fig. 33(c)). A further computational study has clarified that the moiré superlattice-scale frictional modulation, observed when a tip slides over a graphene covered substrate of transition metal, originates from the electronic state overlaps caused by the joint effects of tip-graphene and graphene-substrate interactions [707]. Shi et al. [708], on the other hand, have reported that the moiré superlattice scale stick-slip could be attributed to the large sliding energy barrier arising from the morphological corrugation of graphene on Ru (0001) substrate (Fig. 33(d)), suggesting another mechanism that the PES and sliding friction may also depend on the atomic architecture at the interface.

The dependence of frictional behavior on the interfacial atomic architecture and morphological corrugation has been confirmed by independent studies. Yang et al. [709] have elucidated the roles of structural defects and water adsorption in the running-in process, showing that the chemisorption of $\scriptstyle \mathrm { H , }$ O, and OH at the defect sites will reduce the interlayer binding energy of bilayer graphene, which accounts for the coefficient of friction reduction of graphene sliding under humid environments. A recent DFT calculation indicates that the atomic scale topography and corresponding potential corrugation would be affected by chemical modifications, e.g., when a fluorinated h-BN layer slides against fluorinated h-BN/Ni (111) substrate, a smooth potential corrugation is obtained [710]. Computations have also been carried out to investigate the evolution of atomic structure during sliding, the possibility to control the interfacial architecture, and to detect the mechanism of tribochemical reactions [711].

![](images/f02273974be9f0c1cb96e7b3ff36f08ea4bba3fd3ed90034d7871b1652016749.jpg)  
Fig. 33 (a) Mapping the PES corrugation $( \Delta E )$ and interfacial charge density fluctuation for the $\mathrm { G r / G r }$ and $\mathrm { G r } / \mathrm { M o S } _ { 2 }$ systems in sliding. Reproduced with permission from Ref. [29]. $©$ Royal Society Chemistry, 2017. (b) The calculated PES corrugation $( \Delta E )$ as a function of the interfacial charge density fluctuation $( \Delta \rho )$ , the measured interlayer lateral force constants $( \boldsymbol { a } _ { 1 } )$ are also plotted for a comparison. Reproduced with permission from Ref. [29]. $©$ Royal Society Chemistry, 2017. (c) Charge transfer distributions and the PES corrugation between a 10-atom Ir tip and graphene/Ni (111) substrate. Reproduced with permission from Ref. [706]. $©$ American Chemical Soeity, 2017. (d) Surface morphology of graphene on Ru (0001) and the corresponding PES corrugations. Reproduced with permission from Ref. [708]. $©$ Institute of Physics, 2017.

The first principle computation has been applied to explore new generations of lubricant materials. For example, a computational study shows that molybdenum and tungsten dioxides exhibit better lubricity and higher mechanical strength in comparison to the widely used disulfides [26]. Two research groups [712, 713] have studied the frictional properties of Mxenes, a 2D material which has recently aroused widespread interest, proving that they are promising lubricating materials with low and controllable sliding energy barrier and excellent mechanical properties. Another kind of 2D material, layered electride ${ \mathrm { C a } } _ { 2 } { \mathrm { N } } ,$ has also been found to be a potential solid lubricant, exhibiting strong interlayer binding interactions but low interlayer friction due to the homogeneous conduction electrons distribution [714].

# 6.5.3 Multiscale analysis—An unsolved problem

A difficulty in computer simulations of tribological process remains due to lack of a proper multiscale model to handle the complex multiscale and multiphysical phenomena [704]. The quasi-continuum (QC) method, which integrates the molecular dynamics and the finite element method, has been a widely employed approach to carry out multiscale simulations. Using the QC method, for example, Zhu et al. [715] have simulated the process of copper chemical mechanical polishing to investigate the effect of particle size on the quality, plastic deformation, and residual stress of the workpiece. A similar approach has been employed to study the friction and scratch characteristics of textured and rough surfaces of pure aluminum [716]. Another example involves the use of coupled multiscale DEM–FEM method to investigate the tire-pavement friction [717].

Besides, some methods described in previous sections can be classified as multiscale approaches. For instance, the ab initial MD simulation in Section 6.5.1 is in fact a multiscale method that directly couples the first principle computation with MD simulation [702, 703]. The DEM is another way to cross over different scales since each element or particle represents a small volume of material consisting of a group of atoms, which enables to simulate a much larger system [671]. There is an implicit strategy for multiscale analysis, i.e., making use of a certain type of formulation to transfer the information from small scale calculation up to the larger scale investigation. Examples include the potential functions and reactive force fields which are obtained from the first principle study and to be used in MD simulations [718], or a description of lubricant property formulated from MD simulations to be applied in fluid mechanics. For example, Savio et al. [719] have conducted a multiscale study that extracts a formulation from MD simulations to describe the dependence of the slip length on velocity, film thickness, and pressure, and the formulation is coupled with the modified Reynolds equation to investigate the wall slip effect in nanometerthick lubricant films.

There is a symposium on the multiscale materials modeling (MMM) conference every two years, presenting the most cutting-edge researches in tribology simulations. In 2018, the symposium was held at Osaka, Japan, and organized by Prof. Kubo and his co-chairs [720]. Despite various multiscale approaches have been proposed, researchers are still unsatisfied and keep looking for a better solution, which characterizes the target and demands in future studies of computer simulations.

# 7 Conclusions and outlook

This review pertaining to advances has shown that tribology research activities have seen rapid growth in recent times and the reach of tribology is expanding beyond the conventional domains. The salient concluding remarks pertaining to different themes of research reviewed are as follows:

1) Researches on superlubricity with DLC coatings, graphene, other emerging 2D materials, and new additives are expanding rapidly recent years. In the future, novel mechanisms of superlubricity need to be explored to extend the scope of this area. Exploring the lower limit of friction coefficient by using equipment with higher sensitivity in force detection and precise control of experimental conditions. New material systems such as the plant-derived compounds and polymers, two-dimensional metal nitrides or carbides with higher quality should be developed. The dispersancy of inorganic materials in lubricating oil is the primary factor restricting their application in lubrication. There is thus an urgent need to develop versatile and environment-friendly methods to overcome this hindrance as well as to develop technologies to use recycled nanomaterials so as to minimize the wastage of limited material resources. To achieve superlubricity at larger scales is important for potential applications in industries. There should also be greater emphasis on cleaning and reuse of the used lubricating oil in future.

2) Research on wear of materials is mainly driven by strong industrial demands on higher reliability and longer lifetime of a variety of products. Zero or near zero wear has been pursuing for many MEMS/ NEMS devices, small scale, and precision mechanical systems. Besides lubrication technology, developing and application of new composited materials, antiwear coatings, and surface modifications is the trend for improvement of wear resistance of materials. Meanwhile, on-line oil analysis and condition monitoring technologies are expected to further develop along with the rapid progress in technologies of information, networking, big data, and artificial intelligence.

3) The recent biotribology covers a wide range of topics. While it is important to develop further research in each specific area, it is equally important to examine generic issues and underlying mechanisms. A number of similarities, either from materials or methodologies points of view can be found and this will help further develop the research in biotribology. Applications of the most up to date research in tribology will be important as well as extending biotribology research beyond common engineering disciplines.

4) High temperature tribology research activities transcend various scientific disciplines and are rapidly growing. The fundamental understanding of high temperature tribological processes is still inadequate and there are hardly any models to reliably predict friction and wear at elevated temperatures. The major thrust of current research work has been in developing materials and surface modification technologies for controlling friction and wear at high temperatures. There has been significant progress in this direction and the quest for effectively controlling friction and wear in different applications will continue. Both experimentation as well as modelling pertaining to friction and wear processes are difficult and there is need to develop new techniques and tools to solve high temperature tribological problems.

5) Numerical analysis of lubrication has significantly matured but efforts would continue in developing more comprehensive models or new numerical schemes. Most studies are expected to be orientated to applications. The impressive number of publications and various numerical approaches suggest that there is a quite room for developing computer simulations in contact mechanics. Numerical simulations of wear are still in an early age of development. There is no fundamental theory for accurate prediction of wear, the combination of lubrication/contact analysis with the Archard equation is only a temporary solution, and there is a long way to go in refining the DEM-based approaches. MD simulations and the first principle calculations have become the fastest growing research area in recent decades, but the current capability of computer hardware has greatly limited the space and time scale of simulation, and scientists are trying very hard to pursue an approach for multiscale simulation, but the progress so far is not impressive enough.

# Acknowledgements

This work was financially supported by National Natural Science Foundation of China (Grant Nos. 51635009 and 51775460) and the funding of State Key Laboratory of Tribology, China (SKLT2018C05).

Open Access This article is licensed under a Creative Commons Attribution 4.0 International Li-cense, which permits use, sharing, adaptation, distribution and reproduction in any medium or for-mat, as long as you give appropriate credit to the original author(s) and the source, provide a link to the Creative Commons licence, and indicate if changes were made.

The images or other third party material in this article are included in the article’s Creative Commons licence, unless indicated otherwise in a credit line to the material. If material is not in-cluded in the article’s Creative Commons licence and your intended use is not permitted by statutory regulation or exceeds the permitted use, you will need to obtain permission directly from the copyright holder.

To view a copy of this licence, visit http://creativecommons.org/licenses/by/4.0/.

# References

[1] Erdemir A, Eryilmaz O. Achieving superlubricity in DLC films by controlling bulk, surface, and tribochemistry. Friction 2(2): 140–155 (2014)   
[2] Khadem M, Penkov O V, Yang H K, Kim D E. Tribology of multilayer coatings for wear reduction: A review. Friction 5(3): 248–262 (2017)   
[3] Argibay N, Babuska T F, Curry J F, Dugger M T, Lu P, Adams D P, Nation B L, Doyle B L, Pham M, Pimentel A, et al. In-situ tribochemical formation of self-lubricating diamond-like carbon films. Carbon 138: 61–68 (2018)   
[4] Wang Y X, Shang L L, Zhang G A, Zeng Z X, Wang L P, Mao C L, Lu X J, Chen S J, Xue Q J. Multi-phase carbonaceous coating with super wear resistance. Vacuum 157: 442–446 (2018)   
[5] Wang Y F, Gao K X, Zhang B, Wang Q, Zhang J Y. Structure effects of $\displaystyle \boldsymbol { \mathsf { s p } } ^ { 2 }$ -rich carbon films under super-low friction contact. Carbon 137: 49–56 (2018)   
[6] Wang J, Zhang K, Zhang L F, Wang F G, Zhang J Y, Zheng W T. Influence of structure evolution on tribological properties of fluorine-containing diamond-like carbon films: From fullerene-like to amorphous structures. Appl Surf Sci 457: 388–395 (2018)   
[7] Song H, Chen J, Liu Z Y, Ji L, Li H X, Ling G P, Chen J M. Toward low friction in high vacuum by designing textured a-C/IL duplex lubricating film. Vacuum 148: 11–17 (2018)   
[8] Voeltzel N, Fillot N, Vergne P, Joly L. Orders of magnitude changes in the friction of an ionic liquid on carbonaceous surfaces. J Phys Chem C 122(4): 2145–2154 (2018)   
[9] Chen X C, Zhang C H, KatoT, Yang X A, Wu S D, Wang R, Nosaka M, Luo J B. Evolution of tribo-induced interfacial nanostructures governing superlubricity in a-C:H and a-C:H:Si films. Nat Commun 8: 1675 (2017)   
[10] Spikes H. Stress-augmented thermal activation: Tribology feels the force. Friction 6(1): 1–31 (2018)   
[11] Yue Z F, Wang Y F, Zhang J Y. Microstructure changes of self-mated fullerene-like hydrogenated carbon films from low friction to super-low friction with the increasing normal load. Diamond Relat Mater 88: 276–281 (2018)   
[12] Fukumasu N K, Bernardes C F, Ramirez M A, Trava-Airoldi V J, Souza R M, Machado I F. Local transformation of amorphous hydrogenated carbon coating induced by high contact pressure. Tribol Int 124: 200–208 (2018)   
[13] Liu Y H, Yu B J, Cao Z Y, Shi P F, Zhou N N, Zhang B, Zhang J Y, Qian L M. Probing superlubricity stability of hydrogenated diamond-like carbon film by varying sliding velocity. Appl Surf Sci 439: 976–982 (2018)   
[14] Bhowmick S, Khan M Z U, Banerji A, Lukitsch M J, Alpas A T. Low friction and wear behaviour of non-hydrogenated DLC (a-C) sliding against fluorinated tetrahedral amorphous carbon (ta-C-F) at elevated temperatures. Appl Surf Sci 450:   
274–283 (2018) [15] Hilbert J, Mangolini F, McClimon J B, Lukes J R, Carpick R W. Si doping enhances the thermal stability of diamond-like carbon through reductions in carbon-carbon bond length disorder. Carbon 131: 72–78 (2018) [16] Wang Y, Xu J X, Zhang J, Chen Q, Ootani Y, Higuchi Y, Ozawa N, Martin J M, Adachi K, Kubo M. Tribochemical reactions and graphitization of diamond-like carbon against alumina give volcano-type temperature dependence of friction coefficients: A tight-binding quantum chemical molecular dynamics simulation. Carbon 133: 350–357 (2018) [17] Huo L, Wang S H, Pu J B, Sun J H, Lu Z B, Ju P F, Wang L P. Exploring the low friction of diamond-like carbon films in carbon dioxide atmosphere by experiments and firstprinciples calculations. Appl Surf Sci 436: 893–899 (2018) [18] Shi J, XiaT D, Wang C B, Yuan K, Zhang J Y. Ultra-low friction mechanism of highly $\mathsf { s p } ^ { 3 }$ -hybridized amorphous carbon controlled by interfacial molecule adsorption. Phys Chem Chem Phys 20(35): 22445–22454 (2018) [19] Bakoglidis K D, Palisaitis J, Dos Santos R B, Rivelino R, Persson P O Å, Gueorguiev G K, Hultman L. Self-healing in carbon nitride evidenced as material inflation and superlubric behavior. ACS Appl Mater Interfaces 10(19):   
16238–16243 (2018) [20] Nevshupa R, Caro J, Arratibel A, Bonet R, Rusanov A, Ares J R, Roman E. Evolution of tribologically induced chemical and structural degradation in hydrogenated a-C coatings. Tribol Int 129: 177–190 (2019) [21] Sato T, Nabeya S, Menon V, Ishida T, Kometani R, Fujita H. Real-time observation of slipping and rolling events in DLC wear nanoparticles. Nanotechnology 29(32): 325707 (2018) [22] Kuwahara T, Romero P A, Makowski S, Weihnacht V, Moras G, Moseler M. Mechano-chemical decomposition of organic friction modifiers with multiple reactive centres induces superlubricity of ta-C. Nat Commun 10(1): 151 (2019) [23] Zhang G L, Wang Y C, Liu Y, Liu X F, Wang Y M. Significant friction reduction of high-intensity pulsed ion beam irradiated WC–Ni against graphite under water lubrication. Friction 7(3): 217–226 (2019) [24] Hirano M, Shinjo K. Atomistic locking and friction. Phys Rev B 41(17): 11837–11851 (1990) [25] Dienwiebel M, Verhoeven G S, Pradeep N, Frenken J W M, Heimberg J A, Zandbergen H W. Superlubricity of graphite. Phys Rev Lett 92(12):126101 (2004) [26] Nian J Y, Chen L W, Guo Z G, Liu W M. Computational investigation of the lubrication behaviors of dioxides and disulfides of molybdenum and tungsten in vacuum. Friction 5(1): 23–31 (2017)   
[27] Ky D L C, Khac B C T, Le C T, Kim Y S, Chung K H. Friction characteristics of mechanically exfoliated and CVDgrown single-layer $\mathbf { M o S } _ { 2 }$ . Friction 6(4): 395–406 (2018)   
[28] Brazda T, Silva A, Manini N, Vanossi A, Guerra R, Tosatti E, Bechinger C. Experimental observation of the Aubry transition in two-dimensional colloidal monolayers. Phys Rev X 8(1): 011050 (2018)   
[29] Wang L F, Zhou X, Ma T B, Liu D M, Gao L, Li X, Zhang J, Hu Y Z, Wang H, Dai Y D, et al. Superlubricity of a graphene $\mathrm { \Delta } M _ { 0 } \mathrm { S } _ { 2 }$ heterostructure: A combined experimental and DFT study. Nanoscale 9(30): 10846–10853 (2017)   
[30] Wang L F, Ma T B, Hu Y Z, Zheng Q S, Wang H, Luo J B. Superlubricity of two-dimensional fluorographene $\mathbf { \Delta } \mathsf { M o S } _ { 2 }$ heterostructure: A first-principles study. Nanotechnology 25(38): 385701 (2014)   
[31] Zheng X H, Gao L, Yao Q Z, Li Q Y, Zhang M, Xie X M, Qiao S, Wang G, Ma T B, Di Z F, et al. Robust ultra-lowfriction state of graphene via moiré superlattice confinement. Nat Commun 7: 13204 (2016)   
[32] Liu Y M, Song A S, Xu Z, Zong R L, Zhang J, Yang W Y, Wang R, Hu Y Z, Luo J B, Ma T B. Interlayer friction and superlubricity in single-crystalline contact enabled by twodimensional flake-wrapped atomic force microscope tips. ACS Nano 12(8): 7638–7646 (2018)   
[33] Zhou X, Jin K, Cong X, Tan Q H, Li J Y, Liu D M, Luo J B. Interlayer interaction on twisted interface in incommensurate stacking $\mathbf { M o S } _ { 2 }$ : A Raman spectroscopy study. J Colloid Interface Sci 538: 159–164 (2019)   
[34] Dietzel D, De Wijn A S, Vorholzer M, Schirmeisen A. Friction fluctuations of gold nanoparticles in the superlubric regime. Nanotechnology 29(15): 155702 (2018)   
[35] Büch H, Rossi A, Forti S, Convertino D, Tozzini V, Coletti C. Superlubricity of epitaxial monolayer $\mathrm { W S } _ { 2 }$ on graphene. Nano Res 11(11): 5946–5956 (2018)   
[36] Sadeghi A.Superlubricity controlled by the multiatomic nature of nanocontacts. Phys Rev B 98(7): 075407 (2018)   
[37] Sun J H, Zhang Y N, Lu Z B, Li Q Y, Xue Q J, Du S Y, Pu J B, Wang L P. Superlubricity enabled by pressureinduced friction collapse. J Phys Chem Let 9(10): 2554–2559 (2018)   
[38] Liu Z, Yang J R, Grey F, Liu J Z, Liu Y L, Wang Y B, Yang Y L, Cheng Y, Zheng Q S. Observation of microscale superlubricity in graphite. Phys Rev Lett 108(20): 205503 (2012)   
[39] Zhang R F, Ning Z Y, Zhang Y Y, Zheng Q S, Chen Q, Xie H H, Zhang Q, Qian W Z, Wei F. Superlubricity in centimetres-long double-walled carbon nanotubes under ambient conditions. Nat Nanotechnol 8(12): 912–916 (2013)   
[40] Liu S W, Wang H P, Xu Q, Ma T B, Yu G, Zhang C H, Geng D C, Yu Z W, Zhang S G, Wang W Z, et al. Robust microscale superlubricity under high contact pressure enabled by graphene-coated microsphere. Nat Commun 8: 14029 (2017)   
[41] Liu B T, Wang J, Peng X N, Qu C Y, Ma M, Zheng Q S. Direct fabrication of graphite-mica heterojunction and in situ control of their relative orientation. Mater Des 160: 371–376 (2018)   
[42] Song Y M, Mandelli D, Hod O, Urbakh M, Ma M, Zheng Q S. Robust microscale superlubricity in graphite/hexagonal boron nitride layered heterojunctions. Nat Mater 17(10): 894–899 (2018)   
[43] Berman D, Deshmukh S A, Sankaranarayanan S K R S, Erdemir A, Sumant A V. Macroscale superlubricity enabled by graphene nanoscroll formation. Science 348(6239): 1118–1122 (2015)   
[44] Berman D, Narayanan B, Cherukara M J, Sankaranarayanan S K R S, Erdemir A, Zinovev A, Sumant A V. Operando tribochemical formation of onion-like-carbon leads to macroscale superlubricity. Nat Commun 9(1): 1164 (2018)   
[45] Gong Z B, Bai C N, Qiang L, Gao K X, Zhang J Y, Zhang B. Onion-like carbon films endow macro-scale superlubricity. Diamond Relat Mater 87: 172–176 (2018)   
[46] Li J J, Gao T Y, Luo J B. Superlubricity of graphite induced by multiple transferred graphene nanoflakes. Adv Sci 5(3): 1700616 (2018)   
[47] Li J J, Li J F, Luo J B. Superlubricity of graphite sliding against grapheme nanoflake under ultrahigh contact pressure. Adv Sci 5(11): 1800810 (2018)   
[48] Zhang S, Ma T B, Erdemir A, Li Q Y. Tribology of two-dimensional materials: From mechanisms to modulating strategies. Mater Today 26: 67–86 (2019)   
[49] Vazirisereshk M R, Ye H, Ye Z J, Otero-de-la-Roza A, Zhao M Q, Gao Z L, Johnson A T C, Johnson E R, Carpick R W, Martini A. Origin of nanoscale friction contrast between supported graphene, $\mathbf { M o S } _ { 2 }$ , and a graphene $\mathbf { \hat { M o S } } _ { 2 }$ heterostructure. Nano Lett 19(8): 5496–5505 (2019)   
[50] Li B W, Yin J, Liu X F, Wu H R, Li J D, Li X M, Guo W L. Probing van der Waals interactions at two-dimensional heterointerfaces. Nat Nanotechnol 14(6): 567–572 (2019)   
[51] Liu L C, Zhou M, Jin L, Li L C, Mo Y T, Su G S, Li X, Zhu H W, Tian Y. Recent advances in friction and lubrication of graphene and other 2D materials: Mechanisms and applications. Friction 7(3): 199–216 (2019)   
[52] Luo J B, Lu X C, Wen S Z. Developments and unsolved problems in nano-lubrication. Prog Nat Sci 11(3): 173–183 (2001)   
[53] Klein J, Kumacheva E, Mahalu D, Perahia D, Fetters L J. Reduction of frictional forces between solid surfaces bearing polymer brushes. Nature 370(6491): 634–636 (1994)   
[54] Zhou F, Wang X L, Kato K J, Dai Z D. Friction and wear property of $\mathrm { a - C N } _ { x }$ coatings sliding against $\mathrm { S i } _ { 3 } \mathrm { N } _ { 4 }$ balls in water. Wear 263(7–12): 1253–1258 (2007)   
[55] Matta C, Joly-Pottuz L, De Bouchet M I, Martin J M, Kano M, Zhang Q, Goddard III W A. Superlubricity and tribochemistry of polyhydric alcohols. Phys Rev B 78(8): 085436 (2008)   
[56] Ma L R, Gaisinskaya-Kipnis A, Kampf N, Klein J. Origins of hydration lubrication. Nat Commun 6: 6060 (2015)   
[57] Zhang S M, Zhang C H, Li K, Luo J B. Investigation of ultra-low friction on steel surfaces with diketone lubricants. RSC Adv 8(17): 9402–9408 (2018)   
[58] Li J J, Zhang C H, Sun L, Luo J B. Analysis of measurement inaccuracy in superlubricity tests. Tribol Trans 56(1): 141–147 (2013)   
[59] Deng M M, Zhang C H, Li J J, Ma L R, Luo J B. Hydrodynamic effect on the superlubricity of phosphoric acid between ceramic and sapphire. Friction 2(2): 173–181 (2014)   
[60] Luo J B, Deng M M, Zhang C H. Advances in superlubricity. In Proceedings ofPlenary Talk at ITS-IFToMM 2017, Jeju, Korea.   
[61] Deng M M. Investigation of liquid superlubricity mechansim. Ph.D. Thesis. Beijing (China): Tsinghua University, 2017.   
[62] Deng M M, Li J J, Zhang C H, Ren J, Zhou N N, Luo J B. Investigation of running-in process in water-based lubrication aimed at achieving super-low friction. Tribol Int 102: 257–264 (2016)   
[63] Niiyama Y, TakenoT, KuriharaK, Adachi K. Effect of sliding history on super-low friction of diamond-like carbon coating in water lubrication. Tribol Lett 65(2): 63 (2017)   
[64] Ma Z Z, Zhang C H, Luo J B, Lu X C, Wen S Z. Superlubricity of a mixed aqueous solution. Chin Phys Lett 28(5): 056201 (2011)   
[65] Li J J, Ma L R, Zhang S H, Zhang C H, Liu Y H, Luo J B. Investigations on the mechanism of superlubricity achieved with phosphoric acid solution by direct observation. J Appl Phys 114(11): 114901 (2013)   
[66] Li J J, Zhang C H, Luo J B. Superlubricity achieved with mixtures of polyhydroxy alcohols and acids. Langmuir 29(17): 5239–5245 (2013)   
[67] Li J J, Zhang C H, Ma L R, Liu $\mathrm { ~ Y ~ H ~ }$ , Luo J B. Superlubricity achieved with mixtures of acids and glycerol. Langmuir 29(1): 271–275 (2013)   
[68] Chen Z, Liu Y H, Zhang S H, Luo J B. Controllable superlubricity of glycerol solution via environment humidity. Langmuir 29(38): 11924–11930 (2013)   
[69] Li J J, Liu Y H, Luo J B, Liu P X, Zhang CH. Excellent lubricating behavior of Brasenia schreberi mucilage. Langmuir 28(20): 7797–7802 (2012)   
[70] Li J J, Zhang C H, Deng M M, Luo J B. Superlubricity of silicone oil achieved between two surfaces by running-in with acid solution. RSC Adv 5(39): 30861–30868 (2015)   
[71] Li J J, Zhang C H, Cheng P, Chen X C, Wang W Q, Luo J B. AFM studies on liquid superlubricity between silica surfaces achieved with surfactant micelles. Langmuir 32(22): 5593–5599 (2016)   
[72] Ge X Y, Li J J, Zhang C H, Luo J B. Liquid superlubricity of polyethylene glycol aqueous solution achieved with boric acid additive. Langmuir 34(12): 3578–3587(2018)   
[73] Li J J, Zhang C H, Luo J B. Superlubricity behavior with phosphoric acid-water network induced by rubbing. Langmuir 27(15): 9413–9417 (2011)   
[74] Ge X Y, Li J J, Zhang C H, Wang Z N, Luo J B. Superlubricity of 1-Ethyl-3-methylimidazolium trifluoromethanesulfonate ionic liquid induced by tribochemical reactions. Langmuir 34(18): 5245–5252 (2018)   
[75] Xiao C, Li J J, Chen L, Zhang C H, Zhou N N, Qing T, Qian L M, Zhang J Y, Luo J B. Water-based superlubricity in vacuum. Friction 7(2): 192–198 (2019)   
[76] Luo J B, Wen S Z, Huang P. Thin film lubrication. Part I. Study on the transition between EHL and thin film lubricationusing a relative optical interference intensity technique. Wear 194(1–2): 107–115 (1996)   
[77] Ma L R, Luo J B. Thin film lubrication in the past 20 years. Friction 4(4): 280–302 (2016)   
[78] Ge X Y, Halmans T, Li J J, Luo J B. Molecular behaviors in thin film lubrication—Part three: Superlubricity attained by polar and nonpolar molecules. Friction 7(6): 625–636 (2019)   
[79] Li K, Zhang S M, Liu D S, Amann T, Zhang C H, Yuan C Q, Luo J B. Superlubricity of 1,3-diketone based on autonomous viscosity control at various velocities. Tribol Int 126: 127–132 (2018)   
[80] Han T Y, Zhang C H, Luo J B. Macroscale superlubricity enabled by hydrated alkali metal ions. Langmuir 34(38): 11281–11291 (2018)   
[81] Dašić M, Stanković I, Gkagkas K. Influence of confinement on flow and lubrication properties of a salt model ionic liquid investigated with molecular dynamics. Eur Phys $J E$ 41(11): 130 (2018)   
[82] Zhang F, Fang C, Qiao R. Effects of water on mica–ionic liquid interfaces. The J Phys Chem $C$ 122(16): 9035–9045 (2018)   
[83] De Freitas A A, Shimizu K, Smith A M, Perkin S, Canongia Lopes $\mathrm { ~ J ~ N ~ }$ . Structure and dynamics of mica-confined films of $[ \mathrm { C _ { 1 0 } C _ { 1 } P y r r } ] [ \mathrm { N T f _ { 2 } } ]$ ionic liquid. J Chem Phys 148(19): 193808 (2018)   
[84] Khatri $\mathrm { ~ P ~ K ~ }$ , Aathira $\textrm { \textbf { M S } }$ , Thakre G D, Jain S L. Synthesis and tribological behavior of fatty acid constituted tetramethylguanidinium (TMG) ionic liquids for a steel/steel contact. Mater Sci Eng C 91: 208–217 (2018) [85] Shi X, Huang W, Wang X L. Ionic liquids-based magnetic nanofluids as lubricants. Lubr Sci 30(2): 73–82 (2018) [86] An R, Zhou G B, Zhu Y D, Zhu W, Huang L L, Shah F U. Friction of ionic liquid–glycol ether mixtures at titanium interfaces: Negative load dependence. Adv Mater Interfaces   
5(14): 1800263 (2018) [87] Han M W, Espinosa-Marzal R M. Molecular mechanisms underlying lubrication by ionic liquids: Activated slip and flow. Lubricants 6(3): 64 (2018) [88] Zheng D D, Wang X B, Zhang M, Liu Z G, Ju C. Anticorrosion and lubricating properties of a fully green lubricant. Tribol Int 130: 324–333 (2019) [89] Li W M, Kumara C, Meyer III H M, Luo H M, Qu J. Compatibility between various ionic liquids and an organic friction modifier as lubricant additives. Langmuir 34(36):   
10711–10720 (2018) [90] Gong X, Li L. Nanometer-thick ionic liquids as boundary lubricants. Adv Eng Mater 20(5): 1700617 (2018) [91] Lhermerout R, Diederichs C, Perkin S. Are ionic liquids good boundary lubricants? A molecular perspective. Lubricants   
6(1): 9 (2018) [92] Jiang C, Li W M, Nian J Y, Lou W J, Wang X B. Tribological evaluation of environmentally friendly ionic liquids derived from renewable biomaterials. Friction 6(2):   
208–218 (2018) [93] Amann T, Gatti F, Oberle N, Kailer A, Ruhe J. Galvanically induced potentials to enable minimal tribochemical wear of stainless steel lubricated with sodium chloride and ionic liquid aqueous solution. Friction 6(2): 230–242 (2018) [94] Ge X Y, Li J J, Zhang C H, Liu Y H, Luo J B. Superlubricity and antiwear properties of in situ-formed ionic liquids at ceramic interfaces induced by tribochemical reactions. ACS Appl Mater Interfaces 11(6): 6568–6574 (2019) [95] González R, Ramos D, Blanco D, Fernández-González A, Viesca J L, Hadfield M, Battez A H. Tribological performance of tributylmethylammonium bis(trifluoromethylsulfonyl)amide as neat lubricant and as an additive in a polar oil. Friction   
7(3): 282–288 (2019) [96] Pashazanusi L, Oguntoye M, Oak S, Albert J N L, Pratt L R, Pesika N S. Anomalous potential-dependent friction on Au(111) measured by AFM. Langmuir 34(3): 801–806 (2018) [97] Wu S F, Gao D R, Liang Y N, Chen B. Experimental study on influence of dimples on lubrication performance of glass fiber-epoxy resin composite under natural seawater lubrication. Chin J Mech Eng 30(1): 110–117 (2017) [98] Li J J, Cao W, Wang Z N, Ma M, Luo J B. Origin of hydration lubrication of zwitterions on graphene. Nanoscale 10(35):   
16887–16894 (2018)   
[99] Li J J, Luo J B. Normal and frictional force hysteresis between self-assembled fluorosurfactant micelle arrays at the nanoscale. Adv Mater Interfaces 5(4): 1700802 (2018)   
[100] Arif T, Colas G, Filleter T. Effect of humidity and water intercalation on the tribological behavior of graphene and graphene oxide. ACS Appl Mater Interfaces 10(26): 22537– 22544 (2018)   
[101] Weber B, Nagata Y, Ketzetzi S, Tang F J, Smit W J, Bakker H J, Backus E H G, Bonn M, Bonn D. Molecular insight into the slipperiness of ice. J Phys Chem Lett 9(11): 2838–2842 (2018)   
[102] Guo Z W, Yuan C Q, Bai X Q, Yan X P. Experimental study on wear performance and oil film characteristics of surface textured cylinder liner in marine diesel engine. Chin J Mech Eng 31(1): 52 (2018)   
[103] Zhao Y, Li W M, Wang X B, Wang J. Tribological properties of trimellitates containing polymethacrylates viscosity modifiers. Proc Inst Mech Eng, Part J: J Eng Tribol 232(7): 882–889 (2018)   
[104] Wang X, Li Y, Liu J S, Lin J M, Zhang J R. Molecular structure design of diesel anti-wear agents. Acta Pet Sin(Pet Process Sect) 34(2): 229–237 (2018)   
[105] Shi H Y, Lu X C, Liu Y H, Song J, Deng K, Zeng Q D, Wang C. Nanotribological study of supramolecular template networks induced by hydrogen bonds and van der waals forces. ACS Nano 12(8): 8781–8790 (2018)   
[106] Liang H, Guo D, Luo J B. Film forming behavior in thin film lubrication at high speeds. Friction 6(2): 156–163 (2018)   
[107] Wang Z J, Shen X J, Chen X Y, Tao D H, Shi L, Liu S B. Experimental investigation of EHD grease lubrication in finite line contacts. Friction 7(3): 237–245 (2019)   
[108] Gao M, Li H Y, Ma L R, Gao Y, Ma L W, Luo J B. Molecular behaviors in thin film lubrication—Part two: Direct observation of the molecular orientation near the solid surface. Friction 7(5): 479–488 (2019)   
[109] Zhang S H, Qiao Y J, Liu Y H, Ma L R, Luo J B. Molecular behaviors in thin film lubrication—Part one: Film formation for different polarities of molecules. Friction 7(4): 372–387 (2019)   
[110] Krass M D, Krämer G, Dellwo U, Bennewitz R. Molecular layering in nanometer-confined lubricants. Tribolo Lett 66(3): 87 (2018)   
[111] Okubo H, Sasaki S. Frequency-modulation atomic force microscopic observation for ultralow frictional solid–liquid interface of diamond-like carbon in an environmentally friendly oil. Tribol Lett 67(1): 3 (2019)   
[112] Zeng Q F. Understanding the lubrication mechanism between the polyhydroxyl group lubricants and metal surfaces. J Adhes Sci Technol 32(17): 1911–1924 (2018)   
[113] Ta T D, Tieu A K, Zhu H, Wan S, Phan H T, Hao J. Influence of molecular structure on lubrication of aqueous triblock copolymer lubricants between rutile surfaces: An MD approach. Tribol Int 130: 170–183 (2019)   
[114] Ewen J P, Heyes D M, Dini D. Advances in nonequilibrium molecular dynamics simulations of lubricants and additives. Friction 6(4): 349–386 (2018)   
[115] Xu R G, Leng Y S. Squeezing and stick–slip friction behaviors of lubricants in boundary lubrication. Proc Natl Acad SciUSA 115(26): 6560–6565 (2018)   
[116] Xu L H, Zhang Y, Zhang D K, Leng M. Preparation and tribological properties of Ag nanoparticles/reduced graphene oxide nanocomposites. Ind Lubr Tribol 70(9): 1684–1691 (2018)   
[117] Sahu J, Panda K, Gupta B, Kumar N, Manojkumar P A, Kamruddin M. Enhanced tribo-chemical properties of oxygen functionalized mechanically exfoliated hexagonal boron nitride nanolubricant additives. Mater Chem Phys 207: 412–422 (2018)   
[118] Wu P R, Li W, Feng Y M, Ge T, Liu Z, Cheng Z L. Fabrication and tribological properties of oil-soluble $\mathbf { M o S } _ { 2 }$ nanosheets decorated by oleic diethanolamide borate. J Alloys Compd 770: 441–450 (2019)   
[119] Wang W, Xie G X, Luo J B. Black phosphorus as a new lubricant. Friction 6(1): 116–142 (2018)   
[120] Ran J C, Xie H L, Lai X J, Li H Q, Zeng X R. Significant improvement of tribological performances of polyamide 46/polyphenylene oxide alloy by functionalized zirconium phosphate. Tribol Int 128: 204–213 (2018)   
[121] Wang H D, Liu Y H, Liu W R, Wang R, Wen J G, Sheng H P, Peng J F, Erdemir A, Luo J B. Tribological behavior of NiAl-layered double hydroxide nanoplatelets as oil-based lubricant additives. ACS Appl Mater Interfaces 9(36): 30891–30899 (2017)   
[122] Bai P P, Li S W, Tao D S, Jia W P, Meng Y G, Tian Y. Tribological properties of liquid-metal galinstan as novel additive in lithium grease. Tribol Int 128: 181–189 (2018)   
[123] Shang W J, Ye M T, Cai T, Zhao L N, Zhang Y X, Liu D, Liu S G. Tuning of the hydrophilicity and hydrophobicity of nitrogen doped carbon dots: A facile approach towards high efficient lubricant nanoadditives. J Mol Liq 266: 65–74 (2018)   
[124] Gao K, Chang Q Y, Wang B, Zhou N N, Qing T. The purification and tribological property of the synthetic magnesium silicate hydroxide modified by oleic acid. Lubr Sci 30(7): 377–385 (2018)   
[125] Xia W Z, Zhao J W, Wu H, Zhao X M, Zhang X M, Xu J Z, Jiao S H, Wang X G, Zhou C L, Jiang Z Y. Effects of oil-in-water based nanolubricant containing $\mathrm { T i O } _ { 2 }$ nanoparticles in hot rolling of 304 stainless steel. $J$ Mater Process Technol 262: 149–156 (2018)   
[126] Meng Y, Su F H, Chen Y Z. Nickel/multi-walled carbon nanotube nanocomposite synthesized in supercritical fluid as efficient lubricant additive for mineral oil. Tribol Lett 66(4): 134 (2018)   
[127] Chen Z, Liu X W, Liu Y H, Gunsel S, Luo J B. Ultrathin $\mathbf { M o S } _ { 2 }$ nanosheets with superior extreme pressure property as boundary lubricants. Sci Rep 5: 12869 (2015)   
[128] Li Z L, Xu C H, Xiao G C, Zhang J J, Chen Z Q, Yi M D. Lubrication performance of graphene as lubricant additive in 4-n-pentyl- $\cdot 4 ^ { \prime }$ -cyanobiphyl liquid crystal (5CB) for steel/ steel contacts. Materials 11(11): 2110 (2018)   
[129] He C, Yan H H, Wang X H, Bai M L. Graphene quantum dots prepared by gaseous detonation toward excellent friction-reducing and antiwear additives. Diamond Relat Mater 89: 293–300(2018)   
[130] Liu L C, Zhou M, Li X, Jin L, Su G S, Mo Y T, Li L C, Zhu H W, Tian Y. Research progress in application of 2D materials in liquid-phase lubrication system. Materials 11(8): 1314 (2018)   
[131] Ge X Y, Li J J, Luo R, Zhang C H, Luo J B. Macroscale superlubricity enabled by the synergy effect of grapheneoxide nanoflakes and ethanediol. ACS App Mater Interfaces 10(47): 40863–40870 (2018)   
[132] He T X, Dai Q W, Huang W, Wang X L. Colloidal suspension of graphene oxide in ionic liquid as lubricant. Appl Phys A 124(11): 777 (2018)   
[133] Song W, Yan J C, Ji H B. Fabrication of $\mathrm { G N S } / \mathrm { M o S } _ { 2 }$ composite with different morphology and its tribological performance as a lubricant additive. Appl Surf Sci 469: 226–235 (2019)   
[134] Pamies R, Avilés M D, Arias-Pardilla J, Espinosa T, Carrión F J, Sanes J, Bermúdez M D. Antiwear performance of ionic liquid+graphene dispersions with anomalous viscositytemperature behavior. Tribol Int 122: 200–209 (2018)   
[135] Tang W W, Huang Z Y, Wang B G. Synthesis of ionic liquid functionalized graphene oxides and their tribological property under water lubrication. Fuller, Nanotub Carbon Nanostruct 26(3): 175–183 (2018)   
[136] Wu X H, Gong K L, Zhao G Q, Lou W J, Wang X B, Liu W M. Mechanical synthesis of chemically bonded phosphorus-graphene hybrid as high-temperature lubricating oil additive. RSC Adv 8(9): 4595–4603 (2018)   
[137] Zhang L, He Y, Zhu L, Jiao Z L, Deng W Z, Pu C P, Han C M, Tang S. Alkyl phosphate modified graphene oxide as friction and wear reduction additives in oil. J Mater Sci 54(6): 4626–4636 (2019)   
[138] Yu B, Wang K, Hu Y W, Nan F, Pu J B, Zhao H C, Ju P F. Tribological properties of synthetic base oil containing polyhedral oligomeric silsesquioxane grafted graphene oxide. RSC Adv 8(42): 23606–23614 (2018)   
[139] Wang $\textrm { Y X }$ , Du Y Y, Deng $\textsc { J N } _ { : }$ , Wang $Z \mathrm { ~ P ~ }$ . Friction reduction of water based lubricant with highly dispersed functional $\mathbf { M o S } _ { 2 }$ nanosheets. Colloids Surf A: Physicochem Eng Aspects 562: 321–328 (2019)   
[140] Tomala A, Ripoll M R, Kogovšek J, Kalin M, Bednarska A, Michalczewski R, Szczerek M. Synergisms and antagonisms between $\mathrm { M o S } _ { 2 }$ nanotubes and representative oil additives under various contact conditions. Tribol Int 129: 137–150 (2019)   
[141] Wu P R, Liu Z, Cheng $Z \textrm { L }$ . Growth of MoS2 nanotubes templated by halloysite nanotubes for the reduction of friction in oil. ACS Omega 3(11): 15002–15008 (2018)   
[142] Wu J, Mu L W, Zhu J H, Feng X, Lu X H, Larsson R, Shi Y J. Synthesis of hollow fullerene-like molybdenum disulfide/reduced graphene oxide nanocomposites with excellent lubricating properties. Carbon 134: 423–430 (2018)   
[143] Xu Y F, Geng J, Peng Y B, Liu Z C, Yu J Y, Hu X G. Lubricating mechanism of $\mathrm { F e } _ { 3 } \mathrm { O } _ { 4 } @ \mathrm { M o S } _ { 2 }$ core-shell nanocomposites as oil additives for steel/steel contact. Tribol Int 121: 241–251 (2018)   
[144] Cheng L H, Hu E Z, Chao X Q, Zhu R F, Hu K H, Hu X G. $ { \mathbf { M o S } } _ { 2 ^ { \prime } }$ montmorillonite nanocomposite: Preparation, tribological properties, and inner synergistic lubrication. Nano 13(12): 1850144 (2018)   
[145] Wang W, Xie G X, Luo J B. Superlubricity of black phosphorus as lubricant additive. ACS Appl Mater Interfaces 10(49): 43203–43210 (2018)   
[146] Wu S, He F, Xie G X, Bian Z L, Luo J B, Wen S Z. Black phosphorus: Degradation favors lubrication. Nano Lett 18(9): 5618–5627 (2018)   
[147] Bondarev A V, Kovalskii A M, Firestein K L, Loginov P A, Sidorenko D A, Shvindina $_ { \mathrm { ~ N ~ V ~ } }$ , Sukhorukova $\begin{array} { r } { \left[ \begin{array} { l l l } { \mathbf { V } _ { : } } & { } & { } \end{array} \right. } \end{array}$ , Shtansky D V. Hollow spherical and nanosheet-base BN nanoparticles as perspective additives to oil lubricants: Correlation between large-scale friction behavior and in situ TEM compression testing. Ceram Int 44(6): 6801–6809 (2018)   
[148] Yang Y F, Wang X B, Mei S, Zhu X, Chen S Q, Xiong P, Hu Z H, Xiong K, Yuan D S. Preparation and tribological properties of BN/calcium borate nanocomposites as additive in lubricating oil. Ind Lubr Tribol 70(1): 105–114 (2018)   
[149] Li S, Ren L L, Bai $\cal Z \mathrm { ~ M ~ }$ . Friction performance and mechanisms of calcined products of $\mathrm { M g / A l }$ layered double hydroxides as lubricant additives. Appl Surf Sci 470: 979–990 (2019)   
[150] Xue M Q, Wang Z P, Yuan F, Zhang X H, Wei W, Tang H, Li C S. Preparation of $\mathrm { T i O } _ { 2 } / \mathrm { T i } _ { 3 } \mathrm { C } _ { 2 } \mathrm { T } _ { x }$ hybrid nanocomposites and their tribological properties as base oil lubricant additives. RSC Adv 7(8): 4312–4319 (2017) [1 behavior of lamellar molybdenum trioxide as a lubricant additive. Materials 11(12): 2427 (2018)   
[152] Liu Y C, Mateti S, Li C, Liu X Q, Glushenkov A M, Liu D, Li L H, Fabijanic D, Chen Y. Synthesis of composite nanosheets of graphene and boron nitride and their lubrication application in oil. Adv Eng Mater 20(2): 1700488 (2018)   
[153] Ba Z W, Han Y Y, Qiao D, Feng D P, Huang G W. Composite nanoparticles based on hydrotalcite as high performance lubricant additives. Ind Eng Chem Res 57(45): 15225–15233 (2018)   
[154] Chen Z, Liu $\textrm { Y H }$ , Gunsel S, Luo J B. Mechanism of antiwear property under high pressure of synthetic oil-soluble ultrathin $\mathbf { M o S } _ { 2 }$ sheets as lubricant additives. Langmuir 34(4): 1635–1644 (2018)   
[155] Zhai W Z, Lu W L, Liu X J, Zhou L P. Nanodiamond as an effective additive in oil to dramatically reduce friction and wear for fretting steel/copper interfaces. Tribol Int 129: 75–81 (2019)   
[156] Tang W W, Wang B G, Li J T, Li Y Z, Zhang Y, Quan H P, Huang Z Y. Facile pyrolysis synthesis of ionic liquid capped carbon dots and subsequent application as the water-based lubricant additives. J Mater Sci 54(2): 1171– 1183 (2019)   
[157] Sui T Y, Ding M, Ji C H, Yan S, Wei J H, Wang A Y, Zhao F F, Fei J X. Dispersibility and rheological behavior of functionalized silica nanoparticles as lubricant additives. Ceram Int 44(15): 18438–18443 (2018)   
[158] Huang J, Li Y, Jia $\textrm { X H }$ , Song H J. Preparation and tribological properties of core-shell $\mathrm { F e } _ { 3 } \mathrm { O } _ { 4 } @ { \mathrm { C } }$ microspheres. Tribol Int 129: 427–435 (2019)   
[159] Borda F L G, De OliveiraS J R, Lazaro L M S M, Leiróz A J K. Experimental investigation of the tribological behavior of lubricants with additive containing copper nanoparticles. Tribol Int 117: 52–58 (2018)   
[160] Wang B B, Hu E Z, Tu Z Q, David K D, Hu K H, Hu X G, Yang W, Guo J H, Cai W M, Qian W L, et al. Characterization and tribological properties of rice husk carbon nanoparticles Co-doped with sulfur and nitrogen. Appl Surf Sci 462: 944–954 (2018)   
[161] Lu Z Y, Cao Z Z, Hu E Z, Hu K H, Hu X G. Preparation and tribological properties of $\mathrm { W S } _ { 2 }$ and $\mathrm { W S } _ { 2 } / \mathrm { T i O } _ { 2 }$ nanoparticles. Tribol Int 130: 308–316 (2019)   
[162] Kumara C, Leonard D N, Meyer H M, Luo H M, Armstrong B L, Qu J. Palladium nanoparticle-enabled ultrathick tribofilm with unique composition. ACS Appl Mater Interfaces 10(37): 31804–31812 (2018)   
[163] Zhao J H, Yang G B, Zhang C L, Zhang Y J, Zhang S M, Zhang P Y. Synthesis of water-soluble Cu nanoparticles and evaluation of their tribological properties and thermal conductivity as a water-based additive. Friction 7(3):   
246–259 (2019) [164] $\mathrm { Y u } \ \mathrm { Q } \ \mathrm { L }$ , Wang Y R, Huang G W, Ma Z F, Shi Y J, Cai M R, Zhou F, Liu W M. Task-specific oil-miscible ionic liquids lubricate steel/light metal alloy: A tribochemistry study. Adv Mater Interfaces 5(19): 1800791 (2018) [165] Huang G W, Yu Q L, Ma Z F, Cai M R, Zhou F, Liu W M. Oil-soluble ionic liquids as antiwear and extreme pressure additives in poly-α-olefin for steel/steel contacts. Friction   
7(1): 18–31 (2019) [166] Xu Y F, Liu Z C, Dearn K D, Dong Y H, You T, Hu X G. Thermo-tribological behaviour of microgels for improved aqueous lubrication for steel/UHMWPE contact. Tribol Int 130: 63–73 (2019) [167] Torres O, Andablo-Reyes E, Murray B S, Sarkar A. Emulsion microgel particles as high-performance bio-lubricants. ACS Appl Mater Interfaces 10(32): 26893–26905 (2018) [168] Cosimbescu L, Demas N G, Robinson J W, Erck R A. Friction- and wear-reducing properties of multifunctional small molecules. ACS Appl Mater Interfaces 10(1): 1317–   
1323 (2018) [169] Bandhu S, Khot M B, SharmaT, Sharma O P, Dasgupta D, Mohapatra S, Hazra S, Khatri O P, Ghosh D. Single cell oil from oleaginous yeast grown on sugarcane bagassederived xylose: An approach toward novel biolubricant for low friction and wear. ACS Sustainable Chem Eng 6(1):   
275–283 (2018) [170] Aravind A, Prabhakaran Nair K, Joy $\textrm { M L }$ . Formulation of a novel biolubricant with enhanced properties using esterified rubber seed oil as a base stock. Proc Inst Mech Eng, Part J: J Eng Tribol 232(12): 1514–1524 (2018) [171] Gao $\textrm { X L }$ , Liu D H, Song Z, Dai K. Isosteric design of friction-reduction and anti-wear lubricant additives with less sulfur content. Friction 6(2): 164–182 (2018) [172] Zhong X W, Xia Y Q, Feng X. Tribological application and mechanism of epicuticular wax. Friction 7(1): 44–58 (2019) [173] Singh R K, Kukrety A, Kumar A, Chouhan A, Saxena R C, Ray S S, Jain $_ { \mathrm { ~ S ~ L ~ } }$ . Synthesis, characterization, and performance evaluation of N,N-dimethylacrylamide-alkyl acrylate copolymers as novel multifunctional additives for lube oil. Adv Polym Technol 37(6): 1695–1702 (2018) [174] Xu D C, Wang C, Espejo C, Wang J G, Neville A, Morina A. Understanding the friction reduction mechanism based on molybdenum disulfide tribofilm formation and removal. Langmuir 34(45): 13523–13533 (2018) [175] Dubey M K, Bijwe J, Ramakumar S S V. Effect of dispersant on nano-PTFE: Striking the balance between stability and tribo-performance. Lubr Sci 30(7): 339–353 (2018)   
[176] Bagheri S, Jamal N, Halilu A, TermehYousefi A. Novel rGO-T-C(n) nanosheets developed via click chemistry as a lubricant anti-wear additive. Sci Rep 8: 6221 (2018)   
[177] Gupta M K, Bijwe J, Padhan M. Role of size of hexagonal boron nitride particles on tribo-performance of nano and micro oils. Lubr Sci 30(8): 441–456 (2018)   
[178] Ye M T, Cai T, Shang W J, Zhao L N, Zhang Y X, Liu D, Liu S G. Friction-induced transfer of carbon quantum dots on the interface: Microscopic and spectroscopic studies on the role of inorganic–organic hybrid nanoparticles as multifunctional additive for enhanced lubrication. Tribol Int 127: 557–567 (2018)   
[179] Van Ravensteijn B G P, Bou Zerdan R, Seo D, Cadirov N, Watanabe T, Gerbec J A, Hawker C J, Israelachvili J N, Helgeson M E. Triple function lubricant additives based on organic–inorganic hybrid star polymers: Friction reduction, wear protection, and viscosity modification. ACS Appl Mater Interfaces 11(1): 1363–1375 (2019)   
[180] Bai $\textbf { J } \textbf { M }$ , Song J, Wei J. Tribological and mechanical properties of $\mathbf { M o S } _ { 2 }$ enhanced polyamide 12 for selective laser sintering. $J$ Mater Process Technol 264: 382–388 (2019)   
[181] Seymour B T, Wright R A E, Parrott A C, Gao H Y, Martini A, Qu J, Dai S, Zhao B. Poly(alkyl methacrylate) brush-grafted silica nanoparticles as oil lubricant additives: Effects of alkyl pendant groups on oil dispersibility, stability, and lubrication property. ACS Appl Mater Interfaces 9(29): 25038–25048 (2017)   
[182] Seymour B T, Fu W X, Wright R A E, Luo H M, Qu J, DaiS, Zhao B. Improved lubricating performance by combining oil-soluble hairy silica nanoparticles and an ionic liquid as an additive for a synthetic base oil. ACS Appl Mater Interfaces 10(17): 15129–15139 (2018)   
[183] Wang H D, He P F, Ma G Z, Xu B S, Xing Z G, Chen S Y, Liu Z, Wang Y W. Tribological behavior of plasma sprayed carbon nanotubes reinforced $\mathrm { T i O } _ { 2 }$ coatings. J Eur Ceram Soc 38(10): 3660–3672 (2018)   
[184] Kar S, Bandyopadhyay P P, Paul S. Effect of arc–current and spray distance on elastic modulus and fracture toughness of plasma-sprayed chromium oxide coatings. Friction 6(4): 387–394 (2018)   
[185] Yang L N, Wen M, Chen J H, Wang J, Dai X, Gu X L, Cui X Q, Zhang K. TiMoN nano-grains embedded into thin $\mathrm { M o S } _ { x }$ -based amorphous matrix: A novel structure for superhardness and ultra-low wear. Appl Surf Sci 462: 127– 133 (2018)   
[186] Liu J W, Jiang L, Deng C B, Du W H, Qian L M. Effect of oxide film on nanoscale mechanical removal of pure iron. Friction 6(3): 307–315 (2018)   
[187] Kiran K U V, Arora A, Sunil B R, Dumpala R. Sliding wear characteristics of as-deposited and heat-treated electroless Ni–P coatings against AISI E52100 steel ball. Mater Res Express 6(3): 036401 (2019)   
[188] Zhou J B, Liu J H, Ouyang H J, Cai Z B, Peng J F, Zhu M H. Anti-loosening performance of coatings on fasteners subjected to dynamic shear load. Friction 6(1): 32–46 (2018)   
[189] Wang H D, Ma G Z, Xu B S, Yong Q S, He P F. Design and application of friction pair surface modification coating for remanufacturing. Friction 5(3): 351–360 (2017)   
[190] Wang Z Q, Ni J, Gao D R. Combined effect of the use of carbon fiber and seawater and the molecular structure on the tribological behavior of polymer materials. Friction 6(2): 183–194 (2018)   
[191] Wang A Y, Yan S, Lin B, Zhang X F, Zhou X X. Aqueous lubrication and surface microstructures of engineering polymer materials (PEEK and PI) when sliding against $\mathrm { S i } _ { 3 } \mathrm { N } _ { 4 }$ . Friction 5(4): 414–428 (2017)   
[192] Datta S, Das M, Balla V K, Bodhak S, Murugesan V K. Mechanical, wear, corrosion and biological properties of arc deposited titanium nitride coatings. Surf Coat Technol 344: 214–222 (2018)   
[193] Yi Y L, Xing J D, Lu Y F, Gao Y M, Fu H G, Yu L L, Wan M J, Zheng Q L. Effect of normal load on two-body abrasive wear of an FeB–Cr–C based alloy with minor $\mathrm { C u }$ and Ni additions. Wear 408–409: 160–170 (2018)   
[194] Huang L, Deng X T, Jia Y, Li C R, Wang Z D. Effects of using (Ti,Mo)C particles to reduce the three-body abrasive wear of a low alloy steel. Wear 410–411: 119–126 (2018)   
[195] Mehra D, Mahapatra M M, Harsha S P. Effect of wear parameters on dry abrasive wear of RZ5-TiC in situ composite. Ind Lubr Tribol 70(2): 256–263 (2018)   
[196] NguyenT, Liu D, Thongkaew K, Li H, Qi H, Wang J. The wear mechanisms of reaction bonded silicon carbide under abrasive polishing and slurry jet impact conditions. Wear 410–411: 156–164 (2018)   
[197] Lin Z C, Wang R Y, Ma S H. Theoretical model and experimental analysis of chemical mechanical polishing with the effect of slurry for abrasive removal depth and surface morphology of silicon wafer. Tribol Int 117: 119–130 (2018)   
[198] Kanematsu W. A review of rolling contact fatigue behavior of silicon nitride focusing on testing practices and crack propagation analysis. Wear 400–401: 10–20 (2018)   
[199] Zhu W T, Guo L C, Shi L B, Cai Z B, Li Q L, Liu Q Y, Wang W J. Wear and damage transitions of two kinds of wheel materials in the rolling-sliding contact. Wear 398–399: 79–89 (2018)   
[200] Faccoli M, Petrogalli C, Lancini M, Ghidini A, Mazzù A. Effect of desert sand on wear and rolling contact fatigue behaviour of various railway wheel steels. Wear 396–397: 146–161 (2018)   
[201] Abbasi E, Luo Q S, Owens D. Case study: Wear mechanisms of NiCrVMo-steel and CrB-steel scrap shear blades. Wear 398–399: 29–40 (2018)   
[202] Dréano A, Fouvry S, Guillonneau G. A tribo-oxidation abrasive wear model to quantify the wear rate of a cobaltbased alloy subjected to fretting in low-to-medium temperature conditions. Tribol Int 125: 128–140 (2018)   
[203] Lucadamo G A, Howland W H, Tymiak-Carlson N, Smith R W, Cook J W, Zafred P R. Characterization and simulation methods applied to the study of fretting wear in Zircaloy-4. Wear 402–403: 11–20 (2018)   
[204] Huang Z J, Li W, Fan X Q, Zeng Y, Cai Z B, Zhu M H. Probing fretting behavior of $ { \mathrm { M g - S n - Y } }$ alloy under highperformance fluids lubrication. Tribol Int 138: 125–139 (2019)   
[205] Kowalski S, Cygnar M, Cieślikowski B. Analysis of the application of ZrN coatings for the mitigation of the development of fretting wear processes at the surfaces of push fit joint elements. Proc Inst Mech Eng,Part J: J Eng Tribol, in Press, DOI 10.1177/1350650119875067.   
[206] Liu Y F, Liskiewicz T W, Beake B D. Dynamic changes of mechanical properties induced by friction in the Archard wear model. Wear 428–429: 366–375 (2019)   
[207] Zhang Z, Wang D G, Guo Y B. Fretting friction and wear behaviors of spiral wound gasket (SWG) sealing surface. Tribol Int 133: 236–245 (2019)   
[208] Lavella M, Botto D. Fretting wear of alloy steels at the blade tip of steam turbines. Wear 426–427: 735–740 (2019)   
[209] Akhondizadeh M, Fooladi Mahani M, Rezaeizadeh M, Mansouri $\textrm { H S }$ . Theoretical and experimental modeling of impact wear. Ind Lubr Tribol 70(3): 490–498 (2018)   
[210] Zambrano O A, García D S, Rodríguez S A, Coronado J J. The mild-severe wear transition in erosion wear. Tribol Lett 66(3): 95(2018)   
[211] Ding H Q, Jiang S Y, Xu J. Cavitation erosion resistance of $Z \mathrm { r } \mathrm { C }$ nanoceramic coating. Proc Inst Mech Eng, Part J: J Eng Tribol, in Press, DOI 10.1177/1350650119873232.   
[212] Varga M, Antonov M, Tumma M,Adam K, Alessio K O. Solid particle erosion of refractories: A critical discussion of two test standards. Wear 426–427: 552–561 (2019)   
[213] Li G, Zhang Q, Guo L, Yu Q P, Xu G, Zhu J Q. Leakage and wear characteristics of finger seal in hot/cold state for aero-engine. Tribol Int 127: 209–218 (2018)   
[214] Dos Santos Filho D, Tschiptschin A P, Goldenstein H. Effects of ethanol content on cast iron cylinder wear in a flex-fuel internal combustion engine-A case study. Wear 406–407: 105–117 (2018)   
[215] Wang D Q, Sun D L, Han X L, Wang Q, Zhang N B. Investigation on tribological behavior of $\mathrm { T i } _ { 2 } \mathrm { A l N / T i A l }$ composite at room and elevated temperature. Tribol Lett 66(2): 52(2018)   
[216] Shanbhag V V, Rolfe B F, Griffin J M, Arunachalam N, Pereira M P. Understanding galling wear initiation and progression using force and acoustic emissions sensors. Wear 436–437:202991 (2019)   
[217] Sahlot P, Arora A. Numerical model for prediction of tool wear and worn-out pin profile during friction stir welding. Wear 408–409: 96–107 (2018)   
[218] Wang J S, Shimada K, Mizutani M, Kuriyagawa T. Tool wear mechanism and its relation to material removal in ultrasonic machining. Wear 394–395: 96–108 (2018)   
[219] Huttunen-Saarivirta E, Heino V, Vaajoki A, Hakala T J, Ronkainen H. Wear of additively manufactured tool steel in contact with aluminium alloy. Wear 432–433: 202934 (2019)   
[220] Ye J X, Tao B, Sun W, Haidar D R, Alam K I, Liu K, Burris D L. The competing effects of counterface peaks and valleys on the wear and transfer of ultra-low wear alumina-PTFE. Tribol Lett 66(1): 12(2018)   
[221] Ye J X, Sun W, Zhang Y, Liu X J, Liu K. Measuring evolution of transfer film–substrate interface using low wear alumina PTFE. Tribol Lett 66: 100 (2018)   
[222] Qi Y, Gong J, Cao W H, Wang H G, Ren J F, Gao G. Tribological behavior of PTFE composites filled with PEEK and Nano- $\mathrm { { A l } } _ { 2 } \mathrm { { O } } _ { 3 }$ . Tribol Trans 61(4): 694–704 (2018)   
[223] Panda S, Sarangi M, Roy Chowdhury $\textrm { S K }$ . An analytical model of mechanistic wear of polymers. J Tribol 140(1): 011609 (2018)   
[224] Hakami F, Pramanik A, Basak A K, Ridgway N. Elastomers’ wear: Comparison of theory with experiment. Tribol Int 135: 46–54 (2019)   
[225] Molinari J F, Aghababaei R, Brink T, Frérot L, Milanese E. Adhesive wear mechanisms uncovered by atomistic simulations. Friction 6(3): 245–259 (2018)   
[226] Popov V L, Pohrt R. Adhesive wear and particle emission: Numerical approach based on asperity-free formulation of Rabinowicz criterion. Friction 6(3): 260–273 (2018)   
[227] Zhang Y Z, Kovalev A, Meng Y G. Combined effect of boundary layer formation and surface smoothing on friction and wear rate of lubricated point contacts during normal running-in processes. Friction 6(3): 274–288 (2018)   
[228] Wang Z, Wang T T, Yang G Y, Gao $\mathrm { ~ X ~ L ~ }$ , Dai K. Estimating antiwear properties of esters as potential lubricant-based oils using QSTR models with CoMFA and CoMSIA. Friction 6(3): 289–298 (2018)   
[229] Xue Y H, Chen J G, Guo S M, Meng Q L, Luo J T. Finite element simulation and experimental test of the wear behavior for self-lubricating spherical plain bearings. Friction 6(3): 297–306 (2018)   
[230] Yang Y J, Shi Y F. Single asperity friction in the wear regime. Friction 6(3): 316–322 (2018)   
[231] Popova E, Popov V L, Kim D E. 60 years of Rabinowicz’ criterion for adhesive wear. Friction 6(3): 341–348 (2018)   
[232] Arnaud P, Fouvry S. A dynamical FEA fretting wear modeling taking into account the evolution of debris layer. Wear 412–413: 92–108 (2018)   
[233] Lijesh K P, Khonsari M M. On the modeling of adhesive wear with consideration of loading sequence.Tribol Lett 66(3): 105(2018)   
[234] Zhang Y Z, Kovalev A, Hayashi N, Nishiura K, Meng Y G. Numerical prediction of surface wear and roughness parameters during running-in for line contacts under mixed lubrication. J Tribol 140(6): 061501(2018)   
[235] Xiang G, Han Y F, Wang J X, Wang J F, Ni X K. Coupling transient mixed lubrication and wear for journal bearing modeling. Tribol Int 138: 1–15 (2019)   
[236] Avila K E, Küchemann S, Alhafez I A, Urbassek H M. Nanoscratching of metallic glasses–An atomistic study. Tribol Int 139: 1–11 (2019)   
[237] Suslov A G, Shalygin M G. A wear model for subrough surface contacts of martensitic steels. Proc Inst Mech Eng, Part J: J Eng Tribol 233(10): 1574–1584 (2019)   
[238] Rojas E, Vergara V, Soto R. Case study: Discrete element modeling of wear in mining hoppers. Wear 430–431: 120– 125 (2019)   
[239] Gong W J, Chen Y X, Li M W, Kang R. Adhesion-fatigue dual mode wear model for fractal surfaces in AISI 1045 cylinder-plane contact pairs. Wear 430–431: 327–339 (2019)   
[240] Jia H, Li J Y, Wang J X, Xiang G, Xiao K, Han Y F. Micropitting fatigue wear simulation in conformal-contact under mixed elastohydrodynamic lubrication. J Tribol 141(6): 061501 (2019)   
[241] Chen Z, Etsion I. The elastic-plastic contact behavior of rough surfaces with hard coatings. Tribol Int 134: 435–442 (2019)   
[242] Fallahnezhad K, Liu S, Brinji O, Marker M, Meehan P A. Monitoring and modelling of false brinelling for railway bearings. Wear 424–425: 151–164 (2019)   
[243] Li G, Wang Z H, Zhu W D. Prediction of surface wear of involute gears based on a modified fractal method. J Tribol 141(3): 031603 (2019)   
[244] Cao W, Dong G N, Xie Y B, Peng Z X. Prediction of wear trend of engines via on-line wear debris monitoring. Tribol Int 120: 510–519 (2018)   
[245] Kattelus J, Miettinen J, Lehtovaara A. Detection of gear pitting failure progression with on-line particle monitoring. Tribol Int 118: 458–464 (2018)   
[246] Kumar P, Hirani H, Agrawal A K. Online condition monitoring of misaligned meshing gears using wear debris and oil quality sensors. Ind Lubr Tribol 70(4): 645–655 (2018)   
[247] Li Y N, Zhang P L. An online de-noising method for oil ultrasonic wear debris signal: Fuzzy morphology component analysis. Ind Lubr Tribol 70(6): 1012–1019 (2018)   
[248] Towsyfyan H, Gu F S, Ball A D, Liang B. Modelling acoustic emissions generated by tribological behaviour of mechanical seals for condition monitoring and fault detection. Tribol Int 125: 46–58 (2018)   
[249] Hu S T, Huang W F, Shi X, Peng Z K, Liu X F, Wang Y M. Bi-Gaussian stratified effect of rough surfaces on acoustic emission under a dry sliding friction. Tribol Int 119: 308–315 (2018)   
[250] Tian Y, He C G, Zhang J, Liu Q Y, Wang W J. Experimental study on the vibration characteristic responses on the surface damage of wheel materials. Proc Inst Mech Eng, Part J: J Eng Tribol 232(9): 1160–1168 (2018)   
[251] Ahmadi A, Sadeghi F, Shaffer S. In-situ friction and fretting wear measurements of Inconel 617 at elevated temperatures. Wear 410–411: 110–118 (2018)   
[252] Chang H C, Borghesani P, Smith W A, Peng Z X. Application of surface replication combined with image analysis to investigate wear evolution on gear teeth - A case study. Wear 430–431: 355–368 (2019)   
[253] Kumar A, Ghosh S K. Size distribution analysis of wear particles in the transmission system of mining equipment. Proc Inst Mech Eng, Part J: J Eng Tribol 232(8): 921–926 (2018)   
[254] Xu B, Wen G R, Zhang Z F, Chen F. Wear particle classification using genetic programming evolved features. Lubr Sci 30(5): 229–246 (2018)   
[255] Wu Y. Detection of foreign particles in lubrication oil with a microfluidic chip. Ind Lubr Tribol 70(8): 1381–1387 (2018)   
[256] Peng P, Wang J G. FECNN: A promising model for wear particle recognition. Wear 432–433: 202968 (2019)   
[257] Peng Y P, Cai J H, Wu T H, Cao G Z, Kwok N, Zhou S X, Peng Z X. Online wear characterisation of rolling element bearing using wear particle morphological features. Wear 430–431: 369–375 (2019)   
[258] Vališ D, Gajewski J, Žák L. Potential for using the ANNFIS meta-model approach to assess levels of particulate contamination in oil used in mechanical systems. Tribol Int 135: 324–334 (2019)   
[259] Habibolahzadeh A, Haftlang F. Duplex surface treatment of AISI 1045 steel via pack boriding and plasma nitriding: Characterization and tribological studies. J Tribol 140(2): 021602 (2018)   
[260] Von Fieandt L, Fallqvist M, Larsson T, Lindahl E, Ti(C,N) deposited by chemical vapor deposition. Tribol Int 119: 593–599 (2018)   
[261] Deshpande P, Minfray C, Dassenoy F, Thiebaut B, Le Mogne T, Vacher B, Jarnias F. Tribological behaviour of $\mathrm { T i O } _ { 2 }$ atmospheric plasma spray (APS) coating under mixed and boundary lubrication conditions in presence of oil containing MoDTC. Tribol Int 118: 273–286 (2018)   
[262] Antonov M, Afshari H, Baronins J, Adoberg E, Raadik T, Hussainova I. The effect of temperature and sliding speed on friction and wear of $\mathrm { S i } _ { 3 } \mathrm { N } _ { 4 }$ , $\mathrm { { A l } } _ { 2 } \mathrm { { O } } _ { 3 }$ , and $Z \mathrm { r } \mathrm { O } _ { 2 }$ balls tested against AlCrN PVD coating. Tribol Int 118: 500–514 (2018)   
[263] Dos S, De Almeida E A, Milan J C G, Costa H L, Krelling A P, Da Costa C E. Sliding wear of borided sintered AISI M2 steel coated with AlTiN/CrN multilayer. Wear 410–411: 11–24 (2018)   
[264] Gassner M, Schalk N, Tkadletz M,Pohler M, Czettl C, Mitterer C. Influence of cutting speed and workpiece material on the wear mechanisms of CVD T $\mathrm { \ddot { \mathrm { i C N } } } / \mathrm { a } { - } \mathrm { A l } _ { 2 } \mathrm { O } _ { 3 }$ coated cutting inserts during turning. Wear 398–399: 90–98 (2018)   
[265] Boing D, De Oliveira A J, Schroeter R B. Limiting conditions for application of PVD (TiAlN) and CVD $\mathrm { ( T i C N / A l _ { 2 } O _ { 3 } / T i N ) }$ ) coated cemented carbide grades in the turning of hardened steels. Wear 416–417: 54–61 (2018)   
[266] Vereschaka A, Aksenenko A, Sitnikov N, Migranov M, Shevchenko S, Sotova C, Batako A, Andreev N. Effect of adhesion and tribological properties of modified composite nano-structured multi-layer nitride coatings on WC–Co tools life. Tribol Int 128: 313–327 (2018) [267] Chen S Y, Ma G Z, Wang H D, He P F, Liu M, Wang H J, Xu B S. Comparison of solidity and fractal dimension of plasma sprayed splat with different spreading morphologies. Appl Surf Sci 409: 277–284(2017)   
[268] Chen S Y, Ma G Z, Wang H D, He P F, Wang H M, Liu M. Evaluation of adhesion strength between amorphous splat and substrate by micro scratch method. Surface & Coatings Technology 344: 43–51(2018)   
[269] Chen S Y, Ma G Z, Wang H D, He P F, Liu Z. Solidification mechanism and quantitative characterization of Fe-based amorphous splat formed by plasma sprayed droplets with different in-flight status. Journal of Alloys and Compounds 768: 789–799(2018)   
[270] Gu C X, Meng X H, Zhang D, Analysis of the coated and textured ring/liner conjunction based on a thermal mixed lubrication model. Friction 6(4): 420–431(2018)   
[271] Bolelli G, Bursi M, Lusvarghi L,Manfredini T, Matikainen V, Rigon R, Sassatelli P, Vuoristo P. Tribology of FeVCrC coatings deposited by HVOF and HVAF thermal spray processes. Wear 394–395: 113–133 (2018)   
[272] Gheisari R, Polycarpou A A. Tribology of selected hard coatings for oil and gas applications up to $4 5 0 ~ ^ { \circ } \mathrm { C }$ . Tribol Lett 67(2): 51 (2019)   
[273] Mukhopadhyay A, Barman T K, Sahoo P. Effect of operating temperature on tribological behavior of as-plated Ni–B coating deposited by electroless method. Tribol Trans 61(1): 41–52 (2018)   
[274] Ríos J M, Quintero D, Castaño J G, Echeverría F, Gómez M A. Comparison among the lubricated and unlubricated tribological behavior of coatings obtained by PEO on the Ti6Al4V alloy in alkaline solutions. Tribol Int 128: 1–8 (2018)   
[275] Laurindo C A H, Lepienski C M, Amorim F L, Torres R D, Soares P. Mechanical and tribological properties of $\mathrm { C a } / \mathrm { P }$ -doped titanium dioxide layer produced by plasma electrolytic oxidation: Effects of applied voltage and heat treatment. Tribol Trans 61(4): 733–741 (2018)   
[276] Ma C S, Cheng D, Zhu X H, Yan Z J, Fu J G, Yu J, Liu Z Z, Yu G Y, Zheng S B. Investigation of a self-lubricating coating for diesel engine pistons, as produced by combined microarc oxidation and electrophoresis. Wear 394–395: 109–112 (2018)   
[277] Lan P X, Polycarpou A A. High temperature and high pressure tribological experiments of advanced polymeric coatings in the presence of drilling mud for oil & gas applications. Tribol Int 120: 218–225 (2018)   
[278] Lan P X, Gheisari R, Meyer J L, Polycarpou A A. Tribological performance of aromatic thermosetting polyester (ATSP) coatings under cryogenic conditions. Wear 398–399: 47–55 (2018)   
[279] Hill D, Holliman P J, McGettrick J,Appelman M, Chatterjee P, Watson T M, Worsley D. Study of the tribological properties and ageing of alkyphosphonic acid films on galvanized steel. Tribol Int 119: 337–344 (2018)   
[280] Sieh R, Le H R. Evaluation of environmental friendly Ag–PTFE composite coating for use in threaded compression fittings. Proc Inst Mech Eng, Part J: J Eng Tribol 232(5): 503–512 (2018)   
[281] Barbakadze K, Brostow W, Datashvili T, Hnatchuk N, Lekishvili N. Antibiocorrosive epoxy-based coatings with low friction and high scratch resistance. Wear 394–395: 228–235 (2018)   
[282] Qin H F, Ren Z C, Zhao J Y, Ye C, Doll G L, Dong Y L. Effects of ultrasonic nanocrystal surface modification on the wear and micropitting behavior of bearing steel in boundary lubricated steel-steel contacts. Wear 392–393: 29–38 (2018)   
[283] Amanov A, Pyun Y S. Lowering friction of ball screws made of different steel grades through ultrasonic impact treatment. Tribol Int 123: 105–119 (2018)   
[284] Amanov A, Urmanov B, Kim K C,Pyun Y S. Improvement in microscratch resistance of graphite by surface modification for molding applications. J Tribol 140(1): 011602 (2018)   
[285] Yuan Z W, Qin Y, Deng C L, Zhang P. Synergistic effects of surface strengthening and surface micro-texture on aviation spherical plain bearing tribological properties. Proc Inst Mech Eng, Part J: J Eng Tribol 232(7): 797–808 (2018)   
[286] Korzynski M, Dudek K, Kruczek B, Kocurek P. Equilibrium surface texture of valve stems and burnishing method to obtain it. Tribol Int 124: 195–199 (2018)   
[287] Li Q D, Lu H, Li D Y. Effect of recovery treatment on the wear resistance of surface hammered $\mathbf { A } Z 3 1 \ \mathrm { M g }$ alloy. Wear 426–427: 981–988 (2019)   
[288] Khafidh M, Schipper D J, Masen M A.The formation of a modified surface layer on elastomeric materials. Tribol Lett 67(1): 27 (2019)   
[289] Fang S Q, Llanes L, Bähre D. Laser surface texturing of a WC–CoNi cemented carbide grade: Surface topography design for honing application. Tribol Int 122: 236–245 (2018)   
[290] Yazici O, Yilmaz S. Investigation of effect of various processing temperatures on abrasive wear behaviour of high power diode laser treated R260 grade rail steels. Tribol Int 119: 222–229 (2018)   
[291] Lin Y, Cai Z B, Li Z Y, Yin M G, Wang W J, He W F, Zhou Z R. Study on the abrasive wear behavior of laser shock peening Ti–6Al–4V titanium alloy under controlled cycling impact. Wear 426–427: 112–121 (2019)   
[292] Hu D, Guo Z W, Xie X,Yuan C Q. Effect of sphericalconvex surface texture on tribological performance of water-lubricated bearing. Tribol Int 134: 341–351 (2019)   
[293] Li C D, Li B, ShenY, Jin M, Xu J J. Effect of surface chemical etching on the lubricated reciprocating wear of honed Al–Si alloy. Proc Inst Mech Eng, Part J: J Eng Tribol 232(6): 722–731 (2018)   
[294] Varshney P, Mohapatra S S. Durable and regenerablesuperhydrophobic coatings for brass surfaces with excellent self-cleaning and anti-fogging properties prepared by immersion technique. Tribol Int 123: 17–25 (2018)   
[295] Varshney P, Lomga J, Gupta P K, Mohapatra S S, Kumar A. Durable and regenerablesuperhydrophobic coatings for aluminium surfaces with excellent self-cleaning and antifogging properties. Tribol Int 119: 38–44 (2018)   
[296] Li J L, Zhao C Y, Shen J H, Wang H, Pei G M, Xu S A. A facile surface treatment to improve the abrasion resistance of photosensitive film for screen printing. Tribol Trans 62(1): 127–134 (2019)   
[297] Xi X, Xia Y Q, Hu Y C. The effects of magnetic treatment on the tribological behavior of AISI 1045 steel under lubricated conditions. Tribol Trans 61(4): 671–682 (2018)   
[298] Aramesh M, Montazeri S, Veldhuis S C. A novel treatment for cutting tools for reducing the chipping and improving tool life during machining of Inconel 718. Wear 414–415: 79–88 (2018)   
[299] Allu V P, Raju D L, Ramakrishna S. Performance analysis of cryogenically treated plus tempered carbide inserts in turning of Inconel 718 using cryogenic minimum quantity lubrication cooling technique. Proc Inst Mech Eng, Part J: J Eng Tribol 233(12): 1810–1819 (2019)   
[300] Halim N H A, Haron C H C, Ghani J A, Azhar M F. Tool wear and chip morphology in high-speed milling of hardened Inconel 718 under dry and cryogenic $\mathrm { C O } _ { 2 }$ conditions. Wear 426–427: 1683–1690 (2019)   
[301] Dowson D. Whither tribology? Wear 16(4): 303–304 (1970)   
[302] Qin L G, Feng X N, Hafezi M, Zhang Y L, Guo J D, Dong G N, Qin Y B. Investigating the tribological and biological performance of covalently grafted chitosan coatings on Co–Cr–Mo alloy. Tribol Int 127: 302–312 (2018)   
[303] Sümer B. Influence of preload control on friction force measurement of fabric samples. Tribol Int 127: 446–456 (2018)   
[304] Özin M C, Sümer B, Koç İ M. Friction force evaluation for grasping in minimally invasive surgery. Tribol Int 131: 167–173 (2019)   
[305] Nakanishi Y, Nakashima Y, Fujiwara Y, Komohara Y, Takeya M, Miura H, Higaki H. Influence of surface profile of $\mathrm { C o - 2 8 C r { - } 6 M o }$ alloy on wear behaviour of ultra-high molecular weight polyethylene used in artificial joint. Tribol Int 118: 538–546 (2018)   
[306] Schwörer F, Trapp M, Xu X, Soltwedel O, Dzubiella J, Steitz R, Dahint R. Drastic swelling of lipid oligobilayers by polyelectrolytes: A potential molecular model for the internal structure of lubricating films in mammalian joints. Langmuir 34(4): 1287–1299 (2018)   
[307] Milner P E, Parkes M, Puetzer J L, Chapman R, Stevens M M, Cann P, Jeffers J R T. A low friction, biphasic and boundary lubricating hydrogel for cartilage replacement. Acta Biomater 65: 102–111 (2018)   
[308] Faivre J, Sudre G, Montembault A, Benayoun S, Banquy X, Delair T, David L. Bioinspired microstructures of chitosan hydrogel provide enhanced wear protection. Soft Matter 14(11): 2068–2076 (2018)   
[309] Zhang X W, Wang J, Jin H, Wang S T, Song W L. Bioinspired supramolecular lubricating hydrogel induced by shear force. J Am Chem Soc 140(9): 3186–3189 (2018)   
[310] Arjmandi M, Ramezani M, Bolle T, Köppe G, Gries T, Neitzert T. Mechanical and tribological properties of a novel hydrogel composite reinforced by three-dimensional woven textiles as a functional synthetic cartilage. Comp Part A: Appl Sci Manuf 115: 123–133 (2018)   
[311] Delavoipière J, Tran Y, Verneuil E, Heurtefeu B, Hui CY, Chateauminois A. Friction of poroelastic contacts with thin hydrogel films. Langmuir 34(33): 9617–9126 (2018)   
[312] Arjmandi M, Ramezani M, Nand A, Neitzert T. Experimental study on friction and wear properties of interpenetrating polymer network alginate-polyacrylamide hydrogels for use in minimally-invasive joint implants. Wear 406–407: 194–204 (2018)   
[313] Means A K, Shrode C S, Whitney L V, Ehrhardt D A, Grunlan M A. Double network hydrogels that mimic the modulus, strength, and lubricity of cartilage. Biomacromolecules 20(5): 2034–2042 (2019)   
[314] Wathier M, Lakin B A, Cooper B G, Bansal P N, Bendele A M, Entezari V, Suzuki H, Snyder B D, Grinstaff M W. A synthetic polymeric biolubricant imparts chondroprotection in a rat meniscal tear model. Biomaterials 182: 13–20 (2018)   
[315] Cooper B G, Catalina B, Nazarian A, Snyder B D, Grinstaff M W. Active agents, biomaterials, and technologies to improve biolubrication and strengthen soft tissues. Biomaterials 181: 210–26 (2018)   
[316] Fan Z J, Li J, Liu J L, Jiao H J, Liu B. Anti-inflammation and joint lubrication dual effects of a novel hyaluronic acid/curcumin nanomicelle improve the efficacy of rheumatoid arthritis therapy. ACS Appl Mater Interfaces 10(28): 23595–23604 (2018)   
[317] Rahaman M, Xiao W. Silicon nitride bioceramics in healthcare. Int J Appl Ceram Technol 15(4): 861–872 (2018)   
[318] Kyomoto M, Shoyama Y, Saiga K, Moro T, Ishihara K. Reducing fretting-initiated crevice corrosion in hip simulator tests using a zirconia-toughened alumina femoral head. $J$ Biomed Mater Res Part B: Appl Biomater 106(8): 2815– 2826 (2018)   
[319] Reichert A, Seidenstuecker M, Gadow R, Mayr H O, Suedkamp N P, Latorre S H, Weichand P, Bernstein A. Carbon-fibre-reinforced SiC composite (C/SiSiC) as an alternative material for endoprosthesis: Fabrication, mechanical and in-vitro biological properties. Materials 11(2): 316(2018)   
[320] Ghalme S, Mankar A, Bhalerao Y, Patil M. Integrated Taguchi-artificial neural network approach for modeling and optimization of wear performance of $\mathrm { S i } _ { 3 } \mathrm { N } _ { 4 }$ -hBN composite. AIP Conf Proc 2018(1): 020003 (2018)   
[321] Bian Y Y, Zhou L, Zhou G, Jin Z M, Xin S X, Hua Z K, Weng X S. Study on biocompatibility, tribological property and wear debris characterization of ultra-low-wear polyethylene as artificial joint materials. J Mech Behav Biomed Mater 82: 87–94 (2018) [322] Regis M, Lanzutti A, Bracco P, Fedrizzi L. Wear behavior of medical grade PEEK and CFR PEEK under dry and bovine serum conditions. Wear 408–409: 86–95 (2018) [323] Zhao X D, Xiong D S, Liu Y T. Improving surface wettability and lubrication of polyetheretherketone (PEEK) by combining with polyvinyl alcohol (PVA) hydrogel. $J$ Mech Behav Biomed Mater 82: 27–34 (2018) [324] Araujo Borges R, Choudhury D, Zou M. 3D printed PCU/UHMWPE polymeric blend for artificial knee meniscus. Tribol Int 122: 1–7 (2018) [325] Kanca Y, Milner P, Dini D, Amis A A. Tribological evaluation of biomedical polycarbonate urethanes against articular cartilage. J Mech Behav Biomed Mater 82: 394–402 (2018) [326] Kanca Y, Milner P, Dini D, Amis A A. Tribological properties of PVA/PVP blend hydrogels against articular cartilage. J Mech Behav Biomed Mater 78: 36–45 (2018) [327] Yunus M, Alsoufi M S. Experimental investigations into the mechanical, tribological, and corrosion properties of hybrid polymer matrix composites comprising ceramic reinforcement for biomedical applications. Int J Biomater   
2018: 9283291 (2018) [328] Buciumeanu M, Almeida S, Bartolomeu F, Costa M M, Alves N, Silva F S, Miranda G. Ti6Al4V cellular structures impregnated with biomedical PEEK–New material design for improved tribological behavior. Tribol Int 119: 157–164 (2018) [329] Smirnov A, Volosova M, Peretyagin P, Bartolomé J F. Tribological behaviour of a 3Y-TZP/Ta ceramic-metal biocomposite against ultrahigh molecular weight polyethylene (UHMWPE). Ceram Int 44(2): 1404–1410 (2018) [330] Riaz M Q, Caputo M, Ferraro M M, Ryu J J. Influence of process-induced anisotropy and synovial environment on wear of EBM built Ti6Al4V joint implants. J Mater Eng Perform 27(7): 3460–3471 (2018) [331] Kyomoto M, Moro T, Yamane S, Watanabe K, Hashimoto M, Tanaka S, Ishihara K. A phospholipid polymer graft layer affords high resistance for wear and oxidation under load bearing conditions. J Mech Behav Biomed Mater 79:   
203–212 (2018) [332] Chan C W, Smith G, Lee S. A preliminary study to enhance the tribological performance of CoCrMo alloy by fibre laser remelting for articular joint implant applications. Lubricants 6(1): 24 (2018) [333] Luo W, Kuai J C. Friction and wear properties of artificial joints of CoCrMo alloy. IOP Conf Ser: Mater Sci Eng   
439(4): 042072 (2018) [334] Choudhury D, Rebenda D, Sasaki S, Hekrle P, Vrbka M, Zou M. Enhanced lubricant film formation through micro-dimpled hard-on-hard artificial hip joint: An in-situ observation of dimple shape effects. J Mech Behav Biomed Mater 81: 120–129 (2018) [335] Lee H H, Lee S, Park J K, Yang M Y. Friction and wear characteristics of surface-modified titanium alloy for metal-on-metal hip joint bearing. Int J Precis Eng Manuf   
19(6): 917–924 (2018) [336] Langhorn J, Borjali A, Hippensteel E, Nelson W, Raeymaekers B. Microtextured CoCrMo alloy for use in metal-on-polyethylene prosthetic joint bearings: Multidirectional wear and corrosion measurements. Tribol Int   
124: 178–183 (2018) [337] Yamane S, Kyomoto M, Moro T, Hashimoto M, Takatori Y, Tanaka S, Ishihara K. Wear resistance of poly(2- methacryloyloxyethyl phosphorylcholine)-grafted carbon fiber reinforced poly(ether ether ketone) liners against metal and ceramic femoral heads. J Biomed Mater Res Part B: Appl Biomater 106(3): 1028–1037 (2018) [338] Ghosh S, Abanteriba S, Wong S, Houshyar S. Selective laser melted titanium alloys for hip implant applications: Surface modification with new method of polymer grafting. J Mech Behav Biomed Mater 87: 312–324 (2018) [339] Fabry C, Zietz C, Baumann A, Ehall R, Bader R. High wear resistance of femoral components coated with titanium nitride: A retrieval analysis. Knee Surg, Sports Traumatol, Arthrosc 26(9): 2630–2639 (2018) [340] Puente Reyna A L, Fritz B, Schwiesau J, Schilling C, Summer B, Thomas P, Grupp T M. Metal ion release barrier function and biotribological evaluation of a zirconium nitride multilayer coated knee implant under highly demanding activities wear simulation. J Biomech 79: 88–96 (2018) [341] Du S X, Zhang K, Wen M, Qin Y G, Li R Y, Jin H, Bao X F, Ren P, Zheng W T. Optimizing the tribological behavior of tantalum carbide coating for the bearing in total hip joint replacement. Vacuum 150: 222–231 (2018) [342] Rajeshshyam R, Chockalingam K, Gayathri V, Prakash T. Reduction of metallosis in hip implant using thin film coating. AIP Conf Proc 1943(1): 020090 (2018) [343] Zhang Y J, Qin Y G, Qing Y A, Deng R P, Jin H, Li R Y, Rehman J, Zhang K. TiCuN solid solution coating: Excellent wear-resistant biocompatible material to protect artificial joint. Mater Lett 227: 145–148 (2018) [344] Kayandan S, Doshi B N, Oral E, Muratoglu O K. Surface cross-linked ultra high molecular weight polyethylene by emulsified diffusion of dicumyl peroxide. J Biomed Mater Res Part B: Appl Biomater 106(4): 1517–1523 (2018) [345] Peretti V, Ferraris S, Gautier G, Hellmich C, Lahayne O, Stella B, Yamaguchi S, Spriano S. Surface treatments for boriding of Ti6Al4V alloy in view of applications as a biomaterial. Tribol Int 126: 21–28 (2018)   
[346] Wang $\textsf { Y X }$ , Sun Y L, Gu Y H, Zhang H Y. Articular cartilage-inspired surface functionalization for enhanced lubrication. Adv Mater Interfaces 6(12): 1900180 (2019)   
[347] Clarke I C, Halim T, Smith E J, Donaldson T K. Acetabular cups in $6 0 \ \mathrm { m m }$ metal-on-metal bearings subjected to dynamic edge-loading with $7 0 ^ { \circ }$ peak-inclination in 10-million cycle simulator study. Lubricants 6(1): 1 (2018)   
[348] O'Dwyer Lancaster-Jones O, Williams S, Jennings L M, Thompson J, Isaac G H, Fisher J, Al-HajjarM. An in vitro simulation model to assess the severity of edge loading and wear, due to variations in component positioning in hip joint replacements. $J$ Biomed Mater Res Part B: Appl Biomater 106(5): 1897–1906 (2018)   
[349] Johnston H, Abdelgaied A, Pandit H, Fisher J, Jennings L M. The effect of surgical alignment and soft tissue conditions on the kinematics and wear of a fixed bearing total knee replacement. J Mech Behav Biomed Mater 100: 103386 (2019)   
[350] Wang L, Isaac G, Wilcox R, Jones A, Thompson J. Finite element analysis of polyethylene wear in total hip replacement: A literature review. Proc Inst Mech Eng, Part H: J Eng Med 233(11): 1067–1088(2019)   
[351] Kang K T, Son J, Kwon S K, Kwon O R, Park J H, Koh Y G. Finite element analysis for the biomechanical effect of tibial insert materials in total knee arthroplasty. Compos Struct 201: 141–150 (2018)   
[352] Horsager K, Kaptein B L, Jørgensen P B, Jepsen C F, Stilling M. Oxford medial unicompartmental knees display contact-loss during step-cycle motion and bicycle motion: A dynamic radiostereometric study. J Orthop Res 36(1): 357–364 (2018)   
[353] Affatato S. Towards wear testing of high demanding daily activities on total hip replacement: Preliminary results. J Braz Soc Mech Sci Eng 40(5): 260(2018)   
[354] Nečas D, Vrbka M, Rebenda D, Gallo J, Galandáková A, Wolfová L, Křupka I, Hartl M. In situ observation of lubricant film formation in THR considering real conformity: The effect of model synovial fluid composition. Tribol Int 117: 206–216 (2018)   
[355] Abdelgaied A, Fisher J, Jennings L M. A comprehensive combined experimental and computational framework for pre-clinical wear simulation of total knee replacements. J Mech Behav Biomed Mater 78: 282–291 (2018)   
[356] Bowland P, Ingham E, Fisher J, Jennings L M. Development of a preclinical natural porcine knee simulation model for the tribological assessment of osteochondral grafts in vitro. J Biomech 77: 91–98 (2018)   
[357] Olorunlambe K A, Shepherd D E T, Dearn K D. A review of acoustic emission as a biotribological diagnostic tool. Tribol - Mater, Surf Interfaces 13(3): 161–171 (2019)   
[358] Ovesy M, Voumard B, Zysset P. A nonlinear homogenized finite element analysis of the primary stability of the boneimplant interface. Biomech Model Mechanobiol 17(5): 1471–1480 (2018)   
[359] Jahnke A, Schroeder S, Fonseca Ulloa C A, Ahmed G A, Ishaque B A, Rickert M. Effect of bearing friction torques on the primary stability of press-fit acetabular cups: A novel in vitro method. J Orthop Res 36(10): 2745–2753 (2018)   
[360] Bhalekar R M, Smith S L, Joyce T J. Hip simulator testing of the taper-trunnion junction and bearing surfaces of contemporary metal-on-cross-linked-polyethylene hip prostheses. J Biomed Mater Res Part B: Appl Biomater (2019) doi:10.1002/jbm.b.34374 (in Press)   
[361] Rondinella A, Marin E, Boschetto F, Zanocco M, Zhu W, Affatato S, Yamamoto K, Tateiwa T, Pezzotti G. Degradation phenomena occurring in the conical taper of a short-term retrieved ZTA femoral head: A case study. Mater Des 157: 362–370 (2018)   
[362] Royhman D, Patel M, Jacobs J J, Wimmer M A, Hallab N J, Mathew M T. In vitro simulation of fretting-corrosion in hip implant modular junctions: The influence of pH. Med Eng Phys 52: 1–9 (2018)   
[363] Hall D J, Pourzal R, Lundberg H J, Mathew M T, Jacobs J J, Urban R M. Mechanical, chemical and biological damage modes within head-neck tapers of CoCrMo and Ti6Al4V contemporary hip replacements. J Biomed Mater Res Part B: Appl Biomater 106(5): 1672–1685 (2018)   
[364] Kang Y K, Kim M H, Kim J W, Tien T N, Lim D H, Chun H J. Analysis on wear phenomenon of artificial knee joint based on FEM and mechanical test. Int J Precis Eng Manuf 19(8): 1211–1217 (2018)   
[365] Le Cann S, Chaves-Jacob J, Rossi J M, Linares J M, Chabrand P. Tribology of flexible and sliding spinal implants: Development of experimental and numerical models. J Biomed Mater Res Part B: Appl Biomater 106(1): 104–111 (2018)   
[366] Singh V, Shorez J P, Mali S A, Hallab N J, Gilbert J L. Material dependent fretting corrosion in spinal fusion devices: Evaluation of onset and long-term response. J Biomed Mater Res Part B: Appl Biomater 106(8): 2858–2868 (2018)   
[367] Xu H D, Zhang D K, Chen K, Zhang T. Fretting wear of PEEK against XLPE. Mater Res Express 5(6): 065402 (2018)   
[368] Esguerra-Arce J, Castañeda A B, Esguerra-Arce A, Aguilar Y, Mischler S. Fretting corrosion between bone and calcium phosphate-calcium titanate coatings. Wear 414–415: 366– 375 (2018)   
[369] Weng Y C, Liu H X, Ji S P, Huang Q, Wu H, Li Z B, Wu Z Z, Wang H Y, Tong L P, Fu R K Y, et al. A promising orthopedic implant material with enhanced osteogenic and antibacterial activity: $\mathrm { { A l } } _ { 2 } \mathrm { { O } } _ { 3 }$ -coated aluminum alloy. Appl Surf Sci 457: 1025–1034 (2018)   
[370] Willing R. Comparing damage on retrieved total elbow replacement bushings with lab worn specimens subjected to varied loading conditions. J Orthop Res 36(7): 1998–2006 (2018)   
[371] Moungondo F G P, Andrzejewski A, Van Riet R R P, Feipel V, Rooze M, Schuind F A. Joint contact areas after radial head arthroplasty: A comparative study of 3 prostheses. J Shoulder Elbow Surg 28(8): 1546–1553 (2019)   
[372] Navacchia A, Clary C W, Han X Z, Shelburne K B, Wright A P, Rullkoetter P J. Loading and kinematic profiles for patellofemoral durability testing. J Mech Behav Biomed Mater 86: 305–313 (2018)   
[373] Inyang A O, Abdalrahman T, Bezuidenhout D, Bowen J, Vaughan C L. Suitability of developed composite materials for meniscal replacement: Mechanical, friction and wear evaluation. J Mech Behav Biomed Mater 89: 217–226 (2019)   
[374] Kurdziel M D, Newton M D, Hartner S, Baker K C, Wiater J M. Quantitative evaluation of retrieved reverse total shoulder arthroplasty liner surface deviation and volumetric wear. J Orthop Res 36(7): 2007–2014 (2018)   
[375] Horazdovsky T, Vrbova R. Tribomechanical properties of a carbon-based nanolayer prepared by nitrogen ion beam assisted deposition for finger joint replacements. J Nanomater 2018: 3749309 (2018)   
[376] Gonzalez-Perez-Somarriba B, Centeno G, Vallellano C, Gonzalez-Perez L M. On the analysis of the contact conditions in temporomandibular joint prostheses. Adv Mater Sci Eng 2018: 2687864 (2018)   
[377] Mondal S, Ghosh R. Effects of implant orientation and implant material on tibia bone strain, implant-bone micromotion, contact pressure, and wear depth due to total ankle replacement. Proc Inst Mech Eng, Part H: J Eng Med 233(3): 318–331 (2019)   
[378] Warburton K J, Everingham J B, Helms J L, Kazanovicz A J, Hollar K A, Brourman J D, Fox S M, Lujan T J. Wear testing of a canine hip resurfacing implant that uses highly cross-linked polyethylene. J Orthop Res 36(4): 1196–1205 (2018)   
[379] Kovochich M, Fung E S, Donovan E, Unice K M, Paustenbach D J, Finley B L. Characterization of wear debris from metal-on-metal hip implants during normal wear versus edge-loading conditions. J Biomed Mater ResPart B: Appl Biomater 106(3): 986–996 (2018)   
[380] Lehtovirta L, Reito A, Parkkinen J, Peräniemi S, Vepsäläinen J, Eskelinen A. Association between periprosthetic tissue metal content, whole blood and synovial fluid metal ion levels and histopathological findings in patients with failed metal-on-metal hip replacement. PLoS One 13(5): e0197614 (2018)   
[381] Bonnevie E D, Delco M L, Bartell L R, Jasty N, Cohen I, Fortier L A, Bonassar L J. Microscale frictional strains determine chondrocyte fate in loaded cartilage. J Biomech 74: 72–78 (2018)   
[382] Hui T T, Kubacki G W, Gilbert J L. Voltage and wear debris from Ti–6Al–4V interact to affect cell viability during in-vitro fretting corrosion. J Biomed Mater Res Part A 106(1): 160–167 (2018)   
[383] De Vries S A H, Van Doeselaar M, Kaper H J, Sharma P K, Ito K. Notochordal cell matrix as a bioactive lubricant for the osteoarthritic joint. Sci Rep 8(1): 8875 (2018)   
[384] Uno K T, Rivals F, Bibi F, Pante M, Njau J, De La Torre I. Large mammal diets and paleoecology across the OldowanAcheulean transition at Olduvai Gorge, Tanzania from stable isotope and tooth wear analyses. J Hum Evol 120: 76–91 (2018)   
[385] Rivals F, Uno K T, Bibi F, Pante M C, Njau J, De La Torre I. Dietary traits of the ungulates from the HWK EE site at Olduvai Gorge (Tanzania): Diachronic changes and seasonality. J Hum Evol 120: 203–214 (2018)   
[386] Sarkar A, Andablo-Reyes E, Bryant M, Dowson D, Neville A. Lubrication of soft oral surfaces. Curr Opin Colloid Interface Sci 39: 61–75 (2019)   
[387] Santos F, Branco A, Polido M, Serro A P, Figueiredo-Pina C G. Comparative study of the wear of the pair human teeth/Vita Enamic®vs commonly used dental ceramics through chewing simulation. J Mech Behav Biomed Mater 88: 251–260 (2018)   
[388] Gou M, Chen H L, Kang J, Wang H. Antagonist enamel wear of tooth-supported monolithic zirconia posterior crowns in vivo: A systematic review. J Prosthet Dent 121(4): 598–603 (2019)   
[389] Hayashi S, Homma S, Takanashi T, Hirano T, Yoshinari M, Yajima Y. Wear properties of esthetic dental materials against translucent zirconia. Dent Mater J 38(2): 250–256 (2019)   
[390] Shi A D, Wu Z, Huang J Y, Liang Q, Li Q Q, Guo L H, Shen Z J. Wear performance of self-glazed zirconia crowns with different amount of occlusal adjustment after 6 months of clinical use. Adv Appl Ceram 117(8): 445–451 (2018)   
[391] Kruzic J J, Arsecularatne J A, Tanaka C B, Hoffman M J, Cesar P F. Recent advances in understanding the fatigue and wear behavior of dental composites and ceramics. $J$ Mech Behav Biomed Mater 88: 504–533 (2018)   
[392] Obermeier M, Ristow O, Erdelt K, Beuer F. Mechanical performance of cement- and screw-retained all-ceramic single crowns on dental implants. Clin Oral Investig 22(2): 981–991 (2018)   
[393] Raghav G R, Balaji A N, Muthukrishnan D, Sruthi V, Sajith E. An experimental investigation on wear and corrosion characteristics of $\mathrm { M g - C o }$ nanocomposites. Mater Res Express 5(6):066523 (2018)   
[394] Luo J S, Wu S Q, Lu Y J, Guo S, Yang Y, Zhao C Q, Lin J J, Huang T T, Lin J X. The effect of 3 $\mathrm { w t \% }$ Cu addition on the microstructure, tribological property and corrosion resistance of CoCrW alloys fabricated by selective laser melting. J Mater Sci: Mater Med 29(4): 37 (2018)   
[395] Dong R, Zhu W W, Zhao C C, Zhang Y W, Ren F Z. Microstructure, mechanical properties, and sliding wear behavior of spark plasma sintered Ti–Cu alloys. Metall Mater Trans A 49(12): 6147–6160 (2018)   
[396] Kumar S R, Patnaik A, Bhat I K. Wear behavior of light-cured dental composite reinforced with silane-treated nanosilica filler. Polym Adv Technol 29(5): 1394–1403 (2018)   
[397] Stöckl C, Hampe R, Stawarczyk B, Haerst M, Roos M. Macro- and microtopographical examination and quantification of CAD-CAM composite resin 2- and 3-body wear. J Prosthet Dent 120(4): 537–545(2018)   
[398] Kewekordes T, Wille S, Kern M. Wear of polyetherketoneketones— nfluence of titanium dioxide content and antagonistic material. Dent Mater 34(3): 560–567(2018)   
[399] Sonal, Kumar S R, Patnaik A, Meena A, Godara M. Effect of adding nanosilica particulate filler on the wear behavior of dental composite. Polym Compos 39(S1): E332–E341 (2018)   
[400] Aborass M, Peck M T, Holmes H. Effect of diamond-like carbon coating on implant drill wear during implant site preparation. South Afr Dent J 73(4): 189–191 (2018)   
[401] Danışman Ş, Odabas D, Teber M. The effect of coatings on the wear behavior of Ti6Al4V alloy used in biomedical applications. IOP Conf Ser: Mater Sci Eng 295(1): 012044 (2018)   
[402] Nourani-Vatani M, Ganjali M, Solati-Hashtjin M, Zarrintaj P, Saeb M R. Zirconium-based hybrid coatings: A versatile strategy for biomedical engineering applications. Mater Today: Proc 5(7): 15524–15531 (2018)   
[403] Wang W, Wang Y, Yu X H. Effect of shot-peening treatment on the bio-tribological properties of a $\mathrm { N i } ^ { + }$ implantation layer formed on the surface of Ti6Al4V. Mater Res Express 5(6): 066423 (2018)   
[404] Zhang Z Z, Guo J W, Sun Y L, Tian B M, Zheng X J, Zhou M, He L, Zhang S F. Effects of crystal refining on wear behaviors and mechanical properties of lithium disilicate glass-ceramics. J Mech Behav Biomed Mater 81: 52–60 (2018)   
[405] Wu T T, Gan X Q, Zhu Z L, Yu H Y. Aging effect of pH on the mechanical and tribological properties of dental composite resins. Part Sci Technol 36(3): 378–385 (2018)   
288   
[406] Figueiredo-Pina C G, Guedes M, Sequeira J, Pinto D, Bernardo N, Carneiro C. On the influence of Streptococcus salivarius on the wear response of dental implants: An in vitro study. J Biomed Mater Res Part B: Appl Biomater 107(5): 1393–1399 (2019)   
[407] Sarıkaya I, Hayran Y. Effects of dynamic aging on the wear and fracture strength of monolithic zirconia restorations. BMC Oral Health 18(1): 146 (2018)   
[408] Yang S W, Kim J E, Shin Y, Shim J S, Kim J H. Enamel wear and aging of translucent zirconias: In vitro and clinical studies. J Prosthet Dent 121(3): 417–425 (2019)   
[409] Antunes P V, Ramalho A L. Influence of abrasive solutions on direct restorative composites wear. J Braz Soc Mech Sci Eng 40(1): 20 (2018)   
[410] Branco A C, Moreira V, Reis J A, Colaço R, FigueiredoPina C G, Serro A P. Influence of contact configuration and lubricating conditions on the microtriboactivity of the zirconia-Ti6Al4V pair used in dental applications. J Mech Behav Biomed Mater 91: 164–173 (2019)   
[411] Velmurugan D, Alphin M S, Tony B J A R. The sensitivity of contact stresses in the mandibular premolar region to the shape of Zirconia dental implant: A 3D finite element study. Pol J Med Phys Eng 24(2): 55–63 (2018)   
[412] Velmurugan D, Alphin M S. Micromotion of immediately loaded zirconia dental implants for various parametric conditions: A three-dimensional finite element study. J Biomater Tissue Eng 8(7): 962–971 (2018)   
[413] Velmurugan D, Alphin M S. Influence of geometric design variable and bone quality on stress distribution for zirconia dental implants-A 3D finite element analysis. CMES: Comput Model Eng Sci 117(2): 125–141 (2018)   
[414] Klekotka M, Dąbrowski J R. Fretting wear of NiTishape-memory alloy. In Innovations in Biomedical Engineering. Gzik M, Tkacz E, Paszenda Z, Piętka E, Eds. Cham: Springer, 2017: 33–39.   
[415] Wulfman C, Koenig V, Mainjot A K. Wear measurement of dental tissues and materials in clinical studies: A systematic review. Dent Mater 34(6): 825–850 (2018)   
[416] Kumar M, Verma R, Bansal M, Singh S, Rehan S, Kumar V, Simran D. To evaluate the severity, distribution of occlusal tooth wear and its correlation with bite force in young North Indian adults. Open Dent J 12: 735–741 (2018)   
[417] Assunção C M, Lussi A, Rodrigues J A, Carvalho T S. Efficacy of toothpastes in the prevention of erosive tooth wear in permanent and deciduous teeth. Clin Oral Investig 23(1): 273–284 (2019)   
[418] Ijbara M, Wada K, Tabata M J, Wada J, Inoue G, Miyashin M. Enamel microcracks induced by simulated occlusal wear in mature, immature, and deciduous teeth. BioMed Res Int 2018: 5658393 (2018) [419] Min J, Yu P, Xu Z, Li Z, Zhang Q Q, Yu H Y, Gao S S. Investigation on the gradient nanomechanical behavior of dental fluorosis enamel. Nanoscale Res Lett 13: 347 (2018) [420] Jang S J, Choi D S, Jang I, Jost-Brinkmann P G, Cha B K. Quantitative comparison of incisal tooth wear in patients receiving one-phase or two-phase treatment for skeletal Class III malocclusion with anterior crossbite. Angle Orthod   
88(2): 151–156 (2018) [421] Borrero-Lopez O, Constantino P J, Lawn B R. Role of particulate concentration in tooth wear. J Mech Behav Biomed Mater 80: 77–80 (2018) [422] Xia J, Zhou Z R, Qian L M, Ungar P S. Comment on van Casteren et al. (2018): Softer metallic spheres do abrade harder enamel. Roy Soc Open Sci 5(11): 181376 (2018) [423] Van Casteren A, Lucas P W, Strait D S, Michael S, Bierwisch N, Schwarzer N, Al-Fadhalah K J, Almusallam A S, Thai L A, Saji S, et al. Evidence that metallic proxies are unsuitable for assessing the mechanics of microwear formation and a new theory of the meaning of microwear. Roy Soc Open Sci 5(5): 171699 (2018) [424] Ahn J H, Kim J H, Ha W H, Park Y D. Tooth wear and cleaning effect of an abrasive-free dentifrice. J Dent Sci   
13(1): 13–19 (2018) [425] Alali A Y, Al-Khabbaz A, Michael S, Swain M V. Frictional coefficient during flossing of teeth. Dent Mater   
34(12): 1727–1734 (2018) [426] Tulek A, Saeed M, Mulic A, Stenhagen K R, Utheim T P, Galtung H K, Khuu C, Nirvani M, Kristiansen M S, Sehic A. New animal model of extrinsic dental erosion-erosive effect on the mouse molar teeth. Arch Oral Biol 96:   
137–145 (2018) [427] Esquivel-Upshaw J F, Kim M J, Hsu S M, Abdulhameed N, Jenkins R, Neal D, Ren F, Clark A E. Randomized clinical study of wear of enamel antagonists against polished monolithic zirconia crowns. J Dent 68: 19–27 (2018) [428] Xu F, Laguna L, Sarkar A. Aging-related changes in quantity and quality of saliva: Where do we stand in our understanding? J Texture Stud 50(1): 27–35 (2019) [429] Vinke J, Kaper H J, Vissink A, Sharma P K. An ex vivo salivary lubrication system to mimic xerostomic conditions and to predict the lubricating properties of xerostomia relieving agents. Sci Rep 8(1): 9087 (2018) [430] Ionta F Q, De Alencar C R B, Dos Santos N M, Bergantin B T P, Val P P, Honório H M, DeOliveira T M, Rios D. Effect of palm oil alone or associated to stannous solution on enamel erosive-abrasive wear: A randomized in situ/ex vivo study. Arch Oral Biol 95: 68–73 (2018) [431] Ungar P S, Berger L R. Brief communication: Dental microwear and diet of Homo naledi. Am J Phys Anthropol   
166(1): 228–235 (2018)   
[432] Percher A M, Merceron G, Akoue G N, Galbany J, Romero A, Charpentier M J E. Dental microwear textural analysis as an analytical tool to depict individual traits and reconstruct the diet of a primate. Am J Phys Anthropol 165(1): 123–138 (2018)   
[433] Berthaume M A, Delezene L K, Kupczik K. Dental topography and the diet of Homo naledi. J Hum Evol 118: 14–26 (2018)   
[434] Blondel C, Rowan J, Merceron G, Bibi F, Negash E, Barr W A, Boisserie J R. Feeding ecology of Tragelaphini (Bovidae) from the Shungura Formation, Omo Valley, Ethiopia: Contribution of dental wear analyses. Palaeogeogr Palaeoclimatol Palaeoecol 496: 103–120 (2018)   
[435] Von Koenigswald W, Rose K D, Holbrook L T, Kumar K, Rana R S, Smith T. Mastication and enamel microstructure in Cambaytherium, a perissodactyl-like ungulate from the early Eocene of India. PalZ 92(4): 671–680 (2018)   
[436] Von Koenigswald W. Specialized wear facets and late ontogeny in mammalian dentitions. Hist Biol 30(1–2): 7–29 (2018)   
[437] Joyner H S. Explaining food texture through rheology. Curr Opin Food Sci 21: 7–14 (2018)   
[438] Pondicherry K S, Rummel F, Laeuger J. Extended stribeck curves for food samples. Biosurf Biotribol 4(1): 34–37 (2018)   
[439] Masen M, Cann P M E. Friction measurements with molten chocolate. Tribol Lett 66: 24(2018)   
[440] Ng S B X, Nguyen P T M, Bhandari B, Prakash S. Influence of different functional ingredients on physical properties, rheology, tribology, and oral perceptions of no fat stirred yoghurt. J Texture Stud 49(3): 274–285 (2018)   
[441] Dickinson E. On the road to understanding and control of creaminess perception in food colloids. Food Hydrocolloids 77: 372–385 (2018)   
[442] Canon F, Neiers F, Guichard E. Saliva and flavor perception: Perspectives. J Agric Food Chem 66(30): 7873–7879 (2018)   
[443] Gibson C G, Lin F C, Phillips C, Edelman A, Ko C C. Characterizing constraining forces in the alignment phase of orthodontic treatment. Angle Orthod 88(1): 67–74 (2018)   
[444] Sugisawa H, Kitaura H, Ueda K, Kimura K, Ishida M, Ochi Y, Kishikawa A, Ogawa S, Takano-Yamamoto T. Corrosion resistance and mechanical properties of titanium nitride plating on orthodontic wires. Dent Mater J 37(2): 286–292 (2018)   
[445] Kato M, Namura Y, Yoneyama T, Shimizu N. Effect of the vertical position of the canine on the frictional/orthodontic force ratio of Ni-Ti archwires during the levelling phase of orthodontic treatment. J Oral Sci 60(3): 336–343 (2018)   
[446] Mascarelo A C, Godoi A P, Furletti V, Custódio W, Valdrighi H C. Evaluation of friction in metal, ceramic and self-ligating brackets submitted to sliding mechanics. Rev Odontol UNESP 47(4): 244–248 (2018) [447] Asiry M A, AlShahrani I, Almoammar S, Durgesh B H, Al Kheraif A A, Hashem M I. Influence of epoxy, polytetrafluoroethylene (PTFE) and rhodium surface coatings on surface roughness, nano-mechanical properties and biofilm adhesion of nickel titanium (Ni–Ti) archwires. Mater Res Express 5(2): 026511 (2018) [448] Usui T, Iwata T, Miyake S, Otsuka T, Koizumi S, Shirakawa N, Kawata T. Mechanical and frictional properties of aesthetic orthodontic wires obtained by hard chrome carbide plating. J Dent Sci 13(2): 151–159 (2018) [449] Marin D O M, Leite A R P, De Oliveira Junior N M, Paleari A G, Pero A C, Compagnoni M A. Retention force and wear characteristics of three attachment systems after dislodging cycles. Braz Dent J 29(6): 576–582 (2018) [450] Noronha Oliveira M, Schunemann W V H, Mathew M T, Henriques B, Magini R S, Teughels W, Souza J C M. Can degradation products released from dental implants affect peri-implant tissues? J Periodontal Res 53(1): 1–11 (2018) [451] Wang Z G, Zhou Y T, Wang H N, Li Y, Huang W J. Tribocorrosion behavior of $\mathrm { T i } { - } 3 0 \mathrm { Z r }$ alloy for dental implants. Mater Lett 218: 190–192 (2018) [452] Buciumeanu M, Bagheri A, Shamsaei N, Thompson S M, Silva F S, Henriques B. Tribocorrosion behavior of additive manufactured Ti–6Al–4V biomedical alloy. Tribol Int 119:   
381–388 (2018) [453] Hussein M A, Yilbas B, Kumar A M, Drew R, Al-Aqeeli N. Influence of laser nitriding on the surface and corrosion properties of Ti–20Nb–13Zr alloy in artificial saliva for dental applications. J Mater Eng Perform 27(9): 4655–4664 (2018) [454] Pawelec K, Baranowicz P, Wysokińska-Miszczuk J, Madej M. Influence of $\mathrm { p H }$ on the tribological properties of DLCcoated Ti–-6Al–4V titanium alloy. AIP Conf Proc 2017(1):   
020021 (2018) [455] Mindivan F, Mindivan H. Microstructure and tribocorrosion properties of pulsed plasma nitrided cast CoCr alloy for dental implant applications. ActaPhys Pol A 134(1): 192–195 (2018) [456] Mendes T A, Caramês J, Lopes L P, Ramalho A L. Sphere-plane methodology to evaluate the wear of titanium of dental implants: A research proposal. BMC Res Notes   
11(1): 529 (2018) [457] Wang S H, Xu J, Wang W C, Wang G J N, Rastak R, Molina-Lopez F, Chung J W, Niu S M, Feig V R, Lopez J, et al. Skin electronics from scalable fabrication of an intrinsically stretchable transistor array. Nature 555(7694):   
83–88 (2018)   
[458] Liu X, Carré M J, Zhang Q, Lu Z, Matcher S J, Lewis R. Measuring contact area in a sliding human finger-pad contact. Skin Res Technol 24(1): 31–44 (2018)   
[459] Vagts S, Schlattmann J, Kovalev A, Gorb S N. The topology of the leg joints of the Beetle Pachnoda marginata (Scarabaeidae, Cetoniinae) and its implication for the tribological properties. Biomimetics 3(2): 12 (2018)   
[460] Wu W B, Lutz C, Mersch S, Thelen R, Greiner C, Gomard G, Hölscher H. Characterization of the microscopic tribological properties of sandfish (Scincus scincus) scales by atomic force microscopy. Beilstein J Nanotechnol 9: 2618–2627 (2018)   
[461] Zheng L, Zhong Y H, Gao Y H, Li J Y, Zhang Z H, Liu Z N, Ren L Q. Coupling effect of morphology and mechanical properties contributes to the tribological behaviors of snake scales. J Bionic Eng 15(3): 481–493 (2018)   
[462] Trotta A, Ní Annaidh A, Burek R O, Pelgrims B, Ivens J. Evaluation of the head-helmet sliding properties in an impact test. J Biomech 75: 28–34 (2018)   
[463] Schneider J, Djamiykov V, Greiner C. Friction reduction through biologically inspired scale-like laser surface textures. Beilstein J Nanotechno l9: 2561–2572 (2018)   
[464] Tang K P M, Chau K H, Kan C W, Fan J T. Assessing the accumulated stickiness magnitude from fabric-skin friction: Effect of wetness level of various fabrics. Roy Soc Open Sci 5(8): 180860 (2018)   
[465] Filippov A E, Westhoff G, Kovalev A, Gorb S N. Numerical model of the slithering snake locomotion based on the friction anisotropy of the ventral skin. Tribol Lett 66(3): 119 (2018)   
[466] Persson $_ { \mathrm { ~ B ~ N ~ J ~ } }$ . The dependency of adhesion and friction on electrostatic attraction. J Chem Phys 148(14): 144701 (2018)   
[467] Son S K, Kim S W, Park M K, Song S H, Park S J, Hwang S L, Lee S M. Effect of the coacervate systems in shampoo formulation on hair damage. J Soc Cosmet Sci Korea 44(2): 141–149 (2018)   
[468] Tang K P M, Chu K H, Kan C W, Fan J T. Instrumental evaluation of stickiness of textiles under wet skin surface. IEEE Access 6: 24777–24792 (2018)   
[469] Wang Y, Li J S, Shang Y Z, Zeng X Q. Study on the development of wax emulsion with liquid crystal structure and its moisturizing and frictional interactions with skin. Colloids Surf B Biointerfaces 171: 335–342 (2018)   
[470] Xu X Y, Wu J N, Yang Y Q, Zhu R G, Yan S Z. Operculum of a water snail is a hydrodynamic lubrication sheet. J Bionic Eng 15(3): 471–480 (2018)   
[471] Khojasteh B, Janko M, Visell Y. Complexity, rate, and scale in sliding friction dynamics between a finger and textured surface. Sci Rep 8(1): 13710 (2018)   
[472] Babu D, Konyo M, Nagano H, Tadokoro S. Introducing slip model incorporating finger stiffness. IEEE Trans Haptics 11(3): 417–430(2018)   
[473] Cesini I, Ndengue J D, Chatelet E, Faucheu J, Massi F. Correlation between friction-induced vibrations and tactile perception during exploration tasks of isotropic and periodic textures. Tribol Int 120: 330–339 (2018)   
[474] Dhong C, Kayser L V, Arroyo R, Shin A, Finn III M, Kleinschmidt A T, Lipomi D J. Role of fingerprintinspired relief structures in elastomeric slabs for detecting frictional differences arising from surface monolayers. Soft Matter 14(36): 7483–7491 (2018)   
[475] Asanuma N, Aita Y, Nonomura Y. Tactile texture of cosmetic sponges and their friction behavior under accelerated movement. J Oleo Sci 67(9): 1117–1122 (2018)   
[476] Carpenter C W, Dhong C, Root N B, Rodriquez D, Abdo E E, Skelil K, Alkhadra M A, Ramírez J, Ramachandran V S, Lipomi D J. Human ability to discriminate surface chemistry by touch. Mater Horiz 5(1): 70–77 (2018)   
[477] Janko M, Wiertlewski M, Visell Y. Contact geometry and mechanics predict friction forces during tactile surface exploration. Sci Rep 8(1): 4868 (2018)   
[478] Zhou X, Mo J L, Li Y Y, Xu J Y, Zhang X, Cai S, Jin Z M. Correlation between tactile perception and tribological and dynamical properties for human finger under different sliding speeds. Tribol Int 123: 286–295 (2018)   
[479] Raccuglia M, Pistak K, Heyde C, Qu J G, Mao N T, Hodder S, Havenith G. Human wetness perception of fabrics under dynamic skin contact. Text Res $J$ 88(19): 2155–2168 (2018)   
[480] Abdouni A, Vargiolu R, Zahouani H. Impact of finger biophysical properties on touch gestures and tactile perception: Aging and gender effects. Sci Rep 8(1): 12605 (2018)   
[481] Skedung L, El Rawadi C, Arvidsson M, Farcet C, Luengo G S, Breton L, Rutland M W. Mechanisms of tactile sensory deterioration amongst the elderly. Sci Rep 8(1): 5303 (2018)   
[482] Massi F, Vittecoq E, Chatelet E, Saulot A, Berthier Y. Design of a tribometer for investigating tactile perception. Proc Inst Mech Eng, Part J: J Eng Tribol 232(6): 773–784 (2018)   
[483] Camillieri B, Bueno MA, Fabre M, Juan B, LemaireSemail B, Mouchnino L. From finger friction and induced vibrations to brain activation: Tactile comparison between real and virtual textile fabrics. Tribol Int 126: 283–296 (2018)   
[484] Nobuyama L, Kurashina Y, Kawauchi K, Matsui K, Takemura K. Tactile estimation of molded plastic plates based on the estimated impulse responses of mechanoreceptive units. Sensors (Basel) 18(5): 1588 (2018)   
[485] Özgün N, Strauss D J, Bennewitz R. Tribology of a braille display and EEG correlates. Tribol Lett 66: 16 (2018)   
[486] Waga M, Aita Y, Noma J, Nonomura Y. Tactile feels in grasping/cutting processes with scissors. Technologies 6(3): 66 (2018)   
[487] Thieulin C, Vargiolu R, Zahouani H. Effects of cosmetic treatments on the morphology, biotribology and sensorial properties of a single human hair fiber. Wear 426–427: 186–194 (2019)   
[488] Ollero A, Sanfeliu A, Montano L, Lau N, Cardeira C. ROBOT 2017: Third Iberian Robotics Conference. Cham (Switzerland): Springer, 2018.   
[489] Subhi K A, Tudor A, Hussein E K, Wahad H, Chisiu G. Ex-vivo cow skin viscoelastic effect for tribological aspects in endoprosthesis. IOP Conf Ser: Mater Sci Eng 295(1): 012018 (2018)   
[490] Ding S Y, Pan Y L, Zhao X Z. Humanoid identification of fabric material properties by vibration spectrum analysis. Sensors (Basel) 18(6): 1820(2018)   
[491] Ibrahim M D, Amran S N A, Zulkharnain A, Sunami Y. Streamlined vessels for speedboats: Macro modifications of shark skin design applications. AIP Conf Proc 1929(1): 020023 (2018)   
[492] Zhang G Q, Ren T H, Zhang S, Zeng X Q, Van Der Heide E. Study on the tribological behavior of surgical suture interacting with a skin substitute by using a penetration friction apparatus. Colloids Surf B Biointerfaces 162: 228–235 (2018)   
[493] Zhang S, Kai Y, Sunami Y. Tactile sliding behavior of R2R mass-produced PLLA nanosheet towards biomedical device in skin applications. Nanomaterials (Basel) 8(4): 210(2018)   
[494] Xu Z W, Wu C X, Li F S, Chen W, Guo T L, Kim T W. Triboelectric electronic-skin based on graphene quantum dots for application in self-powered, smart, artificial fingers. Nano Energy 49: 274–282 (2018)   
[495] Simič R, Mathis C H, Spencer N D. A two-step method for rate-dependent nano-indentation of hydrogels. Polymer 137: 276–282 (2018)   
[496] Mao Y F, Yan J Y, Wang L L, Dong W P, Jia Y M, Hu X, Wang X M. Formation and properties of bioactive barium titanate coatings produced by plasma electrolytic oxidation. Ceram Int 44(11): 12978–12986 (2018)   
[497] Moskalewicz T, Zimowski S, Zych A, Łukaszczyk A, Reczyńska K, Pamuła E. Electrophoretic deposition, microstructure and selected properties of composite alumina/ polyetheretherketone coatings on the Ti-13Nb-13Zr alloy. J Electrochem Soc 165(3): D116–D128 (2018)   
[498] Hou B P, Yang Z, Yang Y L, Zhang E L, Qin G W. In vitro bioactivity, tribological property, and antibacterial ability of Ca–Si-based coatings doped with cu particles in-situ fabricated by laser cladding. Appl Phys A 124(3): 256 (2018)   
[499] Li J W, Ma Y H, Tong J, Ma Z C, Wang L D, Yu J T. Mechanical properties and microstructure of potato peels. Int J Food Prop 21(1): 1395–1413 (2018)   
[500] Wang Z M, Zhang H B, Chu A J, Jackson J, Lin K R, Lim C J, Lange D, Chiao M. Mechanically enhanced nestednetwork hydrogels as a coating material for biomedical devices. Acta Biomater 70: 98–109 (2018)   
[501] Morgese G, Gombert Y, Ramakrishna S N, Benetti E M. Mixing poly(ethylene glycol) and poly(2-alkyl-2-oxazoline)s enhances hydration and viscoelasticity of polymer brushes and determines their nanotribological and antifouling properties. ACS Appl Mater Interfaces 10(48): 41839–41848 (2018)   
[502] Mauro A, Massarotti N, Salahudeen M, Romano M R, Romano V, Nithiarasu P. A generalised porous medium approach to study thermo-fluid dynamics in human eyes. Med Biol Eng Comput 56(10): 1823–1839 (2018)   
[503] Lau C, Tosatti S, Mundorf M, Ebare K, Osborn Lorenz K. Comparison of the lubricity and surface roughness of 5 cosmetic contact lenses. Eye Contact Lens 44(Suppl2): S256–S265 (2018)   
[504] Colter J, Wirostko B, Coats B. Finite element design optimization of a hyaluronic acid-based hydrogel drug delivery device for improved retention. Ann Biomed Eng 46(2): 211–221 (2018)   
[505] Frost K F, Gorb S N, Wolff J O. Adhesion and friction in hunting spiders: The effect of contact splitting on their attachment ability. Zool Anz 273: 231–239 (2018)   
[506] Ge J Z, Calderón A A, Chang L L, Pérez-Arancibia N O. An earthworm-inspired friction-controlled soft robot capable of bidirectional locomotion. Bioinspir Biomim 14(3): 036004 (2019)   
[507] Tricinci O, Eason E V, Filippeschi C, Mondini A, Mazzolai B, Pugno N M, Cutkosky M R, Greco F, Mattoli V. Approximating gecko setae via direct laser lithography. Smart Mater Struct 27(7): 075009(2018)   
[508] Wang Z Y, Xing Q, Wang W B, Ji A H, Dai Z D. Contribution of friction and adhesion to the reliable attachment of a gecko to smooth inclines. Friction 6(4): 407–419 (2018)   
[509] Petersen D S, Kreuter N, Heepe L, Büsse S, Wellbrock A H J, Witte K, Gorb S N. Holding tight to feathers-structural specializations and attachment properties of the avian ectoparasite Crataerina pallida (Diptera, Hippoboscidae). J Exp Biol 221(13): Jeb179242 (2018)   
[510] Li J, Zhang Y, Liu S, Liu J L. Insights into adhesion of abalone: A mechanical approach. J Mech Behav Biomed Mater 77: 331–336 (2018) [511] Hassanalian M, Ayed S B, Ali M, Houde P, Hocut C, Abdelkefi A. Insights on the thermal impacts of wing colorization of migrating birds on their skin friction drag and the choice of their flight route. J Therm Biol 72:   
81–93 (2018) [512] Graf C, Kesel A B, Gorb E V, Gorb S N, Dirks J H. Investigating the efficiency of a bio-inspired insect repellent surface structure. Bioinspir Biomim 13(5): 056010 (2018) [513] Gilet T, Heepe L, Lambert P, Compère P, Gorb S N. Liquid secretion and setal compliance: The beetle's winning combination for a robust and reversible adhesion. Curr Opin Insect Sci 30: 19–25 (2018) [514] Ma Y F, Ma S H, Wu Y, Pei X W, Gorb S N, Wang Z K, Liu W M, Zhou F. Remote control over underwater dynamic attachment/detachment and locomotion. Adv Mater 30(30):   
1801595 (2018) [515] Kadar A, Liu H Y, Vrieze A M, Meier T R, Thoreson A R, Amadio P C, Moran S L, Zhao C F. Establishment of an in vivo turkey model for the study of flexor tendon repair. J Orthop Res 36(9): 2497–2505 (2018) [516] Pitenis A A, Urueña J M, Hart S M, O’Bryan C S, Marshall S L, Levings P P, Angelini T E, Sawyer W G. Friction-Induced Inflammation. Tribol Lett 66(3): 81 (2018) [517] Christensen A, West A K V, Wullkopf L, Terra Erler J, Oddershede L B, Mathiesen J. Friction-limited cell motility in confluent monolayer tissue. Phys Biol 15(6): 066004 (2018) [518] Kheradmandfard M, Kashani-Bozorg S F, Lee J S, Kim C L, Hanzaki A Z, Pyun Y S, Cho S W, Amanov A, Kim D E. Significant improvement in cell adhesion and wear resistance of biomedical $\beta$ -type titanium alloy through ultrasonic nanocrystal surface modification. J Alloys Compd   
762: 941–949 (2018) [519] Williamson J J, Salbreux G. Stability and roughness of interfaces in mechanically regulated tissues. Phys Rev Lett   
121(23): 238102 (2018) [520] Taheri R, Kosasih B, Zhu H T, Tieu A. Dispersion stability and lubrication performance correlation of vegetable oil-in-water emulsions with nanoparticle-shielded oil droplets. Lubricants 6(2): 55(2018) [521] Shah P R, Ganesh A. A novel strategy of periodic dosing of soy-lecithin as additive during long term test of diesel engine fueled with straight vegetable oil. Fuel 228: 405–417 (2018) [522] Annisa A N, Widayat W. A review of bio-lubricant production from vegetable oils using esterification transesterification process. MATEC Web Conf 156: 06007 (2018)   
[523] Valeru S B, Srinivas Y, Suman $\mathrm { ~ K ~ N ~ s ~ }$ . An attempt to improve the poor performance characteristics of coconut oil for industrial lubricants. J Mech Sci Technol 32(4): 1733–1737 (2018)   
[524] Gan Y, Chen H W, Ran T, Zhang P F, Zhang D Y. The prey capture mechanism of micro structure on the Sarracenia Judith Hindle inner surface. J Bionic Eng 15(1): 34–41 (2018)   
[525] Manwell T, Guo B J, Back J, Liu H B. Bioinspired setae for soft worm robot locomotion. In Proceedings of 2018 IEEE International Conference on Soft Robotics, Livorno, Italy, 2018: 54–59.   
[526] Li C, Yang L J, Yan C C, Chen W, Cheng G H. Biomimetic anti-adhesive surface micro-structures of electrosurgical knife fabricated by fibre laser. J Laser Micro/Nanoeng 13(3): 309–313 (2018)   
[527] Zhao H X, Sun Q Q, Deng X, Cui J X. Earthworminspired rough polymer coatings with self-replenishing lubrication for adaptive friction-reduction and antifouling surfaces. Adv Mater 30(29): 1802141 (2018)   
[528] Sun J Y, Liu C, Bhushan B, Wu W, Tong J. Effect of microtrichia on the interlocking mechanism in the Asian ladybeetle, Harmonia axyridis (Coleoptera: Coccinellidae). Beilstein J Nanotechnol 9: 812–823 (2018)   
[529] Ningtyas D W, Bhandari B, Bansal N, Prakash S. Effect of homogenisation of cheese milk and high-shear mixing of the curd during cream cheese manufacture. Int J Dairy Technol 71(2): 417–431 (2018)   
[530] Kaliniewicz Z, Żuk Z, Krzysiak Z. Influence of steel plate roughness on the frictional properties of cereal kernels. Sustainability 10(4): 1003(2018)   
[531] Bayer I S. Advances in tribology of lubricin and lubricinlike synthetic polymer nanostructures. Lubricants 6(2): 30(2018)   
[532] Petrou G, Crouzier T. Mucins as multifunctional building blocks of biomaterials. Biomater Sci 6(9): 2282–2297 (2018)   
[533] Li G, Long X Y, Yang P, Liang Z K. Advance on friction of stamping forming. Int J Adv Manuf Technol 96(1–4): 21–38 (2018)   
[534] Muro M, Artola G, Gorriño A, Angulo C. Wear and friction evaluation of different tool steels for hot stamping. Adv Mater Sci Eng 2018: 3296398 (2018)   
[535] Hernandez S, Hardell J, Prakash B. High-temperature friction and wear of boron steel and tool steel in open and closed tribosystems. Tribol Trans 61(3): 448–458(2018)   
[536] Venema J, Hazrati J, Matthews D T A, Stegeman R A, Van Den Boogaard A H. The effects of temperature on friction and wear mechanisms during direct press hardening of Al-Si coated ultra-high strength steel. Wear 406–407: 149–155 (2018)   
[537] Mozgovoy S, Hardell J, Deng L, Oldenburg M, Prakash B. Tribological behavior of tool steel under press hardening conditions using simulative tests. J Tribol 140(1): 011606 (2018)   
[538] Deng L, Pelcastre L, Hardell J, Prakash B, Oldenburg M. Experimental evaluation of galling under press hardening conditions. Tribol Lett 66(3): 93 (2018)   
[539] Huttunen-Saarivirta E, Kilpi L, Hakala T J, Metsäjoki J, Ronkainen H. Insights into the behaviour of tool steelaluminium alloy tribopair at different temperatures. Tribol Int 119: 567–584(2018)   
[540] Fan Q, Zhou D L, Yang L, Zhou J B, Yang S, Yang Y Q. Study on the oxidation resistance and tribological behavior of glass lubricants used in hot extrusion of commercial purity titanium. Colloids Surf A: Physicochem EngAspects 559: 251–257 (2018)   
[541] Cui S G, Zhu H T, Wan S H, Tran B, Wang L, Tieu K. Investigation of different inorganic chemical compounds as hot metal forming lubricant by pin-on-disc and hot rolling. Tribol Int 125: 110–120 (2018)   
[542] Tran B H, Tieu A K, Wan S H, Zhu H T, Mitchell D R G, Nancarrow M J. Multifunctional bi-layered tribofilm generated on steel contact interfaces under high-temperature melt lubrication. J Phys Chem $C$ 121(45): 25092–25103 (2017)   
[543] Tran B H, Tieu A K, Wan S H, Zhu H T, Liu R. Hot corrosion of borate melt and interface chemistry of boratecoated steel under tribological stimulation. Corros Sci 140: 231–240 (2018)   
[544] Tran B H, Tieu K, Wan S H, Zhu H T, Cui S G, Wang L P. Understanding the tribological impacts of alkali element on lubrication of binary borate melt. RSC Adv 8(51): 28847–28860 (2018)   
[545] Tran B H, Tieu K, Wan S H, Zhu H T. Lubricant as a sticking-scale inhibitor on high temperature sliding contact. Tribol Int 140: 105860 (2019)   
[546] Torres H, Rodríguez Ripoll M, Prakash B. Tribological behaviour of self-lubricating materials at high temperatures. Int Mater Rev 63(5): 309–340 (2018)   
[547] Zhu S Y, Cheng J, Qiao Z H, Yang J. High temperature solid-lubricating materials: A review. Tribol Int 133: 206– 223(2019)   
[548] Liu Y, Zhu Z J, Wang Z J, Zhu B, Wang Y L, Zhang Y S. Flow and friction behaviors of 6061 aluminum alloy at elevated temperatures and hot stamping of a B-pillar. Int J Adv Manuf Technol 96(9–12): 4063–4083 (2018)   
[549] Zhang A J, Han J S, Su B, Meng J H. A promising new high temperature self-lubricating material: $\mathrm { C o C r F e N i S } _ { 0 . 5 }$ high entropy alloy. Mater Sci Eng A 731: 36–43 (2018)   
[550] Erdoğan A, Gök M S, Zeytin S. Analysis of the hightemperature dry sliding behavior of $\mathrm { C o C r F e N i T i _ { 0 . 5 } A l _ { \it x } }$ high-entropy alloys. Friction 8(1): 198-207 (2020)   
[551] Zhou H Y, Shi X L, Huang Y C, Liu $\textrm { X Y }$ , Li B. Tribological performance of M50–Ag–TiC self-lubricating composites at elevated temperature. J Mater Eng Perform 27(7): 3731–3741 (2018)   
[552] Han H L, Qian Z Y, Meng F M, Cui Z T. Tribological performances of graphite–MoS2 coating at various high temperatures. Proc Inst Mech Eng, Part J: J Eng Tribol 233(12): 1888–1902 (2019)   
[553] Serra E C, Soares V F D, Fernandez D A R, Hübler R, Juste K R C, Lima C L, Tentardini E K. Influence of $\mathrm { W S } _ { 2 }$ content on high temperature wear performance of magnetron sputtered TiN– ${ \mathrm { . W S } } _ { x }$ thin films. Ceram Int 45(16): 19918– 19924 (2019)   
[554] Meng F M, Yang C Z, Han $\textrm { H L }$ . Study on tribological performances of $\mathbf { M o S } _ { 2 }$ coating at high temperature. Proc Inst Mech Eng, Part J: J Eng Tribol 232(8): 964–973 (2018)   
[555] Torres H, Slawik S, Gachot C, Prakash B, Rodríguez Ripoll M. Microstructural design of self-lubricating laser claddings for use in high temperature sliding applications. Surf Coat Technol 337: 24–34 (2018)   
[556] Torres H, Vuchkov T, Rodríguez Ripoll M, Prakash B. Tribological behaviour of MoS2-based self-lubricating laser cladding for use in high temperature applications. Tribol Int 126: 153–165 (2018)   
[557] Torres H, Vuchkov T, Slawik S, Gachot C, Prakash B, Rodríguez Ripoll M. Self-lubricating laser claddings for reducing friction and wear from room temperature to $6 0 0 ^ { \circ } \mathrm { C }$ . Wear 408–409: 22–33 (2018)   
[558] Dong Y C, Zheng K L, Fernandez J, Fuentes G, Li X Y, Dong H S. Tribology and hot forming performance of self-lubricious NC/NiBN and NC/WC: C hybrid composite coatings for hot forming die. J Mater Process Technol 252: 183–190 (2018)   
[559] Du S M, Li Z, He Z T, Ding H L, Wang X C, Zhang Y Z. Effect of temperature on the friction and wear behavior of electroless $\mathrm { N i } – \mathrm { P } – \mathrm { M o S } _ { 2 } – \mathrm { C a F } _ { 2 }$ self-lubricating composite coatings. Tribol Int 128: 197–203 (2018)   
[560] Zeng Q F, Cai $\textrm { S L }$ , Li S J. High-temperature low-friction behaviors of $\ r \gamma – \mathrm { F e } _ { 2 } \mathrm { O } _ { 3 } @ \mathrm { S i O } _ { 2 }$ nanocomposite coatings obtained through sol–gel method. J Sol-Gel Sci Technol 85(3): 558–566 (2018)   
[561] Bondarev A V, Kvashnin D G, Shchetinin I V, Shtansky D V. Temperature-dependent structural transformation and friction behavior of nanocomposite VCN-(Ag) coatings. Mater Des 160: 964–973 (2018)   
[562] Guo Y X, Liu Q B, Zhou F. Microstructure and properties of Fe5Cr5SiTiCoNbMoW coating by laser cladding. Surf Eng 34(4): 283–288 (2018) [563] Shu F Y, Wu L, Zhao H Y, Sui S H, Zhou L, Zhang J, He W X, He P, Xu B S. Microstructure and high-temperature wear mechanism of laser cladded CoCrBFeNiSi high-entropy alloy amorphous coating. Mater Lett 211: 235–238 (2018) [564] Shu F Y, Liu S, Zhao H Y, He W X, Sui S H, Zhang J, He P, Xu B S. Structure and high-temperature property of amorphous composite coating synthesized by laser cladding FeCrCoNiSiB high-entropy alloy powder. J Alloys Compd   
731: 662–666 (2018) [565] Cai $\textrm { Y C }$ , Chen Y, Luo Z, Gao F, Li L. Manufacturing of $\mathrm { F e C o C r N i C u } _ { x }$ medium-entropy alloy coating using laser cladding technology. Mater Des 133: 91–108 (2017) [566] Cai Y C, Chen Y, Manladan S M, Luo Z, Gao F, Li L. Influence of dilution rate on the microstructure and properties of FeCrCoNi high-entropy alloy coating. Mater Des 142: 124–137 (2018) [567] Li M, Gazquez J, Borisevich A, Mishra R, Flores K M. Evaluation of microstructure and mechanical property variations in $\operatorname { A l } _ { x } \operatorname { C o C r F e N i }$ high entropy alloys produced by a high-throughput laser deposition method. Intermetallics   
95: 110–118 (2018) [568] Jin G, Cai Z B, Guan Y J, Cui X F, Liu Z, Li Y, Dong M L, Zhang D. High temperature wear performance of lasercladded FeNiCoAlCu high-entropy alloy coating. Appl Surf Sci 445: 113–122 (2018) [569] Renz A, Prakash B, Hardell J, Lehmann O. High-temperature sliding wear behaviour of Stellite $^ { \mathfrak { s } } 1 2$ and Tribaloy $^ { \mathrm { \textregistered } } \mathrm { T } 4 0 0$ . Wear 402–403: 148–159 (2018) [570] Sassatelli P, Bolelli G, LassinanttiGualtieri M, Heinonen E, Honkanen M, Lusvarghi L, Manfredini T, Rigon R, Vippola M. Properties of HVOF-sprayed stellite-6 coatings. Surf Coat Technol 338: 45–62 (2018) [571] Janka L, Berger L M, Norpoth J, Trache R, Thiele S, Tomastik C, Matikainen V, Vuoristo P. Improving the high temperature abrasion resistance of thermally sprayed $\mathrm { C r } _ { 3 } \mathrm { C } _ { 2 }$ -NiCr coatings by WC addition. Surf Coat Technol   
337: 296–305 (2018) [572] Wang T, Ye F X. The elevated-temperature wear behavior evolution of HVOF sprayed tungsten carbide coatings: Respond to heat treatment. Int J Refract Met Hard Mater   
71: 92–100 (2018) [573] Hao E K, Zhao X Q, An Y L, Deng W, Zhou H D, Chen J M. The effect of pre-oxidation on microstructure, mechanical properties and high-temperature tribological behaviors of HVOF-sprayed NiCoCrAlYTa coating. Appl Surf Sci 489: 187–197 (2019) [574] Yang S, Meng X W, Liu J, Gui C B, Xia W S. Influence of oxidation on the high-temperature tribological properties of tungsten-carbide-reinforced Cu–Ni–Mn composite coatings. Metall Mater Trans A 50(4): 1936–1942 (2019) [575] Chen H F, Du Y X, Wang D J, Zhang C, Yang G, Liu B, Gao Y F, Shi S L. $\mathrm { T i C / T i _ { 3 } A l C _ { 2 } }$ –Co plasma-sprayed coatings with excellent high-temperature tribological properties. Ceram Int 44(18): 22520–22528 (2018) [576] Du Y X, Chen H F, Yang G, Liu B, Gao Y F, Luo H J. Effect of cobalt content on high-temperature tribological properties of TiC-Co coatings. Ceram Int 44(12): 14186–   
14194 (2018) [577] Zhang D, Cui X F, Jin G, Song Q L, Yuan C F, Fang Y C, Wen X. Microstructure and tribological performance of laser-cladded Ni60+h-BN coatings on Ti-6Al-4V alloy at high temperature. Tribol Trans 62(5): 779–788 (2019) [578] Tao H, Tsai M T, Chen H W, Huang J C, Duh J G. Improving high-temperature tribological characteristics on nanocomposite CrAlSiN coating by Mo doping. Surf Coat Technol 349: 752–756 (2018) [579] Niu R L, Li J L, Wang Y X, Chen J M, Xue Q J. Structure and high temperature tribological behavior of TiAlN/nitride duplex treated coatings on Ti6Al4V. Surf Coat Technol   
309: 232–241 (2017) [580] Liu J X, Yue W, Liang J, Hou B B, Sun J H, She D S, Gu Y H, Yi P. Effects of evaluated temperature on tribological behaviors of micro-arc oxidated 2219 aluminum alloy and their field application. Int J Adv Manuf Technol 96(5–8):   
1725–1740 (2018) [581] Yi P, Yue W, Liang J, Hou B B, Sun J H, Gu Y H, Liu J X. Effects of nanocrystallized layer on the tribological properties of micro-arc oxidation coatings on 2618 aluminum alloy under high temperatures. Int J Adv Manuf Technol   
96(5–8): 1635–1646 (2018) [582] Liu Z, Pickens III D, He T, Zhang X, Liu Y C, Nishino T, Wang Q J. A thermal elastohydrodynamic lubrication model for crowned rollers and its application on Apex seal-housing interfaces. J Tribol 141(4): 041501 (2019) [583] Zhang K F, Peng X N, Zhang Y Z, Zhou H, Ma M. Numerical thermal analysis of grease-lubrication in limited line contacts considering asperity contact. Tribol Int 134:   
372–384 (2019) [584] De La Guerra Ochoa E, Echávarri Otero J, Sánchez López A, ChacónTanarro E, Del Río López B. Film thickness formula for thermal EHL line contact considering a new Reynolds–Carreau equation. Tribol Lett 66(1): 31 (2018) [585] Kaneta M, Sperka P, Yang P R, Krupka I, Yang P, Hartl M. Thermal elastohydrodynamic lubrication of ceramic materials. Tribol Trans 61(5): 869–879 (2018) [586] Liu X L, Ma M M, Yang P R, Guo F. A new method for eyring shear-thinning models in elliptical contacts thermal elastohydrodynamic lubrication. J Tribol 140(5): 051503 (2018) [587] Liu H C, Zhang B B, Bader N, Guo F, Poll G, Yang P. Crucial role of solid body temperature on elastohydrodynamic film thickness and traction. Tribol Int 131: 386–397 (2019) [588] Félix Quiñonez A. Numerical analysis of transverse reciprocating velocity effects in EHL point contacts. Tribol Int 126: 1–8 (2018) [589] Abd Al-Samieh M F. Theoretical investigation of transient ultra-thin lubricant film during rapid deceleration. Tribol Int 40(3): 349–357 (2018) [590] Hultqvist T, Shirzadegan M, Vrcek A, Baubet Y, Prakash B, Marklund P, Larsson R. Elastohydrodynamic lubrication for the finite line contact under transient loading conditions. Tribol Int 127: 489–499 (2018) [591] Lu X Q, Dong Q B, Zhou K, Zhao B, Zhao B. Numerical analysis of transient elastohydrodynamic lubrication during startup and shutdown processes. J Tribol 140(4): 041504 (2018) [592] Zhu S C, Zhang W H, Nelias D. Alternative calculation on transient elasto-hydrodynamic lubrication. Ind Lubr Tribol   
70(2): 423–431 (2018) [593] Sun Y Y, Xiao H F, Xu J W, Yu W N. Study on the normal contact stiffness of the fractal rough surface in mixed lubrication. Proc Inst Mech Eng, Part J: J Eng Tribol   
232(12): 1604–1617 (2018) [594] Azam A, Dorgham A, Morina A, Neville A, Wilson M C T. A simple deterministic plastoelastohydrodynamic lubrication (PEHL) model in mixed lubrication. Tribol Int   
131: 520–529 (2019) [595] Zhang H, Dong G N, Dong G Z. A mixed elastohydrodynamic lubrication model based on virtual rough surface for studying the tribological effect of asperities. Ind Lubr Tribol 70(2): 408–417 (2018) [596] Wang Z J, Chen X Y, Shen X J. A mixed EHL model of finite-length line contact considering asperity elasto-plastic deformation and the lubricant properties. J Shanghai Jiaotong Univ 52(5): 525–532 (2018) [597] Pusterhofer M, Bergmann P, Summer F, Grün F, Brand C. A novel approach for modeling surface effects in hydrodynamic lubrication. Lubricants 6(1): 27 (2018) [598] Shettar B M, Hiremath P S, Bujurke N M. A novel numerical scheme for the analysis of effects of surface roughness on EHL line contact with couple stress fluid as lubricant. Sādhanā 43(8): 122 (2018) [599] Habchi W. A schur-complement model-order-reduction technique for the finite element solution of transient elastohydrodynamic lubrication problems. Adv Eng Softw   
127: 28–37 (2019) [600] Robbe-Valloire F, Progri R, Da Silva Botelho T. Theoretical analysis of the influence of asperity’s dimensions affected by a scale factor on the mixed lubrication between parallel surfaces. Adv Tribol 2018: 3702324 (2018)   
[601] Li T Y, Lu X Q, Ma X, Xu H Z, Jiao B W, Zhou D Q. Numerical and experimental analysis of the honing texture on the lubrication performance of piston ring-cylinder liner tribosystem. Tribol Trans 62(6): 991–1006 (2019)   
[602] Li S, Parmar U. The effects of microdimple texture on the friction and thermal behavior of a point contact. $J$ Tribol 140(4): 041503 (2018)   
[603] Bayada G. A fast algorithm for boundary slippage including mass flow conserving cavitation model. Tribol Int 118: 71–88 (2018)   
[604] Zhu B, Li Y P, Wang W G, Lei M K. Boundary slippage modeling and optimization of hydrophobic tilting pad thrust bearing with elastic deformation. Tribol Int 136: 299–316 (2019)   
[605] Savio D, Falk K, Moseler M. Slipping domains in waterlubricated microsystems for improved load support. Tribol Int 120: 269–279 (2018)   
[606] Zhang Y G, Wang W Z, Liang H, Zhao Z Q. Layered oil slip model for investigation of film thickness behaviours at high speed conditions. Tribol Int 131: 137–147 (2019)   
[607] Senatore A, Rao T V V L N. Partial slip texture slider and journal bearing lubricated with Newtonian fluids: A review. J Tribol 140(4): 040801 (2018)   
[608] Chu L M, Lin J R, Chang-Jian C W. Effects of adsorption layers and elastic deformation on thin-film lubrication of circular contacts with non-Newtonian lubricants. Ind Lubr Tribo l70(2): 363–370 (2018)   
[609] Azam A, Ghanbarzadeh A, Neville A, Morina A, Wilson M C T. Modelling tribochemistry in the mixed lubrication regime. Tribol Int 132: 265–274 (2019)   
[610] Guo F, Li S Y, Liu C L, Li X M, Liu X L. Film building in circular EHL contact lubricated by oil droplet groups. Lubr Sci 30(4): 149–159 (2018)   
[611] Moder J, Grün F, Gódor I. A modelling framework for the simulation of lubricated and dry line contacts. Tribol Int 120: 34–46 (2018)   
[612] Hartinger M, Reddyhoff T. CFD modeling compared to temperature and friction measurements of an EHL line contact. Tribol Int 126: 144–152 (2018)   
[613] Li B, Sun J, Zhu S Y, Fu Y Y, Zhao X Y, Wang H, Teng Q, Ren Y P, Li Y Q, Zhu G X. Thermohydrodynamic lubrication analysis of misaligned journal bearing considering the axial movement of journal. Tribol Int 135: 397–407 (2019)   
[614] Li S S, An Q. Lubrication performance of planar thrust bearing with consideration of roughness of the surfaces. Proc Inst Mech Eng, Part J: J Eng Tribol 233(7): 1046– 1058 (2019)   
[615] Liu H J, Liu H L, Zhu C C, Wei P T, Tang J Y. Tribological behavior of coated spur gear pairs with tooth surface roughness. Friction 7(2): 117–128 (2019)   
[616] Alakhramsing S S, De Rooij M B, Akchurin A, Schipper D J, Van Drogen M. A mixed-TEHL analysis of camroller contacts considering roller slip: On the influence of roller-pin contact friction. J Tribol 141(1): 011503 (2019)   
[617] Li L L, Yang J J. Surface roughness effects on point contact elastohydrodynamic lubrication in linear rolling guide with fractal surface topographies. Ind Lubr Tribol 70(4): 589–598 (2018)   
[618] Johnson K L. Contact Mechanics. Cambridge (UK): Cambridge University Press, 1987.   
[619] Johnson K L, Kendall K, Roberts A D. Surface energy and the contact of elastic solids. Proc Roy Soc A: Math, Phys Eng Sci 324(1558): 301–313 (1971)   
[620] Derjaguin B V, Muller V M, Toporov Y P. Effect of contact deformations on the adhesion of particles. J Colloid Interface Sci 53(2): 314–326 (1975)   
[621] Greenwood J A, Johnson K L. An alternative to the Maugis model of adhesion between elastic spheres. J Phys D Appl Phys 31(22): 3279–3290 (1998)   
[622] Zini N H M, De Rooij M B, Bazr Afshan Fadafan M, Ismail N, Schipper D J. Extending the double-hertz model to allow modeling of an adhesive elliptical contact. Tribol Lett 66(1): 30 (2018)   
[623] Li Q, Popov V L. Boundary element method for normal non-adhesive and adhesive contacts of power-law graded elastic materials. Comput Mech 61(3): 319–329 (2018)   
[624] Wu J J. Boundary element analyses on the adhesive contact between an elastic cylinder and a rigid half-space. Tribol Lett 67(1): 19 (2019)   
[625] Zhang Z M, Wang W, Wong P L. An explicit solution for the elastic quarter-space problem in matrix formulation. Int J Solids Struct 50(6): 976–980 (2013)   
[626] Zhang H B, Wang W Z, Zhang S G, Zhao Z Q. Modeling of elastic finite-length space rolling-sliding contact problem. Tribol Int 113: 224–237 (2017)   
[627] Guo L, Zhang Z M, Wang W, Wong P L. An explicit matrix algorithm for solving three-dimensional elastic wedge under surface loads. Int J Solids Struct 128: 231–242 (2017)   
[628] Stan G, Mays E, Yoo H J, King S W. The effect of edge compliance on the contact between a spherical indenter and a high-aspect-ratio rectangular fin. Exp Mech 58(7): 1157–1167 (2018)   
[629] Frérot L, Bonnet M, Molinari J F, Anciaux G. A Fourieraccelerated volume integral method for elastoplastic contact. Comput Methods Appl Mech Eng 351: 951–976 (2019)   
[630] Zhang H B, Wang W Z, Zhang S G, Zhao Z Q. Semianalytical solution of three-dimensional steady state thermoelastic contact problem of multilayered material under friction heating. Int J Therm Sci 127: 384–399 (2018) [631] Liu Y Q, Wang W Z, Zhang H B, Zhao Z Q. Solution of temperature distribution under frictional heating with consideration of material inhomogeneity. Tribol Int 126:   
80–96 (2018) [632] Bugnicourt R, Sainsot P, Dureisseix D, Gauthier C, Lubrecht A A. FFT-based methods for solving a rough adhesive contact: Description and convergence study. Tribol Lett   
66(1): 29 (2018) [633] Persson B N J. Theory of rubber friction and contact mechanics. J Chem Phys 115(8): 3840–3861 (2001) [634] Xu Y, Jackson R L. Boundary element method (BEM) applied to the rough surface contact vs. BEM in computational mechanics. Friction 7(4): 359–371 (2019) [635] Campañá C, Müser M H. Practical Green’s function approach to the simulation of elastic semi-infinite solids. Phys Rev B 74(7): 075420 (2006) [636] Greenwood J A, Williamson J B P. Contact of nominally flat surfaces. Proc Roy Soc A: Math, Phys Eng Sci   
295(1442): 300–319 (1966) [637] Tysoe W T, Spencer N D. Contact-mechanics challenge. Tribol Lubr Technol 71(12): 96 (2015) [638] Müser M H, Dapp W B, Bugnicourt R, Sainsot P, Lesaffre N, Lubrecht T A, Persson B N J, Harris K, Bennett A, Schulze K, et al. Meeting the contact-mechanics challenge. Tribol Lett 65(4): 118 (2017) [639] Carpick R W.The contact sport of rough surfaces. Science   
359(6371): 38 (2018) [640] Ekberg A, Pålsson B A. Multiscale modelling of train-track interaction phenomena with focus on contact mechanics. Wear 430–431: 393–400 (2019) [641] Ma X C, Wang P, Xu J M, Chen R, Wang J. Assessment of non-Hertzian wheel-rail contact models for numerical simulation of rail damages in switch panel of railway turnout. Wear 432–433: 102912 (2019) [642] Zhang X, He T, Miwa H, Nanbu T, Murakami R, Liu S B, Cao J, Wang Q J. A new approach for analyzing the temperature rise and heat partition at the interface of coated tool tip-sheet incremental forming systems. Int $J$ Heat Mass Transfer 129: 1172–1183 (2019) [643] Zhang X, Wang Z J, Shen H M, Wang Q J. An efficient model for the frictional contact between two multiferroic bodies. Int J Solids Struct 130–131: 133–152 (2018) [644] Zhang H, Wang W, Liu Y, Zhao Z. Semi-analytic modeling of transversely isotropic magneto-electro-elastic materials under frictional sliding contact. Applied Mathematical Modeling 75: 116–140 (2019) [645] Archard J F. Contact and rubbing of flat surfaces. J Appl Phys 24(8): 981–988 (1953) [646] Meng H C, Ludema K C. Wear models and predictive equations: Their form and content. Wear 181–183: 443–457 (1995)   
[647] Zhu D, Martini A, Wang W Z, Hu Y Z, Lisowsky B, Wang Q J. Simulation of sliding wear in mixed lubrication. J Tribol Trans129(3): 544–552 (2007)   
[648] Zhang Y Z, Cao H, Kovalev A, Meng Y G. Numerical running-in method for modifying cylindrical roller profile under mixed lubrication of finite line contacts. J Tribol 141(4): 041401 (2019)   
[649] Pei X, Pu W, Zhang Y, Huang L. Surface topography and friction coefficient evolution during sliding wear in a mixed lubricated rolling-sliding contact. Tribol Int 137: 303–312 (2019)   
[650] Zhan W L, Huang P. Numerical analysis of time-varying wear with elastic deformation in line contact. Friction 7(2): 143–152 (2019)   
[651] Dimaki A V, Dmitriev A I, Menga N, Papangelo A, Ciavarella M, Popov V L. Fast high-resolution simulation of the gross slip wear of axially symmetric contacts. Tribol Trans 59(1): 189–194 (2016)   
[652] Prajapati D K, Tiwari M. 3D numerical wear model for determining the change in surface topography. Surf Topogr: Metrol Prop 6(4): 045006 (2018)   
[653] Lu J J, An Q. Calculating method for the wear of metalto-metal dry sliding based on elastic–plastic contact theory. Proc Inst Mech Eng, Part J: J Eng Tribol 232(10): 1215– 1229 (2018)   
[654] Li L, Kang L, Ma S Y, Li Z Q, Ruan X G, Cai A J. Finite element analysis of fretting wear considering variable coefficient of friction.Proc Inst Mech Eng, Part J: J Eng Tribol 233(5): 758–768 (2019)   
[655] Krejčí P, Petrov A.A mathematical model for the thirdbody concept. Math Mech Solids 23(3): 420–432 (2018)   
[656] Messa G V, Mandelli S, Malavasi S. Hydro-abrasive erosion in Pelton turbine injectors: A numerical study. Renew Energy 130: 474–488 (2019)   
[657] Özen I, Gedikli H. Solid particle erosion on shield surface of a helicopter rotor blade using computational fluid dynamics. J Aerosp Eng 32(1): 04018131 (2019)   
[658] Qiang Z R, Wu M P, Miao X J, Sawhney R. CFD research on particle movement and nozzle wear in the abrasive water jet cutting head. Int J Adv Manuf Technol 95(9–12): 4091–4100 (2018)   
[659] Sedrez T A, Shirazi S A, Rajkumar Y R, Sambath K, Subramani $_ { \mathrm { ~ H ~ J ~ } }$ . Experiments and CFD simulations of erosion of a $9 0 ^ { \circ }$ elbow in liquid-dominated liquid-solid and dispersed-bubble-solid flows. Wear 426–427: 570–580 (2019)   
[660] Kannojiya V, Deshwal M, Deshwal D. Numerical analysis of solid particle erosion in pipe elbow. Mater Today: Proc 5(2): 5021–5030 (2018)   
[661] Darihaki F, Zhang J, Shirazi S A. Solid particle erosion in gradual contraction geometry for a gas-solid system. Wear 426–427: 643–651 (2019)   
[662] Biswas S, Williams K, Jones M. Development of a constitutive model for erosion based on dissipated particle energy to predict the wear rate of ductile metals. Wear 404–405: 166–175 (2018)   
[663] Leguizamón S, Jahanbakhsh E, Alimirzazadeh S, Maertens A, Avellan F. FVPM numerical simulation of the effect of particle shape and elasticity on impact erosion. Wear 430–431: 108–119 (2019)   
[664] Akchurin A, Bosman R, Lugt P M. A stress-criterionbased model for the prediction of the size of wear particles in boundary lubricated contacts. Tribol Lett 64(3): 35 (2016)   
[665] Rabinowicz E. The effect of size on the looseness of wear fragments. Wear 2(1): 4–8 (1958)   
[666] Li T Y, Shi J, Wang S P, Zio E, Ma Z H. Mesoscale numerical modeling for predicting wear debris generation. Tribol Int 67(2): 38 (2019)   
[667] Fillot N, Iordanoff I, Berthier Y. Modelling third body flows with a discrete element method—a tool for understanding wear with adhesive particles. Tribol Int 40(6): 973–981 (2007)   
[668] Abbas R K. A review on the wear of oil drill bits (conventional and the state of the art approaches for wear reduction and quantification). Eng Fail Anal 90: 554–584 (2018)   
[669] Liu Z G, Wan S, Nguyen V B, Zhang Y W. Finite element analysis of erosive wear for offshore structure. In Proceedings of the 13th International Conference on Fracture, Beijing, 2013: 16–21.   
[670] Hadavi V, Arani N H, Papini M. Numerical and experimental investigations of particle embedment during the incubation period in the solid particle erosion of ductile materials. Tribol Int 129: 38–45 (2019)   
[671] Dong X W, Li Z L, Mao Z R, Lin T.A development of a SPH model for simulating surface erosion by impact(s) of irregularly shaped particles. Int J Comput Methods 15(8): 1850074 (2018)   
[672] Basseville S, Missoum-Benziane D, Cailletaud G. 3D finite element study of the fatigue damage of Ti–6Al–4V in presence of fretting wear. Comput Mech 64(3): 663–683 (2019)   
[673] Cardoso R A, Doca T Néron D, Pommier S, Araújo J A. Wear numerical assessment for partial slip fretting fatigue conditions. Tribol Int 136: 508–523 (2019)   
[674] Llavori I, Zabala A, Urchegui M A, Tato W, Gómez X. A coupled crack initiation and propagation numerical procedure for combined fretting wear and fretting fatigue lifetime assessment. Theor Appl Fract Mech 101: 294–305 (2019)   
[675] Arunachalam A P S, Idapalapati S. Material removal analysis for compliant polishing tool using adaptive meshing technique and Archard wear model. Wear 418–419: 140–150 (2019)   
[676] Mosavat M, Rahimi A. Numerical-experimental study on polishing of silicon wafer using magnetic abrasive finishing process.Wear 424–425: 143–150 (2019)   
[677] Ghanbarzadeh A, Piras E, Wilson M C T, Morina A, Neville A. Numerical study of the effect of tribofilm kinetics and its hardness on the roughness evolution of the substrate in boundary lubrication regime. Tribol Trans 62(5): 747–759 (2019)   
[678] Sun Y, Guo Y, Zhai W M. Prediction of rail non-uniform wear–influence of track random irregularity. Wear 420–421: 235–244 (2019)   
[679] Liu H Z, Zong W J. Prediction model of tool wear volume in precision turning of ceramic particle reinforced aluminum matrix composites. Int J Adv Manuf Technol 100(9–12): 2689–2700 (2019)   
[680] Chaturvedi S, Bharti P K, Yadav S K, Singh S. A finite element simulation of MOM (metal-on-metal) hip implant. Lubr Sci 31(5): 210–217 (2019)   
[681] König F, Chaib A O, Jacobs G, Sous C. A multiscaleapproach for wear prediction in journal bearing systems– from wearing-in towards steady-state wear. Wear 426–427: 1203–1211 (2019)   
[682] Renouf M, Massi F, Fillot N, Saulot A. Numerical tribology of a dry contact. Tribol Int 44(7–8): 834–844 (2011)   
[683] Tran A, Furlan J M, Pagalthivarthi K V, Visintainer R J, Wildey T, Wang Y. WearGP: A computationally efficient machine learning framework for local erosive wear predictions via nodal Gaussian processes. Wear 422–423: 9–26 (2019)   
[684] He X L, Lu J, Desanker M, Invergo A M, Lohr T L, Ren N, Lockwood F E, Marks T J, Chung Y W, Wang Q J. Boundary lubrication mechanisms for high-performance friction modifiers. ACS Appl Mater Interfaces 10(46): 40203–40211 (2018)   
[685] Aghababaei R, Warner D H, Molinari J F. Critical length scale controls adhesive wear mechanisms. Nat Commun 7: 11816 (2016)   
[686] Aghababaei R. Effect of adhesion on material removal during adhesive wear. Phys Rev Mater 3(6): 063604 (2019)   
[687] Aghababaei R, Warner D H, Molinari J F.On the debrislevel origins of adhesive wear. Proc Natl Acad Sci USA 114(30): 7935–7940 (2017)   
[688] Aghababaei R, Brink T, Molinari J F. Asperity-level origins of transition from mild to severe wear. Phys Rev Lett 120(18): 186105 (2018)   
[689] Xie W K, Fang F Z, Mechanism of atomic and close-toatomic scale cutting of monocrystalline copper. Appl Surf Sci 503: 144239 (2020)   
[690] Han X L, Liu P, Sun D L, Wang Q. An atomic-level understanding of the friction and wear behaviors of Ti2AlN/TiAl composite via MD simulations. Tribol Int 137: 340–348 (2019)   
[691] Wang Q, Fang Q H, Li J, Tian Y Y, Liu Y W. Subsurface damage and material removal of Al-Si bilayers under highspeed grinding using molecular dynamics (MD) simulation. Appl Phys A 125(8): 514 (2019)   
[692] Wang L F, Duan F L. Nanoscale wear mechanisms of few-layer graphene sheets induced by interfacial adhesion. Tribol Int 123: 266–272 (2018)   
[693] Klemenz A, Gola A, Moseler M, Pastewka L. Contact mechanics of graphene-covered metal surfaces. Appl Phys Lett 112(6): 061601 (2018)   
[694] Xu Q, Li X, Zhang J, Hu Y Z, Wang H, Ma T B. Suppressing nanoscale wear by graphene/graphene interfacial contact architecture: A molecular dynamics study. ACS Appl Mater Interfaces 9(46): 40959–40968 (2017)   
[695] Qi Y Z, Liu J, Zhang J, Dong Y L, Li Q Y. Wear resistance limited by step edge failure: The rise and fall of graphene as an atomically thin lubricating material. ACS Appl Mater Interfaces 9(1): 1099–1106 (2017)   
[696] Qi Y Z, Liu J, Dong Y L, Feng X Q, Li Q Y. Impacts of environments on nanoscale wear behavior of graphene: Edge passivation vs. substrate pinning. Carbon 139: 59–66 (2018)   
[697] Zhang J, Chen X C, Xu Q, Ma T B, Hu Y Z, Wang H, Tieu A K, Luo J B. Effects of grain boundary on wear of graphene at the nanoscale: A molecular dynamics study. Carbon 143: 578–586 (2019)   
[698] Ren C X, Li X X, Guo L. Reaction mechanisms in the thermal decomposition of CL-20 revealed by ReaxFF molecular dynamics simulations. Acta Phys-Chim Sin 34(10): 1151–1162 (2018)   
[699] Chen L, Wen J L, Zhang P, Yu B J, Chen C, Ma T B, Lu X C, Kim S H, Qiao L M. Nanomanufacturing of silicon surface with a single atomic layer precision via mechanochemical reactions. Nat Commun 9(1): 1542 (2018)   
[700] Shi Z Y, Jin Z J, Guo X G, Yuan S, Guo J. Insights into the atomistic behavior in diamond chemical mechanical polishing with OH environment using ReaxFF molecular dynamics simulation. Comput Mater Sci 166: 136–142 (2019)   
[701] Wen J L, Ma T B, Zhang W W, van Duin A C T, van Duin D M, Hu Y Z, Lu X C. Atomistic insights into $\mathrm { C u }$ chemical mechanical polishing mechanism in aqueous hydrogen peroxide and glycine: ReaxFF reactive molecular dynamics simulations. $J$ Phys Chem C 123: 26467–26474 (2019)   
[702] Ootani Y, Xu J X, Hatano T, Kubo M. Contrasting roles of water at sliding interfaces between silicon-based materials: First-principles molecular dynamics sliding simulations. J Phys Chem C 122(19): 10459–10467 (2018)   
[703] Loehlé S, Righi M. Ab initio molecular dynamics simulation of tribochemical reactions involving phosphorus additives at sliding iron interfaces. Lubricants 6(2): 31 (2018)   
[704] Vakis A I, Yastrebov V A, Scheibert J, Nicola L, Dini D, Minfray C, Almqvist A, Paggi M, Lee S, Limbert G, et al. Modeling and simulation in tribology across scales: An overview. Tribol Int 125: 169–199 (2018)   
[705] Restuccia P, Levita G, Wolloch M, Losi G, Fatti G, Ferrario M, Righi M C. Ideal adhesive and shear strengths of solid interfaces: A high throughput ab initio approach. Comput Mater Sci 154: 517–529 (2018)   
[706] Gao L, Ma Y, Liu Y M, Song A S, Ma T B, Hu Y Z, Su Y J, Qiao L J. Anomalous frictional behaviors of Ir and Au tips sliding on graphene/Ni(111) substrate: Density functional theory calculations. J Phys Chem $C$ 121(39): 21397–21404 (2017)   
[707] Gao L, Chen X C, Ma Y, Yan Y, Ma T B, Su Y J, Qiao L J. Origin of the moiré superlattice scale lateral force modulation of graphene on a transition metal substrate. Nanoscale 10(22): 10576–10583 (2018)   
[708] Shi R Y, Gao L, Lu H L, Li Q Y, Ma T B, Guo H, Du S X, Feng X Q, Zhang S, Liu Y M, et al. Moiré superlatticelevel stick-slip instability originated from geometrically corrugated graphene on a strongly interacting substrate. 2D Mater 4(2): 025079 (2017)   
[709] Yang Z Z, Bhowmick S, Sen F G, Banerji A, Alpas A T. Roles of sliding-induced defects and dissociated water molecules on low friction of graphene. Sci Rep 8: 121 (2018)   
[710] Ma Y, Gao L, Song A S, Yan Y, Chen X C, Su Y J, Qiao

L J.Preservation of the frictional properties of h-BN under chemicalmodification in the presence of a commensurate Ni(1 1 1) substrate. Comput Mater Sci 165: 82–87 (2019) [711] Yang J, Qi Y, Kim H D, Rappe A M. Mechanism of benzene tribopolymerization on the $\mathrm { R u O } _ { 2 } ( 1 1 0 )$ surface. Phys Rev Appl 9(4): 044038 (2018) [712] Zhang H, Fu Z H, Legut D, Germann T C, Zhang R F. Stacking stability and sliding mechanism in weakly bonded 2D transition metal carbides by van der Waals force. RSC Adv 7(88): 55912–55919 (2017) [713] Zhang D F, Ashton M, Ostadhossein A, Van Duin A C T, Hennig R G, Sinnott S B. Computational study of low interlayer friction in $\mathrm { T i } _ { n + 1 } \mathrm C _ { n }$ $[ n = 1 , 2$ , and 3) MXene. ACS Appl Mater Interfaces 9(39): 34467–34479 (2017) [714] Wang J J, Li L, Shen Z T, Guo P, Li M, Zhao B, Fang L L, Yang L F. Ultralow interlayer friction of layered electride $\mathrm { C a } _ { 2 } \mathrm { N }$ : A potential two-dimensional solid lubricant material. Materials (Basel) 11(12): 2462 (2018) [715] Zhu A B, He D Y, He S L, Luo W C. Material removal mechanism of copper chemical mechanical polishing with different particle sizes based on quasi-continuum method. Friction 5(1): 99–107 (2017) [716] Tran A S, Fang T H, Tsai L R, Chen C H. Friction and scratch characteristics of textured and rough surfaces using the quasi-continuum method. J Phys Chem Solids 126: 180–188 (2019) [717] Hou Y, Wang X F, Sun W J, Wang L B.A multiscale DEM-FEM approach to investigate the tire-pavement friction. Int J Pavement Eng 19(5): 399–406 (2018) [718] Wen J L, Ma T B, Zhang W W, Van Duin A C T, Lu X C. Atomistic mechanisms of Si chemical mechanical polishing in aqueous $\mathrm { H } _ { 2 } \mathrm { O } _ { 2 }$ : ReaxFF reactive molecular dynamics simulations. Comput Mater Sci 131: 230–238 (2017) [719] Savio D, Fillot N, Vergne P, Hetzler H, Seemann W, Morales Espejel G E. A multiscale study on the wall slip effect in a ceramic-steel contact with nanometer-thick lubricant film by a nano-to-elastohydrodynamic lubrication approach. J Tribol 137(3): 031502 (2015) [720] Information.http://mmm2018.jp/, 2018.

![](images/b2c9d8aa679b6e01c3976f3c375ae4f51c9d55f25992e21715a5830d4e4fca9f.jpg)

Yonggang MENG. He received his M.S. and Ph.D. degrees in mechanical engineering from Kumamoto University, Japan, in 1986 and 1989, respectively. He joined the State

Key Laboratory of Tribology at Tsinghua University from 1990. His current position is a professor, and his research areas cover the tribology of MEMS and hard disk drives, active control of friction and interfacial phenomena, and nanomanufacturing.

![](images/93183ab5912b92c4cbaee729e189ca414912e35c5f415066ca239305c075b7b2.jpg)

Jun XU. She received the B.S. degree in physics from Henan Normal University in 2003, the M.S. degree in condensed matter physics from Henan University in 2006, and the Ph.D. degree in mechanical engineering from Tsinghua University in 2012. After that, she spent two years at State Key Laboratory of Tribology, Tsinghua University, China for postdoctoral research. Then she works at Tsinghua University as a communication editor of the journal Friction and shows more interest in tribology.

![](images/b0893064ad6a3eed958de8012566803db93838c5efa791496915a452c4adadc4.jpg)

Zhongmin JIN. He is a distinguished professor (Thousand Talent Programme), School of Mechanical Engineering, Southwest Jiaotong University, China, and part-time professor of Computational Bioengineering, School of Mechanical Engineering, the University of Leeds,

UK. He obtained his B.S. degree from Xi’an Jiaotong University in China in 1983 and Ph.D. from the University of Leeds, UK in 1988. He has been a member of the Institution of Mechanical Engineers (UK) since 1995 and fellow of the Chinese Tribology Institution. His research interests include biotribology of artificial joints, tissue engineering, and finite element modelling.

![](images/0ccb311638e0b780c45fd93671199c24a264b22b4e9e033c58349db370807d62.jpg)

Braham PRAKASH. He is presently distinguished visiting professor at Tsinghua University (China) and professor emeritus at Luleå University of Technology (Sweden). He obtained his B.Sc. (engineering mechanical) degree from Punjab Engineering College Chandigarh (1974) and M.Tech. (mechanical engineering) as well as Ph.D. (Tribology) degrees (1976, 1993) from Indian Institute of Technology Delhi (India). He was a professor and head of Tribolab at the Division of Machine Elements of Luleå University of Technology from 2002−2019. Prior to this, he was a faculty at

Indian Institute of Technology Delhi (1981−2002) and R & D professional in industry (1976−1981). He was a visiting researcher at Tokyo Institute of Technology (1985) and fellow of Japan Society for the Promotion of Science (JSPS) at Chiba Institute of Technology (1998−2000). He was visiting professor at Tokyo University of Science (2016) as well as at Indian Institute of Technology, Ropar (2010−2013). His research and teaching activities pertain to high temperature tribology, tribology of materials and lubricants, solid lubricants/self-lubricating coatings, boundary lubrication, tribology of machine components (bearings, gears, and seals), analysis of wear problems, and tribotesting.

![](images/530d2a6047956dd9efed3764c4f6f1872e1e147829161fdd0668961628ba8de4.jpg)

Yuanzhong HU. He received his bachelor degree in 1968 and Ph.D. degree in mechanical engineering in 1985, both from Tsinghua University, and joined the State Key Laboratory of Tribology at Tsinghua University since then. He has been a professor in Tsinghua University until retired in 2012. His research interests include elastohydrodynamic and mixed lubrication, contact mechanics, computer simulations of tribological process, nanotribology, and fundamental understanding of friction.